/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.ByteType;
import soot.CharType;
import soot.ErroneousType;
import soot.G;
import soot.Local;
import soot.Scene;
import soot.ShortType;
import soot.Singletons;
import soot.Type;
import soot.UnknownType;
import soot.jimple.JimpleBody;
import soot.jimple.toolkits.typing.TypeResolver;
import soot.jimple.toolkits.typing.fast.AugHierarchy;
import soot.options.JBTROptions;
import soot.options.Options;

public class TypeAssigner
extends BodyTransformer {
    private boolean ignoreWrongStaticNess;

    public TypeAssigner(Singletons.Global g) {
    }

    public static TypeAssigner v() {
        return G.v().soot_jimple_toolkits_typing_TypeAssigner();
    }

    public boolean ignoreWrongStaticNess() {
        return this.ignoreWrongStaticNess;
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map options) {
        if (b == null) {
            throw new NullPointerException();
        }
        Date start = new Date();
        if (Options.v().verbose()) {
            G.v().out.println("[TypeAssigner] typing system started on " + start);
        }
        JBTROptions opt = new JBTROptions(options);
        this.ignoreWrongStaticNess = opt.ignore_wrong_staticness();
        if (opt.compare_type_assigners()) {
            this.compareTypeAssigners(b, opt.use_older_type_assigner());
        } else if (opt.use_older_type_assigner()) {
            TypeResolver.resolve((JimpleBody)b, Scene.v());
        } else {
            new soot.jimple.toolkits.typing.fast.TypeResolver((JimpleBody)b).inferTypes();
        }
        Date finish = new Date();
        if (Options.v().verbose()) {
            long runtime = finish.getTime() - start.getTime();
            long mins = runtime / 60000L;
            long secs = runtime % 60000L / 1000L;
            G.v().out.println("[TypeAssigner] typing system ended. It took " + mins + " mins and " + secs + " secs.");
        }
        if (this.typingFailed((JimpleBody)b)) {
            throw new RuntimeException("type inference failed!");
        }
    }

    private void compareTypeAssigners(Body b, boolean useOlderTypeAssigner) {
        JimpleBody oldJb;
        long oldTime;
        long newTime;
        JimpleBody newJb;
        JimpleBody jb = (JimpleBody)b;
        int size = jb.getUnits().size();
        if (useOlderTypeAssigner) {
            newJb = (JimpleBody)jb.clone();
            newTime = System.currentTimeMillis();
            new soot.jimple.toolkits.typing.fast.TypeResolver(newJb).inferTypes();
            newTime = System.currentTimeMillis() - newTime;
            oldTime = System.currentTimeMillis();
            TypeResolver.resolve(jb, Scene.v());
            oldTime = System.currentTimeMillis() - oldTime;
            oldJb = jb;
        } else {
            oldJb = (JimpleBody)jb.clone();
            oldTime = System.currentTimeMillis();
            TypeResolver.resolve(oldJb, Scene.v());
            oldTime = System.currentTimeMillis() - oldTime;
            newTime = System.currentTimeMillis();
            new soot.jimple.toolkits.typing.fast.TypeResolver(jb).inferTypes();
            newTime = System.currentTimeMillis() - newTime;
            newJb = jb;
        }
        int cmp = newJb.getLocals().size() < oldJb.getLocals().size() ? 2 : (newJb.getLocals().size() > oldJb.getLocals().size() ? -2 : TypeAssigner.compareTypings(oldJb, newJb));
        G.v().out.println("cmp;" + jb.getMethod() + ";" + size + ";" + oldTime + ";" + newTime + ";" + cmp);
    }

    private boolean typingFailed(JimpleBody b) {
        for (Local l : b.getLocals()) {
            if (!l.getType().equals(UnknownType.v()) && !l.getType().equals(ErroneousType.v())) continue;
            return true;
        }
        return false;
    }

    private static int compareTypings(JimpleBody a, JimpleBody b) {
        int r = 0;
        Iterator<Local> ib = b.getLocals().iterator();
        for (Local v : a.getLocals()) {
            Type tb;
            Type ta = v.getType();
            if (soot.jimple.toolkits.typing.fast.TypeResolver.typesEqual(ta, tb = ib.next().getType()) || ta instanceof CharType && (tb instanceof ByteType || tb instanceof ShortType) || tb instanceof CharType && (ta instanceof ByteType || ta instanceof ShortType)) continue;
            if (AugHierarchy.ancestor_(ta, tb)) {
                if (r == -1) {
                    return 3;
                }
                r = 1;
                continue;
            }
            if (AugHierarchy.ancestor_(tb, ta)) {
                if (r == 1) {
                    return 3;
                }
                r = -1;
                continue;
            }
            return 3;
        }
        return r;
    }
}

