/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.robovm.llvm.LlvmException;
import org.robovm.llvm.TargetMachine;
import org.robovm.llvm.binding.CodeGenOptLevel;
import org.robovm.llvm.binding.CodeModel;
import org.robovm.llvm.binding.LLVM;
import org.robovm.llvm.binding.RelocMode;
import org.robovm.llvm.binding.StringOut;
import org.robovm.llvm.binding.TargetMachineRef;
import org.robovm.llvm.binding.TargetRef;

public class Target {
    private static final String HOST_TRIPLE = LLVM.getLlvmHostTriple();
    protected TargetRef ref;
    private String name;
    private String description;

    Target(TargetRef ref) {
        this.ref = ref;
        this.name = LLVM.GetTargetName(ref);
        this.description = LLVM.GetTargetDescription(ref);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasJIT() {
        return LLVM.TargetHasJIT(this.ref);
    }

    public boolean hasTargetMachine() {
        return LLVM.TargetHasTargetMachine(this.ref);
    }

    public boolean hasAsmBackend() {
        return LLVM.TargetHasAsmBackend(this.ref);
    }

    public TargetMachine createTargetMachine(String triple) {
        return this.createTargetMachine(triple, null, null, null, null, null);
    }

    public TargetMachine createTargetMachine(String triple, String cpu, String features, CodeGenOptLevel optLevel, RelocMode relocMode, CodeModel codeModel) {
        if (triple == null) {
            throw new NullPointerException("triple");
        }
        TargetMachineRef machineRef = LLVM.CreateTargetMachine(this.ref, triple, cpu = cpu == null ? "" : cpu, features = features == null ? "" : features, optLevel = optLevel == null ? CodeGenOptLevel.CodeGenLevelDefault : optLevel, relocMode = relocMode == null ? RelocMode.RelocDefault : relocMode, codeModel = codeModel == null ? CodeModel.CodeModelDefault : codeModel);
        if (machineRef == null) {
            throw new LlvmException("Failed to create TargetMachine for triple '" + triple + "'");
        }
        return new TargetMachine(machineRef);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ref == null ? 0 : this.ref.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Target other = (Target)obj;
        return !(this.ref == null ? other.ref != null : !this.ref.equals(other.ref));
    }

    public static String getHostTriple() {
        return HOST_TRIPLE;
    }

    public static Target getHostTarget() {
        return Target.lookupTarget(HOST_TRIPLE);
    }

    public static Target getTarget(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        TargetRef ref = LLVM.GetFirstTarget();
        while (ref != null) {
            if (name.equals(LLVM.GetTargetName(ref))) {
                return new Target(ref);
            }
            ref = LLVM.GetNextTarget(ref);
        }
        throw new LlvmException("No target with name '" + name + "' found");
    }

    public static Target lookupTarget(String triple) {
        if (triple == null) {
            throw new NullPointerException("triple");
        }
        StringOut ErrorMessage = new StringOut();
        TargetRef ref = LLVM.LookupTarget(triple, ErrorMessage);
        if (ref == null) {
            throw new LlvmException(ErrorMessage.getValue().trim());
        }
        return new Target(ref);
    }

    public static List<Target> getTargets() {
        ArrayList<Target> result = new ArrayList<Target>();
        TargetRef ref = LLVM.GetFirstTarget();
        while (ref != null) {
            result.add(new Target(ref));
            ref = LLVM.GetNextTarget(ref);
        }
        return result;
    }

    public static Map<String, Target> getTargetsMap() {
        TreeMap<String, Target> result = new TreeMap<String, Target>();
        for (Target target : Target.getTargets()) {
            result.put(target.name, target);
        }
        return result;
    }
}

