/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice.binding;

import org.robovm.libimobiledevice.binding.IDeviceInfo;
import org.robovm.libimobiledevice.binding.LibIMobileDeviceJNI;

public class IDeviceInfoArray {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected IDeviceInfoArray(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IDeviceInfoArray obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(IDeviceInfoArray obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LibIMobileDeviceJNI.delete_IDeviceInfoArray(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setValue(IDeviceInfo value) {
        LibIMobileDeviceJNI.IDeviceInfoArray_value_set(this.swigCPtr, this, IDeviceInfo.getCPtr(value), value);
    }

    public IDeviceInfo getValue() {
        long cPtr = LibIMobileDeviceJNI.IDeviceInfoArray_value_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new IDeviceInfo(cPtr, false);
    }

    public IDeviceInfoArray(int nelements) {
        this(LibIMobileDeviceJNI.new_IDeviceInfoArray(nelements), true);
    }

    public IDeviceInfo get(int index) {
        long cPtr = LibIMobileDeviceJNI.IDeviceInfoArray_get(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new IDeviceInfo(cPtr, false);
    }

    public void set(int index, IDeviceInfo value) {
        LibIMobileDeviceJNI.IDeviceInfoArray_set(this.swigCPtr, this, index, IDeviceInfo.getCPtr(value), value);
    }
}

