/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.gradle.tasks;

import java.io.IOException;
import java.util.ArrayList;
import org.robovm.compiler.AppCompiler;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.gradle.RoboVMGradleException;
import org.robovm.gradle.tasks.AbstractRoboVMTask;

public abstract class AbstractRoboVMBuildTask
extends AbstractRoboVMTask {
    protected abstract boolean shouldArchive();

    @Override
    public void invoke() {
        try {
            Config.Builder builder = this.configure(new Config.Builder()).skipInstall(false);
            if (this.extension.getArchs() != null) {
                ArrayList<Arch> archs = new ArrayList<Arch>();
                for (String s : this.extension.getArchs().trim().split(":")) {
                    archs.add(Arch.parse((String)s));
                }
                builder.archs(archs);
            }
            AppCompiler compiler = new AppCompiler(builder.build());
            compiler.build();
            if (this.shouldArchive()) {
                compiler.archive();
            } else {
                compiler.install();
            }
        }
        catch (IOException e) {
            if (this.shouldArchive()) {
                throw new RoboVMGradleException("Failed to create archive", e);
            }
            throw new RoboVMGradleException("Failed to install", e);
        }
    }
}

