/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.gradle;

import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.robovm.compiler.Version;
import org.robovm.gradle.RoboVMPluginExtension;
import org.robovm.gradle.tasks.ArchiveTask;
import org.robovm.gradle.tasks.ConsoleTask;
import org.robovm.gradle.tasks.IOSDeviceTask;
import org.robovm.gradle.tasks.IPadSimulatorTask;
import org.robovm.gradle.tasks.IPhoneSimulatorTask;
import org.robovm.gradle.tasks.InstallTask;
import org.robovm.gradle.tooling.ModelBuilder;

public class RoboVMPlugin
implements Plugin<Project> {
    private final ToolingModelBuilderRegistry registry;

    public static String getRoboVMVersion() {
        return Version.getCompilerVersion();
    }

    @Inject
    public RoboVMPlugin(ToolingModelBuilderRegistry registry) {
        this.registry = registry;
    }

    public void apply(Project project) {
        this.registry.register((ToolingModelBuilder)new ModelBuilder());
        project.getExtensions().create("robovm", RoboVMPluginExtension.class, new Object[]{project});
        this.registerTask(project, "launchIPhoneSimulator", IPhoneSimulatorTask.class, "Runs your iOS app in the iPhone simulator");
        this.registerTask(project, "launchIPadSimulator", IPadSimulatorTask.class, "Runs your iOS app in the iPad simulator");
        this.registerTask(project, "launchIOSDevice", IOSDeviceTask.class, "Runs your iOS app on a connected iOS device.");
        this.registerTask(project, "launchConsole", ConsoleTask.class, "Runs a console app");
        this.registerTask(project, "createIPA", ArchiveTask.class, "Creates .ipa file. This is an alias for the robovmArchive task");
        this.registerTask(project, "robovmArchive", ArchiveTask.class, "Compiles a binary, archives it in a format suitable for distribution and saves it to build/robovm/");
        this.registerTask(project, "robovmInstall", InstallTask.class, "Compiles a binary and installs it to build/robovm/");
    }

    private <T extends Task> void registerTask(Project project, String name, Class<T> type, String description) {
        this.registerTask(project, name, type, description, "build");
    }

    private <T extends Task> void registerTask(Project project, String name, Class<T> type, String description, String ... dependencies) {
        project.getTasks().register(name, type, task -> {
            task.dependsOn((Object[])dependencies);
            task.setDescription(description);
        });
    }
}

