/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.vm;

import java.util.List;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.utils.Converter;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpVmAllClassesHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpVmAllClassesHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        Object object = this.state.centralLock();
        synchronized (object) {
            List<ClassInfo> classes = this.state.classInfoLoader().classes();
            output.writeInt32(0);
            int cnt = 0;
            for (ClassInfo classInfo : classes) {
                if (classInfo.isPrimitive()) continue;
                output.writeByte(Converter.jdwpTypeTag(classInfo));
                output.writeLong(classInfo.refId());
                output.writeStringWithLen(classInfo.signature());
                output.writeInt32(Converter.jdwpClassStatus(classInfo));
                ++cnt;
            }
            output.setPosition(0L);
            output.writeInt32(cnt);
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 1;
    }

    @Override
    public byte getCommand() {
        return 3;
    }

    public String toString() {
        return "VirtualMachine(1).AllClasses(3)";
    }
}

