/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.objectreference;

import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.instances.VmInstance;
import org.robovm.debugger.utils.Converter;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpObjRefReferenceTypeHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpObjRefReferenceTypeHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        long objectId = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            Object instance = this.state.referenceRefIdHolder().instanceById(objectId);
            if (instance == null) {
                return 20;
            }
            output.writeByte(Converter.jdwpTypeTag(((VmInstance)instance).classInfo()));
            output.writeLong(((VmInstance)instance).classInfo().refId());
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 9;
    }

    @Override
    public byte getCommand() {
        return 1;
    }

    public String toString() {
        return "ObjectReference(9).ReferenceType(1)";
    }
}

