/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.method;

import org.robovm.debugger.debuginfo.DebuggerDebugMethodInfo;
import org.robovm.debugger.debuginfo.DebuggerDebugVariableInfo;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.classdata.MethodInfo;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpMethodVariableTableHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpMethodVariableTableHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        long refTypeId = payload.readLong();
        long methodId = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            MethodInfo methodInfo = this.state.methodsRefIdHolder().objectById(methodId);
            if (methodInfo == null) {
                return 23;
            }
            DebuggerDebugMethodInfo debugInfo = methodInfo.debugInfo();
            if (debugInfo == null) {
                return 101;
            }
            int argCount = 0;
            output.writeInt32(argCount);
            output.writeInt32(debugInfo.localvariables().length);
            DebuggerDebugVariableInfo[] variables = debugInfo.localvariables();
            for (int idx = 0; idx < variables.length; ++idx) {
                DebuggerDebugVariableInfo variable = variables[idx];
                if (variable.isArgument()) {
                    ++argCount;
                }
                output.writeLong(variable.startLine());
                output.writeStringWithLen(variable.name());
                output.writeStringWithLen(variable.typeSignature());
                if (this.shallWriteEmptyGeneric()) {
                    output.writeStringWithLen("");
                }
                output.writeInt32(variable.finalLine() - variable.startLine() + 1);
                output.writeInt32(idx);
            }
            output.setPosition(0L);
            output.writeInt32(argCount);
            return 0;
        }
    }

    protected boolean shallWriteEmptyGeneric() {
        return false;
    }

    @Override
    public byte getCommandSet() {
        return 6;
    }

    @Override
    public byte getCommand() {
        return 2;
    }

    public String toString() {
        return "Method(6).VariableTable(2)";
    }
}

