/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates;

import org.robovm.debugger.jdwp.handlers.eventrequest.events.EventData;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventPredicate;
import org.robovm.debugger.state.instances.VmStackTrace;

public class EventLocationPredicate
extends EventPredicate {
    private final byte tag;
    private final long classId;
    private final long methodId;
    private final long index;

    public EventLocationPredicate(int modifier, byte tag, long classId, long methodId, long index) {
        super(modifier);
        this.tag = tag;
        this.classId = classId;
        this.methodId = methodId;
        this.index = index;
    }

    public long classId() {
        return this.classId;
    }

    public long methodId() {
        return this.methodId;
    }

    public long index() {
        return this.index;
    }

    @Override
    public boolean test(EventData eventData) {
        VmStackTrace location = eventData.getStoppeedLocation();
        if (location == null) {
            return false;
        }
        return this.classId == location.classInfo().refId() && this.methodId == location.methodInfo().refId() && this.index == (long)location.lineNumber();
    }

    public String toString() {
        return "Location{classId=" + this.classId + ", methodId=" + this.methodId + ", index=" + this.index + "} ";
    }
}

