/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.hooks.HooksChannel;
import org.robovm.debugger.hooks.IHooksConnection;

public class DebuggerConfig {
    public static final int TARGET_WAIT_TIMEOUT = 60000;
    public static final int TARGET_DEPLOY_TIMEOUT = 120000;
    private List<File> sourcePath;
    private Arch arch;
    private File logDir;
    private File appfile;
    private boolean logToConsole;
    private boolean jdwpClienMode;
    private int jdwpPort = -1;
    private boolean standalone;
    private IHooksConnection hooksConnection;

    private DebuggerConfig() {
    }

    public List<File> sourcePath() {
        return this.sourcePath;
    }

    public Arch arch() {
        return this.arch;
    }

    public File logDir() {
        return this.logDir;
    }

    public File appfile() {
        return this.appfile;
    }

    public boolean logToConsole() {
        return this.logToConsole;
    }

    public boolean jdwpClienMode() {
        return this.jdwpClienMode;
    }

    public int jdwpPort() {
        return this.jdwpPort;
    }

    public IHooksConnection hooksConnection() {
        return this.hooksConnection;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public static DebuggerConfig fromCommandLine(String[] args) {
        ArrayList<File> sourcePath = new ArrayList<File>();
        Arch arch = null;
        File logDir = null;
        File appfile = null;
        boolean logToConsole = false;
        boolean jdwpClienMode = false;
        int jdwpPort = -1;
        File hooksPortFile = null;
        int hooksPort = -1;
        try {
            for (int i = 0; i < args.length; ++i) {
                if ("-sourcepath".equals(args[i])) {
                    for (String p : args[++i].split(File.pathSeparator)) {
                        sourcePath.add(new File(p));
                    }
                    continue;
                }
                if ("-arch".equals(args[i])) {
                    String s = args[++i];
                    arch = Arch.valueOf(s);
                    continue;
                }
                if ("-logdir".equals(args[i])) {
                    logDir = new File(args[++i]);
                    continue;
                }
                if ("-appfile".equals(args[i])) {
                    appfile = new File(args[++i]);
                    continue;
                }
                if ("-logToConsole".equals(args[i])) {
                    logToConsole = true;
                    continue;
                }
                if ("-jdwpClientMode".equals(args[i])) {
                    jdwpClienMode = true;
                    continue;
                }
                if ("-jdwpPort".equals(args[i])) {
                    jdwpPort = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-hooksPortFile".equals(args[i])) {
                    hooksPortFile = new File(args[++i]);
                    continue;
                }
                if ("-hooksPort".equals(args[i])) {
                    hooksPort = Integer.parseInt(args[++i]);
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized option: " + args[i]);
            }
            if (jdwpPort == -1) {
                throw new IllegalArgumentException("Missing jdwpPort argument");
            }
        }
        catch (Throwable t) {
            String message = t.getMessage();
            if (t instanceof ArrayIndexOutOfBoundsException) {
                message = "Missing argument";
            }
            if (t instanceof IndexOutOfBoundsException) {
                message = "Missing argument";
            }
            throw new DebuggerException(DebuggerConfig.getCommandLineUsageText(message));
        }
        Builder builder = new Builder();
        builder.setSourcePath(sourcePath);
        builder.setAppfile(appfile);
        builder.setArch(arch);
        builder.setLogDir(logDir);
        builder.setLogToConsole(logToConsole);
        builder.setJdwpClienMode(jdwpClienMode);
        builder.setJdwpPort(jdwpPort);
        if (hooksPortFile != null) {
            builder.setHooksPortFile(hooksPortFile);
        } else if (hooksPort != -1) {
            builder.setHooksPort(hooksPort);
        }
        builder.setStandalone(true);
        return builder.build();
    }

    private static String getCommandLineUsageText(String errorMessage) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        if (errorMessage != null) {
            ps.println("Debugger: " + errorMessage);
        }
        ps.println("Usage: Debugger [-options]");
        ps.println("Options:");
        ps.println("  -sourcepath <list> :   separated list of directories, JAR archives, and ZIP \n                          archives to search for source files.");
        ps.println("  -arch <name>           The name of the LLVM arch to compile for. Allowed values\n                          are 'auto', 'x86', 'x86_64', 'thumbv7', 'arm64'. Default is\n                         'auto' which means use the LLVM default.");
        ps.println("  -appfile <file>        The path to compiled application file");
        ps.println("  -logdir <dir>          The directory to put log file to. Default is temp dir");
        ps.println("  -verbose               Output log messages to console");
        ps.println("  -jdwpClientMode        Specifies that JDWP server shall connect instead of listening");
        ps.println("  -jdwpPort <value>      TCP port JDWP server should listen or connects to");
        ps.println("  -hooksPortFile <value> File where target have written TCT port simulator is listened on for debugger");
        ps.println("  -hooksPort <value>     TCT port simulator is listened on for debugger");
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    public static enum Arch {
        x86(7, true),
        x86_64(0x1000007),
        thumbv7(12, true),
        arm64(0x100000C);

        private final boolean is32bit;
        private int machoValue;

        private Arch(int machoValue, boolean is32bit) {
            this.machoValue = machoValue;
            this.is32bit = is32bit;
        }

        private Arch(int machoValue) {
            this(machoValue, false);
        }

        public boolean is32Bit() {
            return this.is32bit;
        }

        public int getMachoValue() {
            return this.machoValue;
        }
    }

    public static class Builder {
        private final DebuggerConfig config = new DebuggerConfig();

        public DebuggerConfig build() {
            if (this.config.arch == null || this.config.appfile == null || this.config.jdwpPort < 0 || this.config.hooksConnection == null) {
                throw new DebuggerException("Missing required parameters in config");
            }
            return this.config;
        }

        public void setSourcePath(List<File> sourcePath) {
            this.config.sourcePath = sourcePath;
        }

        public void setArch(Arch arch) {
            this.config.arch = arch;
        }

        public void setLogDir(File logDir) {
            this.config.logDir = logDir;
        }

        public void setAppfile(File appfile) {
            this.config.appfile = appfile;
        }

        public void setLogToConsole(boolean logToConsole) {
            this.config.logToConsole = logToConsole;
        }

        public void setJdwpClienMode(boolean jdwpClienMode) {
            this.config.jdwpClienMode = jdwpClienMode;
        }

        public void setJdwpPort(int jdwpPort) {
            this.config.jdwpPort = jdwpPort;
        }

        public void setHooksPortFile(File portFile) {
            IntSupplier portSupplier = () -> {
                try {
                    long ts = System.currentTimeMillis();
                    while (!portFile.exists() || portFile.length() == 0L) {
                        if (System.currentTimeMillis() - ts > 60000L) {
                            throw new DebuggerException("Timeout while waiting simulator port file");
                        }
                        Thread.sleep(200L);
                    }
                    return Integer.parseInt(new String(Files.readAllBytes(portFile.toPath())));
                }
                catch (IOException | InterruptedException e) {
                    throw new DebuggerException(e);
                }
            };
            this.config.hooksConnection = new HooksChannel.SocketHooksConnection(portSupplier);
        }

        public void setHooksPort(int hooksPort) {
            this.config.hooksConnection = new HooksChannel.SocketHooksConnection(() -> hooksPort);
        }

        public void setHooksConnection(IHooksConnection conn) {
            this.config.hooksConnection = conn;
        }

        private void setStandalone(boolean b) {
            this.config.standalone = b;
        }
    }
}

