/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.registry.service.impl;

import com.meidusa.toolkit.common.runtime.GlobalScheduler;
import com.meidusa.venus.registry.LogUtils;
import com.meidusa.venus.registry.dao.VenusApplicationDAO;
import com.meidusa.venus.registry.dao.VenusServiceDAO;
import com.meidusa.venus.registry.domain.VenusApplicationDO;
import com.meidusa.venus.registry.domain.VenusServiceDO;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;

public class SyncApplicationisNewService {
    private VenusServiceDAO venusServiceDAO;
    private VenusApplicationDAO venusApplicationDAO;
    private static final int PAGE_SIZE_200 = 200;
    private volatile boolean loacCacheRunning = false;

    public VenusApplicationDAO getVenusApplicationDAO() {
        return this.venusApplicationDAO;
    }

    public void setVenusApplicationDAO(VenusApplicationDAO venusApplicationDAO) {
        this.venusApplicationDAO = venusApplicationDAO;
    }

    public VenusServiceDAO getVenusServiceDAO() {
        return this.venusServiceDAO;
    }

    public void setVenusServiceDAO(VenusServiceDAO venusServiceDAO) {
        this.venusServiceDAO = venusServiceDAO;
    }

    public void init() {
        GlobalScheduler.getInstance().scheduleAtFixedRate((Runnable)new SyncApplicationisNewRunnable(), 1L, 10L, TimeUnit.HOURS);
    }

    public void load() {
        Integer totalCount;
        this.loacCacheRunning = true;
        if (this.loacCacheRunning) {
            // empty if block
        }
        if (null != (totalCount = this.venusServiceDAO.getServiceCount()) && totalCount > 0) {
            int mod = totalCount % 200;
            int count = totalCount / 200;
            if (mod > 0) {
                ++count;
            }
            int mapId = 0;
            for (int i = 0; i < count; ++i) {
                List<VenusServiceDO> services = this.venusServiceDAO.queryServices(200, mapId);
                if (!CollectionUtils.isNotEmpty(services)) continue;
                mapId = services.get(services.size() - 1).getId();
                for (VenusServiceDO vs : services) {
                    String serviceName = vs.getName();
                    String oldAppCode = serviceName + "_app";
                    VenusApplicationDO application = this.venusApplicationDAO.getApplication(oldAppCode);
                    if (null == application || application.getNewApp() == null || !application.getNewApp().booleanValue()) continue;
                    this.venusApplicationDAO.updateApplication(false, application.getId());
                    LogUtils.DEFAULT_LOG.error("application.getId()" + application.getId() + "is update");
                }
            }
        }
        this.loacCacheRunning = false;
    }

    private class SyncApplicationisNewRunnable
    implements Runnable {
        private SyncApplicationisNewRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long start = System.currentTimeMillis();
                SyncApplicationisNewService.this.load();
                long end = System.currentTimeMillis();
                long l = end - start;
            }
            catch (Exception e) {
                LogUtils.ERROR_LOG.error("SyncApplicationisNew service cache data error", (Throwable)e);
            }
            finally {
                SyncApplicationisNewService.this.loacCacheRunning = false;
            }
        }
    }
}

