/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.registry.service.impl;

import com.meidusa.toolkit.common.runtime.GlobalScheduler;
import com.meidusa.venus.registry.LogUtils;
import com.meidusa.venus.registry.dao.OldServiceMappingDAO;
import com.meidusa.venus.registry.dao.VenusServiceMappingDAO;
import com.meidusa.venus.registry.data.move.OldServerDO;
import com.meidusa.venus.registry.data.move.OldServiceDO;
import com.meidusa.venus.registry.data.move.OldServiceMappingDO;
import com.meidusa.venus.registry.data.move.ServiceMappingDTO;
import com.meidusa.venus.registry.service.RegisterService;
import com.meidusa.venus.registry.util.RegistryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class OLdServiceMappingService {
    private static final int PAGE_SIZE_200 = 200;
    private static final int PAGE_SIZE_30 = 30;
    private static final int PAGE_SIZE_50 = 50;
    private OldServiceMappingDAO oldServiceMappingDAO;
    private VenusServiceMappingDAO venusServiceMappingDAO;
    private RegisterService registerService;
    private boolean needDataSync = false;

    public void init() {
        if (this.isNeedDataSync()) {
            LogUtils.MOVE_DATA_LOG.info("Sync Data Thread initialize is need");
            GlobalScheduler.getInstance().scheduleAtFixedRate((Runnable)new MoveDataRunnable(), 1L, 5L, TimeUnit.MINUTES);
        } else {
            LogUtils.MOVE_DATA_LOG.info("Sync Data Thread initialize is not need");
        }
    }

    public void moveServiceMappings() {
        Integer totalCount = this.oldServiceMappingDAO.getOldServiceMappingCount();
        if (null != totalCount && totalCount > 0) {
            int mod = totalCount % 200;
            int count = totalCount / 200;
            if (mod > 0) {
                ++count;
            }
            Integer mapId = null;
            for (int i = 0; i < count; ++i) {
                List<OldServiceMappingDO> oldServiceMappings = this.oldServiceMappingDAO.queryOldServiceMappings(200, mapId);
                if (!CollectionUtils.isNotEmpty(oldServiceMappings)) continue;
                mapId = oldServiceMappings.get(oldServiceMappings.size() - 1).getMapId();
                for (OldServiceMappingDO oldServiceMappingDO : oldServiceMappings) {
                    if (!RegistryUtil.isNotBlank((String)oldServiceMappingDO.getHostName())) continue;
                    this.registerService.addNewServiceMapping(oldServiceMappingDO.getHostName(), oldServiceMappingDO.getPort(), oldServiceMappingDO.getServiceName(), oldServiceMappingDO.getVersion(), oldServiceMappingDO.getDescription());
                }
            }
        }
    }

    public void moveServices() {
        Integer totalCount = this.oldServiceMappingDAO.getOldServiceCount();
        if (null != totalCount && totalCount > 0) {
            int mod = totalCount % 30;
            int count = totalCount / 30;
            if (mod > 0) {
                ++count;
            }
            Integer mapId = null;
            for (int i = 0; i < count; ++i) {
                List<OldServiceDO> services = this.oldServiceMappingDAO.queryOldServices(30, mapId);
                if (!CollectionUtils.isNotEmpty(services)) continue;
                mapId = services.get(services.size() - 1).getId();
                this.delOldMappingIds(services);
            }
        }
    }

    private void delOldMappingIds(List<OldServiceDO> services) {
        List<ServiceMappingDTO> oldServiceMappings = this.oldServiceMappingDAO.queryOldServiceMappings(this.getServiceNames(services));
        List<ServiceMappingDTO> serviceMappings = this.venusServiceMappingDAO.queryServiceMappings(this.getServiceNames(services));
        Map<String, List<ServiceMappingDTO>> maps = this.getServiceMappingDTOs(serviceMappings);
        Map<String, List<ServiceMappingDTO>> oldMaps = this.getServiceMappingDTOs(oldServiceMappings);
        ArrayList<Integer> allDelMapIds = new ArrayList<Integer>();
        for (Map.Entry<String, List<ServiceMappingDTO>> ent : maps.entrySet()) {
            String key = ent.getKey();
            List<Integer> deleteMapIds = this.getDeleteIds(oldMaps.get(key), ent.getValue());
            allDelMapIds.addAll(deleteMapIds);
        }
        this.segmentDelete(allDelMapIds);
    }

    private void segmentDelete(List<Integer> allDelMapIds) {
        if (allDelMapIds.size() <= 0) {
            return;
        }
        int totalCount = allDelMapIds.size();
        int mod = totalCount % 50;
        int count = totalCount / 50;
        if (mod > 0) {
            ++count;
        }
        for (int i = 0; i < count; ++i) {
            int end = (i + 1) * 50;
            if ((i + 1) * 50 >= totalCount) {
                end = totalCount;
            }
            int start = i * 50;
            List<Integer> subList = allDelMapIds.subList(start, end);
            this.venusServiceMappingDAO.deleteServiceMappings(subList);
        }
    }

    private void get_del_ids(List<OldServiceDO> services) {
        ArrayList<Integer> deleteMapIds = new ArrayList<Integer>();
        for (OldServiceDO oldServiceDO : services) {
            String serviceName = oldServiceDO.getServiceName();
            List<ServiceMappingDTO> oldServiceMappings = this.oldServiceMappingDAO.queryOldServiceMappings(serviceName);
            List<ServiceMappingDTO> serviceMappings = this.venusServiceMappingDAO.queryServiceMappings(serviceName);
            for (ServiceMappingDTO map : serviceMappings) {
                boolean needDel = true;
                for (ServiceMappingDTO old : oldServiceMappings) {
                    if (!OLdServiceMappingService.isNotBlank(map.getHostName()) || !OLdServiceMappingService.isNotBlank(old.getHostName()) || !map.getHostName().equals(old.getHostName()) || map.getPort() != old.getPort()) continue;
                    needDel = false;
                    break;
                }
                if (!needDel) continue;
                LogUtils.MOVE_DATA_LOG.info("mapId=>{},hostName=>{},serviceId=>{},serverId=>{},serverName=>{}", new Object[]{map.getMapId(), map.getHostName(), map.getServiceId(), map.getServerId(), map.getServiceName()});
                deleteMapIds.add(map.getMapId());
            }
        }
    }

    private List<Integer> getDeleteIds(List<ServiceMappingDTO> oldServiceMappings, List<ServiceMappingDTO> serviceMappings) {
        ArrayList<Integer> deleteMapIds = new ArrayList<Integer>();
        if (CollectionUtils.isNotEmpty(serviceMappings)) {
            for (ServiceMappingDTO map : serviceMappings) {
                boolean needDel = true;
                if (CollectionUtils.isNotEmpty(oldServiceMappings)) {
                    for (ServiceMappingDTO old : oldServiceMappings) {
                        if (!OLdServiceMappingService.isNotBlank(map.getHostName()) || !OLdServiceMappingService.isNotBlank(old.getHostName()) || !map.getHostName().equals(old.getHostName()) || map.getPort() != old.getPort()) continue;
                        needDel = false;
                        break;
                    }
                }
                if (!needDel) continue;
                LogUtils.MOVE_DATA_LOG.info("@@@@mapId=>{},hostName=>{},port={},serviceId=>{},serverId=>{},serverName=>{}", new Object[]{map.getMapId(), map.getHostName(), map.getPort(), map.getServiceId(), map.getServerId(), map.getServiceName()});
                deleteMapIds.add(map.getMapId());
            }
        }
        return deleteMapIds;
    }

    private List<String> getServiceNames(List<OldServiceDO> services) {
        ArrayList<String> serviceNames = new ArrayList<String>();
        for (OldServiceDO oldServiceDO : services) {
            serviceNames.add(oldServiceDO.getServiceName());
        }
        return serviceNames;
    }

    private Map<String, List<ServiceMappingDTO>> getServiceMappingDTOs(List<ServiceMappingDTO> services) {
        HashMap<String, List<ServiceMappingDTO>> maps = new HashMap<String, List<ServiceMappingDTO>>();
        for (ServiceMappingDTO s : services) {
            ArrayList<ServiceMappingDTO> list;
            String serviceName = s.getServiceName();
            String versionRange = s.getVersionRange();
            String key = serviceName;
            if (StringUtils.isNotBlank((String)versionRange) && !"null".equalsIgnoreCase(versionRange)) {
                key = serviceName + ":" + versionRange;
            }
            if ((list = (ArrayList<ServiceMappingDTO>)maps.get(key)) == null) {
                list = new ArrayList<ServiceMappingDTO>();
                list.add(s);
                maps.put(key, list);
                continue;
            }
            list.add(s);
        }
        return maps;
    }

    public void moveServers() {
        Integer totalCount = this.oldServiceMappingDAO.getOldServerCount();
        if (null != totalCount && totalCount > 0) {
            int mod = totalCount % 200;
            int count = totalCount / 200;
            if (mod > 0) {
                ++count;
            }
            Integer id = null;
            for (int i = 0; i < count; ++i) {
                List<OldServerDO> servers = this.oldServiceMappingDAO.queryOldServers(200, id);
                if (!CollectionUtils.isNotEmpty(servers)) continue;
                id = servers.get(servers.size() - 1).getId();
                for (OldServerDO oldServerDO : servers) {
                    this.registerService.addServer(oldServerDO.getHostName(), oldServerDO.getPort().intValue());
                }
            }
        }
    }

    public OldServiceMappingDAO getOldServiceMappingDAO() {
        return this.oldServiceMappingDAO;
    }

    public void setOldServiceMappingDAO(OldServiceMappingDAO oldServiceMappingDAO) {
        this.oldServiceMappingDAO = oldServiceMappingDAO;
    }

    public RegisterService getRegisterService() {
        return this.registerService;
    }

    public void setRegisterService(RegisterService registerService) {
        this.registerService = registerService;
    }

    public boolean isNeedDataSync() {
        return this.needDataSync;
    }

    public void setNeedDataSync(boolean needDataSync) {
        this.needDataSync = needDataSync;
    }

    public VenusServiceMappingDAO getVenusServiceMappingDAO() {
        return this.venusServiceMappingDAO;
    }

    public void setVenusServiceMappingDAO(VenusServiceMappingDAO venusServiceMappingDAO) {
        this.venusServiceMappingDAO = venusServiceMappingDAO;
    }

    public static boolean isNotBlank(String param) {
        return StringUtils.isNotBlank((String)param) && !"null".equals(param);
    }

    private class MoveDataRunnable
    implements Runnable {
        private MoveDataRunnable() {
        }

        @Override
        public void run() {
            try {
                long start;
                long firstStart = start = System.currentTimeMillis();
                LogUtils.MOVE_DATA_LOG.info("*********MoveDataRunnable start at=>{}*********", (Object)start);
                OLdServiceMappingService.this.moveServers();
                long end = System.currentTimeMillis();
                long consumerTime = end - start;
                LogUtils.logSlow5000(consumerTime, "MoveDataRunnable  moveServers() ");
                LogUtils.MOVE_DATA_LOG.info("moveServers end at=>{},consumerTime=>{}", (Object)end, (Object)consumerTime);
                start = System.currentTimeMillis();
                OLdServiceMappingService.this.moveServiceMappings();
                end = System.currentTimeMillis();
                consumerTime = end - start;
                LogUtils.logSlow5000(consumerTime, "MoveDataRunnable  moveServiceMappings() ");
                LogUtils.MOVE_DATA_LOG.info("moveServiceMappings end at=>{},consumerTime=>{}", (Object)end, (Object)consumerTime);
                start = System.currentTimeMillis();
                OLdServiceMappingService.this.moveServices();
                end = System.currentTimeMillis();
                consumerTime = end - start;
                LogUtils.MOVE_DATA_LOG.info("moveServices end at=>{},consumerTime=>{}", (Object)end, (Object)consumerTime);
                LogUtils.logSlow5000(consumerTime, "MoveDataRunnable  moveServices() ");
                LogUtils.MOVE_DATA_LOG.info("*********MoveDataRunnable end at=>{},consumerTime=>{}*************", (Object)end, (Object)(end - firstStart));
            }
            catch (Exception e) {
                LogUtils.ERROR_LOG.error("moveServers method is error", (Throwable)e);
            }
        }
    }
}

