/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.registry.service.impl;

import com.meidusa.fastjson.JSON;
import com.meidusa.venus.URL;
import com.meidusa.venus.annotations.Param;
import com.meidusa.venus.registry.LogUtils;
import com.meidusa.venus.registry.VenusRegisteException;
import com.meidusa.venus.registry.dao.CacheApplicationDAO;
import com.meidusa.venus.registry.dao.CacheServiceConfigDAO;
import com.meidusa.venus.registry.dao.CacheVenusServerDAO;
import com.meidusa.venus.registry.dao.CacheVenusServiceDAO;
import com.meidusa.venus.registry.dao.CacheVenusServiceMappingDAO;
import com.meidusa.venus.registry.dao.VenusApplicationDAO;
import com.meidusa.venus.registry.dao.VenusServerDAO;
import com.meidusa.venus.registry.dao.VenusServiceConfigDAO;
import com.meidusa.venus.registry.dao.VenusServiceDAO;
import com.meidusa.venus.registry.dao.VenusServiceMappingDAO;
import com.meidusa.venus.registry.dao.impl.ResultUtils;
import com.meidusa.venus.registry.data.move.UpdateHeartBeatTimeDTO;
import com.meidusa.venus.registry.domain.VenusApplicationDO;
import com.meidusa.venus.registry.domain.VenusServerDO;
import com.meidusa.venus.registry.domain.VenusServiceConfigDO;
import com.meidusa.venus.registry.domain.VenusServiceDO;
import com.meidusa.venus.registry.domain.VenusServiceDefinitionDO;
import com.meidusa.venus.registry.domain.VenusServiceMappingDO;
import com.meidusa.venus.registry.service.RegisterService;
import com.meidusa.venus.registry.util.RegistryUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class MysqlRegisterService
implements RegisterService,
DisposableBean {
    private VenusServiceDAO venusServiceDAO;
    private VenusServiceConfigDAO venusServiceConfigDAO;
    private VenusApplicationDAO venusApplicationDAO;
    private CacheApplicationDAO cacheApplicationDAO;
    private VenusServerDAO venusServerDAO;
    private CacheVenusServerDAO cacheVenusServerDAO;
    private CacheVenusServiceDAO cacheVenusServiceDAO;
    private CacheServiceConfigDAO cacheServiceConfigDAO;
    private CacheVenusServiceMappingDAO cacheVenusServiceMappingDAO;
    private VenusServiceMappingDAO venusServiceMappingDAO;
    private TransactionTemplate transactionTemplate;
    private volatile boolean needRun = true;
    private ExecutorService es = Executors.newSingleThreadExecutor();
    private static final int QUEUE_SIZE_10000 = 10000;
    private static final int PAGE_SIZE_200 = 200;
    private int sampleMod = 10;
    private String enableLocalIp = "on";
    private String enableFilterIp = "off";
    private String envIpRange;
    public static final LinkedBlockingQueue<UpdateHeartBeatTimeDTO> HEARTBEAT_QUEUE = new LinkedBlockingQueue(10000);
    private String connectUrl;

    public MysqlRegisterService() {
    }

    public MysqlRegisterService(String connectUrl) {
        this.setConnectUrl(connectUrl);
        this.init();
    }

    public void init() {
        UpdateHeartbeatTimeRunnable heartbeatThread = new UpdateHeartbeatTimeRunnable("update-heartbeat-time-thread");
        this.es.submit(heartbeatThread);
    }

    public void registe(URL url) throws VenusRegisteException {
        String appCode = url.getApplication();
        int appId = 0;
        if (StringUtils.isNotBlank((String)appCode)) {
            VenusApplicationDO application = this.venusApplicationDAO.getApplication(appCode);
            if (null == application) {
                VenusApplicationDO venusApplicationDO = new VenusApplicationDO();
                venusApplicationDO.setAppCode(appCode);
                venusApplicationDO.setCreateName("provider");
                venusApplicationDO.setUpdateName("provider");
                venusApplicationDO.setProvider(Boolean.valueOf(true));
                venusApplicationDO.setConsumer(Boolean.valueOf(false));
                venusApplicationDO.setNewApp(Boolean.valueOf(true));
                appId = this.venusApplicationDAO.addApplication(venusApplicationDO);
            } else {
                appId = application.getId();
                if (null == application.isProvider() || null != application.isProvider() && !application.isProvider().booleanValue()) {
                    application.setProvider(Boolean.valueOf(true));
                    this.venusApplicationDAO.updateApplication(application);
                }
            }
        }
        int serverId = this.addServer(url.getHost(), url.getPort());
        int countByServiceNameAndAppId = this.venusServiceDAO.getCountByServiceNameAndAppId(url.getServiceName(), appId);
        if (countByServiceNameAndAppId > 0) {
            LogUtils.ERROR_LOG.info("serviceName=>" + url.getServiceName() + ",appName=>" + appCode + ",appId=>" + appId + " registe error,because other application has registed service name:" + url.getServiceName());
            throw new VenusRegisteException("ServiceName=>" + url.getServiceName() + ",appName=>" + appCode + ",appId=>" + appId + " registe error ,other application has registe service,this registe fail.");
        }
        VenusServiceDO service = this.venusServiceDAO.getService(url.getInterfaceName(), url.getServiceName(), url.getVersion());
        int serviceId = 0;
        if (null == service) {
            VenusServiceDO venusServiceDO = new VenusServiceDO();
            venusServiceDO.setInterfaceName(url.getInterfaceName());
            venusServiceDO.setName(url.getServiceName());
            venusServiceDO.setAppId(Integer.valueOf(appId));
            venusServiceDO.setVersion(url.getVersion());
            venusServiceDO.setRegisteType(Integer.valueOf(1));
            venusServiceDO.setMethods(url.getMethods());
            venusServiceDO.setEndpoints(url.getEndpoints());
            venusServiceDO.setVersionRange(url.getVersionRange());
            venusServiceDO.setDelete(false);
            serviceId = this.venusServiceDAO.addService(venusServiceDO);
        } else {
            serviceId = service.getId();
            if (StringUtils.isBlank((String)url.getMethods())) {
                url.setMethods("");
            }
            this.venusServiceDAO.updateService(url.getMethods(), false, serviceId, appId, url.getVersionRange(), url.getEndpoints());
        }
        VenusServiceMappingDO serviceMapping = this.venusServiceMappingDAO.getServiceMapping((Integer)serverId, serviceId, "provider");
        if (null == serviceMapping) {
            VenusServiceMappingDO venusServiceMappingDO = new VenusServiceMappingDO();
            venusServiceMappingDO.setServerId(Integer.valueOf(serverId));
            venusServiceMappingDO.setServiceId(Integer.valueOf(serviceId));
            venusServiceMappingDO.setProviderAppId(Integer.valueOf(appId));
            venusServiceMappingDO.setConsumerAppId(Integer.valueOf(0));
            venusServiceMappingDO.setSync(true);
            venusServiceMappingDO.setActive(true);
            venusServiceMappingDO.setRole("provider");
            venusServiceMappingDO.setVersion(url.getVersion());
            venusServiceMappingDO.setIsDelete(Boolean.valueOf(false));
            this.venusServiceMappingDAO.addServiceMapping(venusServiceMappingDO);
        } else {
            this.venusServiceMappingDAO.updateProviderServiceMapping(serviceMapping.getId(), true, false, appId);
        }
        if (StringUtils.isNotBlank((String)appCode)) {
            try {
                boolean deleteOldMappings = this.venusServiceMappingDAO.logicDeleteOldMappings(serverId, appId, "provider");
                LogUtils.DEFAULT_LOG.info("logicDeleteOldMappings \u670d\u52a1,appCode=>{},serverId=>{},appId=>{},result=>{}", new Object[]{appCode, serverId, appId, deleteOldMappings});
            }
            catch (Exception e) {
                LogUtils.ERROR_LOG.error("deleteOldMappings \u670d\u52a1\u5f02\u5e38,serviceId=>{},appId=>{}", (Object)serviceId, (Object)appId);
            }
        }
    }

    public int addServer(String host, int port) {
        VenusServerDO server = this.venusServerDAO.getServer(host, port);
        int serverId = 0;
        if (null == server) {
            VenusServerDO venusServerDO = new VenusServerDO();
            venusServerDO.setHostname(host);
            venusServerDO.setPort(Integer.valueOf(port));
            serverId = this.venusServerDAO.addServer(venusServerDO);
        } else {
            serverId = server.getId();
        }
        return serverId;
    }

    public int addService(String serviceName, String description, String versionRange) {
        return 0;
    }

    private int saveApplication(String serviceName) {
        String oldAppCode = serviceName + "_app";
        int appId = 0;
        if (StringUtils.isNotBlank((String)oldAppCode)) {
            VenusApplicationDO application = this.venusApplicationDAO.getApplication(oldAppCode);
            if (null == application) {
                VenusApplicationDO venusApplicationDO = new VenusApplicationDO();
                venusApplicationDO.setAppCode(oldAppCode);
                venusApplicationDO.setCreateName("provider");
                venusApplicationDO.setUpdateName("provider");
                venusApplicationDO.setProvider(Boolean.valueOf(true));
                venusApplicationDO.setConsumer(Boolean.valueOf(false));
                venusApplicationDO.setNewApp(Boolean.valueOf(false));
                appId = this.venusApplicationDAO.addApplication(venusApplicationDO);
            } else {
                appId = application.getId();
                if (null == application.isProvider() || null != application.isProvider() && !application.isProvider().booleanValue()) {
                    application.setProvider(Boolean.valueOf(true));
                    this.venusApplicationDAO.updateApplication(application);
                }
            }
        }
        return appId;
    }

    public boolean unregiste(URL url) throws VenusRegisteException {
        VenusServerDO server;
        VenusServiceDO service = this.venusServiceDAO.getService(url.getInterfaceName(), url.getServiceName(), url.getVersion());
        if (null != service && null != service.getRegisteType() && service.getRegisteType() == 1 && null != (server = this.venusServerDAO.getServer(url.getHost(), url.getPort()))) {
            int serverId = server.getId();
            int serviceId = service.getId();
            VenusServiceMappingDO serviceMapping = this.venusServiceMappingDAO.getServiceMapping((Integer)serverId, serviceId, "provider");
            if (null != serviceMapping) {
                boolean deleteServiceMapping = this.venusServiceMappingDAO.deleteServiceMapping(serviceMapping.getId());
                LogUtils.DEFAULT_LOG.info(JSON.toJSONString((Object)url) + ",result=>{}", (Object)deleteServiceMapping);
                this.deleteServer(serverId);
                return deleteServiceMapping;
            }
        }
        return false;
    }

    public void subscrible(URL url) throws VenusRegisteException {
        List<VenusServiceDO> services = this.venusServiceDAO.queryServices(url.getInterfaceName(), url.getServiceName(), url.getVersion());
        if (CollectionUtils.isEmpty(services)) {
            return;
        }
        for (VenusServiceDO service : services) {
            VenusServerDO server;
            String name;
            if (null == service && url.isConsumerCheck()) {
                name = MysqlRegisterService.log_service_name(url);
                LogUtils.ERROR_LOG.error("\u670d\u52a1\u8ba2\u9605\u5f02\u5e38,\u539f\u56e0:\u670d\u52a1{}\u4e0d\u5b58\u5728 ", (Object)name);
                throw new VenusRegisteException("\u670d\u52a1\u8ba2\u9605\u5f02\u5e38,\u539f\u56e0:\u670d\u52a1" + name + "\u4e0d\u5b58\u5728");
            }
            if (service.getIsDelete() && url.isConsumerCheck()) {
                name = MysqlRegisterService.log_service_name(url);
                LogUtils.ERROR_LOG.error("\u670d\u52a1\u8ba2\u9605\u5f02\u5e38,\u539f\u56e0:\u670d\u52a1{}\u5df2\u5220\u9664", (Object)name);
                throw new VenusRegisteException("\u670d\u52a1\u8ba2\u9605\u5f02\u5e38,\u539f\u56e0:\u670d\u52a1" + name + "\u4e0d\u5b58\u5728");
            }
            String appCode = url.getApplication();
            int appId = 0;
            if (StringUtils.isNotBlank((String)appCode)) {
                VenusApplicationDO application = this.cacheApplicationDAO.getApplication(appCode);
                if (null == application) {
                    application = this.venusApplicationDAO.getApplication(appCode);
                }
                if (null == application) {
                    VenusApplicationDO venusApplicationDO = new VenusApplicationDO();
                    venusApplicationDO.setAppCode(appCode);
                    venusApplicationDO.setProvider(Boolean.valueOf(false));
                    venusApplicationDO.setConsumer(Boolean.valueOf(true));
                    venusApplicationDO.setUpdateName("consumer");
                    venusApplicationDO.setCreateName("consumer");
                    venusApplicationDO.setNewApp(Boolean.valueOf(true));
                    appId = this.venusApplicationDAO.addApplication(venusApplicationDO);
                } else {
                    appId = application.getId();
                    if (null == application.isConsumer() || null != application.isConsumer() && !application.isConsumer().booleanValue()) {
                        application.setConsumer(Boolean.valueOf(true));
                        this.venusApplicationDAO.updateApplication(application);
                    }
                }
            }
            if (null == (server = null)) {
                server = this.venusServerDAO.getServer(url.getHost(), 0);
            }
            int serverId = 0;
            if (null == server) {
                VenusServerDO venusServerDO = new VenusServerDO();
                venusServerDO.setHostname(url.getHost());
                venusServerDO.setPort(Integer.valueOf(0));
                serverId = this.venusServerDAO.addServer(venusServerDO);
            } else {
                serverId = server.getId();
            }
            int serviceId = service.getId();
            VenusServiceMappingDO serviceMapping = this.venusServiceMappingDAO.getServiceMapping((Integer)serverId, serviceId, "consumer");
            if (null == serviceMapping) {
                VenusServiceMappingDO venusServiceMappingDO = new VenusServiceMappingDO();
                venusServiceMappingDO.setServerId(Integer.valueOf(serverId));
                venusServiceMappingDO.setServiceId(Integer.valueOf(serviceId));
                venusServiceMappingDO.setSync(true);
                venusServiceMappingDO.setActive(true);
                venusServiceMappingDO.setRole("consumer");
                venusServiceMappingDO.setVersion(url.getVersion());
                venusServiceMappingDO.setIsDelete(Boolean.valueOf(false));
                venusServiceMappingDO.setProviderAppId(Integer.valueOf(0));
                venusServiceMappingDO.setConsumerAppId(Integer.valueOf(appId));
                this.venusServiceMappingDAO.addServiceMapping(venusServiceMappingDO);
                continue;
            }
            this.venusServiceMappingDAO.updateSubcribeServiceMapping(serviceMapping.getId(), appId, true, false);
        }
    }

    public boolean unsubscrible(URL url) throws VenusRegisteException {
        List<VenusServiceDO> services = this.venusServiceDAO.queryServices(url.getInterfaceName(), url.getServiceName(), url.getVersion());
        if (CollectionUtils.isNotEmpty(services)) {
            for (VenusServiceDO service : services) {
                VenusServiceMappingDO serviceMapping;
                VenusServerDO server;
                if (null == service || null == (server = this.venusServerDAO.getServer(url.getHost(), 0)) || null == (serviceMapping = this.venusServiceMappingDAO.getServiceMapping(server.getId(), service.getId(), "consumer"))) continue;
                boolean deleteServiceMapping = this.venusServiceMappingDAO.deleteServiceMapping(serviceMapping.getId());
                this.deleteServer(server.getId());
                return deleteServiceMapping;
            }
        }
        return false;
    }

    public Map<String, List<VenusServiceDefinitionDO>> queryServiceDefinitions(@Param(name="urls") List<URL> urls) {
        HashMap<String, List<VenusServiceDefinitionDO>> returnMap = new HashMap<String, List<VenusServiceDefinitionDO>>();
        for (URL url : urls) {
            List<VenusServiceDefinitionDO> findServiceDefinitions = this.findServiceDefinitions(url);
            String key = RegistryUtil.getKeyFromUrl((URL)url);
            returnMap.put(key, findServiceDefinitions);
        }
        return returnMap;
    }

    public List<VenusServiceDefinitionDO> findServiceDefinitions(URL url) {
        long start = System.currentTimeMillis();
        ArrayList<VenusServiceDefinitionDO> returnList = new ArrayList<VenusServiceDefinitionDO>();
        String interfaceName = url.getInterfaceName();
        String serviceName = url.getServiceName();
        String version = url.getVersion();
        List<VenusServiceDO> services = null;
        try {
            services = this.cacheVenusServiceDAO.queryServices(url);
            if (CollectionUtils.isEmpty(services)) {
                services = this.venusServiceDAO.queryServicesByName(interfaceName, serviceName, version);
            }
        }
        catch (Exception e) {
            LogUtils.ERROR_LOG.error("findServiceDefinitions queryServices \u8c03\u7528\u5f02\u5e38,interfaceName=>" + interfaceName + ",serviceName=>" + serviceName + ",version=>" + version, (Throwable)e);
        }
        try {
            if (CollectionUtils.isNotEmpty(services)) {
                Iterator<VenusServiceDO> ite = services.iterator();
                while (ite.hasNext()) {
                    List<String> sitIpSegments;
                    Set<String> afterFilterIps;
                    boolean filterIP;
                    ArrayList<Integer> serverIds = new ArrayList<Integer>();
                    VenusServiceDO service = ite.next();
                    Integer serviceId = service.getId();
                    List<VenusServiceMappingDO> serviceMappings = this.cacheVenusServiceMappingDAO.queryServiceMappings(serviceId);
                    if (CollectionUtils.isEmpty(serviceMappings)) {
                        serviceMappings = this.venusServiceMappingDAO.getServiceMapping(serviceId, "provider", false);
                    }
                    if (CollectionUtils.isNotEmpty(serviceMappings)) {
                        for (VenusServiceMappingDO venusServiceMappingDO : serviceMappings) {
                            if (!venusServiceMappingDO.isActive()) continue;
                            Integer serverId = venusServiceMappingDO.getServerId();
                            serverIds.add(serverId);
                        }
                    }
                    HashSet<String> hostPortSet = new HashSet<String>();
                    if (CollectionUtils.isNotEmpty(serverIds)) {
                        List<VenusServerDO> servers = this.cacheVenusServerDAO.getServers(serverIds);
                        if (CollectionUtils.isEmpty(servers)) {
                            servers = this.venusServerDAO.getServers(serverIds);
                        }
                        if (CollectionUtils.isNotEmpty(servers)) {
                            for (VenusServerDO venusServerDO : servers) {
                                String hostPort = venusServerDO.getHostname() + ":" + venusServerDO.getPort();
                                hostPortSet.add(hostPort);
                            }
                        }
                    }
                    Set<Object> needHostPorts = new HashSet();
                    if (this.getEnableLocalIp().equals("on") && (filterIP = MysqlRegisterService.findLocalIP(hostPortSet, url.getHost()))) {
                        needHostPorts = hostPortSet;
                    }
                    if (this.getEnableFilterIp().equals("on") && CollectionUtils.isEmpty(needHostPorts) && CollectionUtils.isNotEmpty(afterFilterIps = this.filterSitIps(hostPortSet, sitIpSegments = this.getSitIpSegments()))) {
                        needHostPorts = afterFilterIps;
                    }
                    if (CollectionUtils.isEmpty(needHostPorts)) {
                        needHostPorts = hostPortSet;
                    }
                    if (!CollectionUtils.isNotEmpty(needHostPorts)) continue;
                    VenusApplicationDO application = this.cacheApplicationDAO.getApplication(service.getAppId());
                    if (null == application) {
                        application = this.venusApplicationDAO.getApplication(service.getAppId());
                    }
                    VenusServiceDefinitionDO def = new VenusServiceDefinitionDO();
                    def.setInterfaceName(interfaceName);
                    def.setName(serviceName);
                    def.setIpAddress(needHostPorts);
                    def.setActive(true);
                    def.setDescription(service.getDescription());
                    def.setVersion(service.getVersion());
                    def.setVersionRange(service.getVersionRange());
                    if (null != application) {
                        def.setProvider(application.getAppCode());
                    }
                    if (this.cacheServiceConfigDAO.getVenusServiceConfigCount() > 0) {
                        List<VenusServiceConfigDO> serviceConfigs = null;
                        serviceConfigs = this.cacheServiceConfigDAO.isLoacCacheRunning() ? this.venusServiceConfigDAO.getServiceConfigs(serviceId) : this.cacheServiceConfigDAO.getVenusServiceConfig(serviceId);
                        ResultUtils.setServiceConfigs(serviceConfigs);
                        def.setServiceConfigs(serviceConfigs);
                    }
                    returnList.add(def);
                }
            }
        }
        catch (Exception e) {
            LogUtils.ERROR_LOG.error("findServiceDefinitions\u8c03\u7528\u5f02\u5e38,url=>{},\u5f02\u5e38\u539f\u56e0\uff1a{}", (Object)url, (Object)e);
            throw new VenusRegisteException("findServiceDefinitions\u8c03\u7528\u5f02\u5e38,\u670d\u52a1\u540d\uff1a" + MysqlRegisterService.log_service_name(url), (Throwable)e);
        }
        long end = System.currentTimeMillis();
        long consumerTime = end - start;
        LogUtils.logSlow(consumerTime, "findServiceDefs is slow,url=>" + JSON.toJSONString((Object)url));
        if (end % (long)this.sampleMod == 1L) {
            LogUtils.LOAD_SERVICE_DEF_LOG.info("findServiceDefs sampling consumerTime=>{},url=>{}", (Object)consumerTime, (Object)JSON.toJSONString((Object)url));
        }
        return returnList;
    }

    private Set<String> filterSitIps(Set<String> hostPortSet, List<String> sitIpSegments) {
        if (CollectionUtils.isNotEmpty(sitIpSegments)) {
            HashSet<String> set = new HashSet<String>();
            if (CollectionUtils.isNotEmpty(hostPortSet)) {
                block0: for (String ip : hostPortSet) {
                    for (String sitSegment : sitIpSegments) {
                        if (!ip.startsWith(sitSegment)) continue;
                        set.add(ip);
                        continue block0;
                    }
                }
            }
            return set;
        }
        return hostPortSet;
    }

    private List<String> getSitIpSegments() {
        String[] split;
        int len;
        ArrayList<String> sitIpSegments = new ArrayList<String>();
        if (RegistryUtil.isNotBlank((String)this.getEnvIpRange()) && (len = (split = this.getEnvIpRange().split(",")).length) > 0) {
            for (int i = 0; i < len; ++i) {
                String ip = split[i];
                sitIpSegments.add(ip);
            }
        }
        return sitIpSegments;
    }

    public static boolean findLocalIP(Set<String> hostPortSet, String localIp) {
        boolean hasFindLocalIp = false;
        if (RegistryUtil.isNotBlank((String)localIp)) {
            for (String str : hostPortSet) {
                if (!str.startsWith(localIp)) continue;
                hasFindLocalIp = true;
                break;
            }
            if (hasFindLocalIp) {
                Iterator<String> iterator = hostPortSet.iterator();
                while (iterator.hasNext()) {
                    String str;
                    str = iterator.next();
                    if (str.startsWith(localIp)) continue;
                    iterator.remove();
                }
            }
        }
        return hasFindLocalIp;
    }

    public void addNewServiceMapping(String hostName, int port, String serviceName, String version, String description) {
        boolean exists = this.venusServiceMappingDAO.existServiceMapping(hostName, port, serviceName, version);
        String versionRange = version;
        if (!exists) {
            StringBuilder sb = new StringBuilder();
            sb.append("hostName=>");
            sb.append(hostName);
            sb.append(",port=>");
            sb.append(port);
            sb.append(",serviceName=>");
            sb.append(serviceName);
            sb.append(",version=>");
            sb.append(version);
            LogUtils.DEFAULT_LOG.info("not exits=>" + sb.toString());
            VenusServerDO server = this.venusServerDAO.getServer(hostName, port);
            if (null != server) {
                int serviceId = 0;
                VenusServiceDO service = this.venusServiceDAO.getService(serviceName, 0, versionRange);
                if (null == service) {
                    int appId = this.saveApplication(serviceName);
                    VenusServiceDO venusServiceDO = new VenusServiceDO();
                    venusServiceDO.setName(serviceName);
                    venusServiceDO.setAppId(Integer.valueOf(appId));
                    venusServiceDO.setVersion(String.valueOf(0));
                    venusServiceDO.setVersionRange(versionRange);
                    venusServiceDO.setRegisteType(Integer.valueOf(0));
                    venusServiceDO.setMethods(null);
                    venusServiceDO.setDescription(description);
                    venusServiceDO.setDelete(false);
                    serviceId = this.venusServiceDAO.addService(venusServiceDO);
                } else {
                    serviceId = service.getId();
                }
                VenusServiceMappingDO venusServiceMappingDO = new VenusServiceMappingDO();
                venusServiceMappingDO.setServerId(server.getId());
                venusServiceMappingDO.setServiceId(Integer.valueOf(serviceId));
                venusServiceMappingDO.setProviderAppId(Integer.valueOf(0));
                venusServiceMappingDO.setConsumerAppId(Integer.valueOf(0));
                venusServiceMappingDO.setSync(true);
                venusServiceMappingDO.setActive(true);
                venusServiceMappingDO.setRole("provider");
                venusServiceMappingDO.setVersion(version);
                venusServiceMappingDO.setIsDelete(Boolean.valueOf(false));
                this.venusServiceMappingDAO.addServiceMapping(venusServiceMappingDO);
            }
        }
    }

    @Deprecated
    public void heartbeatSubcribe(URL url) {
        try {
            String host = url.getHost();
            VenusServerDO server = this.venusServerDAO.getServer(host, 0);
            if (null != server) {
                int serverID = server.getId();
                boolean update = this.venusServiceMappingDAO.updateHeartBeatTime(serverID, "consumer");
                LogUtils.DEFAULT_LOG.info("heartbeatSubcribe updateServiceMappingHeartBeatTime serverID=>{},role=>{},isSuccess=>{},currentDate=>{},url=>{}", new Object[]{serverID, "consumer", update, new Date(), url});
            }
        }
        catch (Exception e) {
            String name = MysqlRegisterService.log_service_name(url);
            LogUtils.ERROR_LOG.error("\u670d\u52a1{}subscrible\u66f4\u65b0heartBeatTime\u5f02\u5e38 ,\u5f02\u5e38\u539f\u56e0\uff1a{}", (Object)name, (Object)e);
            throw new VenusRegisteException("subscrible\u66f4\u65b0heartBeatTime\u5f02\u5e38,\u670d\u52a1\u540d\uff1a" + name, (Throwable)e);
        }
    }

    @Deprecated
    public void heartbeatRegister(URL url) {
        try {
            String host = url.getHost();
            int port = url.getPort();
            VenusServerDO server = this.venusServerDAO.getServer(host, port);
            if (null != server) {
                int serverID = server.getId();
                boolean update = this.venusServiceMappingDAO.updateHeartBeatTime(serverID, "provider");
                LogUtils.DEFAULT_LOG.info("heartbeatRegister serverID=>{},role=>{},isSuccess=>{},currentDate=>{},url=>{}", new Object[]{serverID, "provider", update, new Date(), url});
            }
        }
        catch (Exception e) {
            String name = MysqlRegisterService.log_service_name(url);
            LogUtils.ERROR_LOG.error("\u670d\u52a1{}registe\u66f4\u65b0heartBeatTime\u5f02\u5e38 ,\u5f02\u5e38\u539f\u56e0\uff1a{}", (Object)name, (Object)e);
            throw new VenusRegisteException("registe\u66f4\u65b0heartBeatTime\u5f02\u5e38,\u670d\u52a1\u540d\uff1a" + name, (Throwable)e);
        }
    }

    private void heartbeatRegister(Set<URL> urls, String role) {
        if (CollectionUtils.isEmpty(urls)) {
            return;
        }
        HashMap maps = new HashMap();
        try {
            VenusServerDO server = this.getServer(urls);
            for (URL uRL : urls) {
                if (null == server) continue;
                List<VenusServiceDO> services = this.cacheVenusServiceDAO.queryServices(uRL.getInterfaceName(), uRL.getServiceName(), uRL.getVersion(), role);
                if (CollectionUtils.isEmpty(services)) {
                    services = this.venusServiceDAO.queryServices(uRL.getInterfaceName(), uRL.getServiceName(), uRL.getVersion());
                }
                if (!CollectionUtils.isNotEmpty(services)) continue;
                for (VenusServiceDO venusServiceDO : services) {
                    ArrayList<Integer> list = (ArrayList<Integer>)maps.get(server.getId());
                    Integer serviceId = venusServiceDO.getId();
                    if (list != null) {
                        if (list.contains(serviceId)) continue;
                        list.add(serviceId);
                        continue;
                    }
                    list = new ArrayList<Integer>();
                    if (!list.contains(serviceId)) {
                        list.add(serviceId);
                    }
                    maps.put(server.getId(), list);
                }
            }
            if (HEARTBEAT_QUEUE.size() >= 9999) {
                LogUtils.HEARTBEAT_LOG.info("venus heartbeat drop message=>" + JSON.toJSONString(maps));
            } else {
                for (Map.Entry entry : maps.entrySet()) {
                    UpdateHeartBeatTimeDTO heartBeatTimeDTO = new UpdateHeartBeatTimeDTO();
                    heartBeatTimeDTO.setRole(role);
                    heartBeatTimeDTO.setServerId((Integer)entry.getKey());
                    heartBeatTimeDTO.setServiceIds((List)entry.getValue());
                    heartBeatTimeDTO.setServerDO(server);
                    boolean offer = HEARTBEAT_QUEUE.offer(heartBeatTimeDTO);
                    if (offer) continue;
                    LogUtils.HEARTBEAT_LOG.info("heartbeat_queue size=>{},venus heartbeat message maps=>{},urls=>{}", new Object[]{HEARTBEAT_QUEUE.size(), JSON.toJSONString(maps), JSON.toJSONString(urls)});
                }
            }
        }
        catch (Exception e) {
            LogUtils.ERROR_LOG.error("\u670d\u52a1{}heartBeatTime\u5165\u961f\u5217\u5f02\u5e38 ,\u5f02\u5e38\u539f\u56e0\uff1a{}", (Object)JSON.toJSONString(urls, (boolean)true), (Object)e);
            throw new VenusRegisteException("heartBeatTime\u5165\u961f\u5217\u5f02\u5e38", (Throwable)e);
        }
    }

    private VenusServerDO getServer(Set<URL> urls) {
        VenusServerDO server = null;
        for (URL url : urls) {
            int port;
            String host = url.getHost();
            server = this.cacheVenusServerDAO.getServer(host, port = url.getPort());
            if (null == server) {
                try {
                    server = this.venusServerDAO.getServer(host, port);
                }
                catch (Exception e) {
                    LogUtils.ERROR_LOG.error("\u6839\u636ehost=>{},port=>{}\u67e5\u8be2server\u670d\u52a1\u5f02\u5e38 ", (Object)host, (Object)port);
                }
            }
            if (null == server) continue;
            break;
        }
        return server;
    }

    @Deprecated
    private void update_heartbeat(final String role, final Map<Integer, List<Integer>> maps) {
        if (MapUtils.isNotEmpty(maps)) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Integer>(){

                public Integer doInTransaction(TransactionStatus status) {
                    for (Map.Entry ent : maps.entrySet()) {
                        MysqlRegisterService.this.venusServiceMappingDAO.updateHeartBeatTime((Integer)ent.getKey(), (List)ent.getValue(), role);
                    }
                    return 1;
                }
            });
        }
    }

    public void clearInvalidService(String currentDateTime, int second) {
        List<VenusServiceMappingDO> needDeleteServiceMappings;
        List<VenusServiceMappingDO> serviceMappings = this.venusServiceMappingDAO.getServiceMappings(currentDateTime, second);
        if (CollectionUtils.isNotEmpty(serviceMappings)) {
            ArrayList<Integer> logic_mapping_ids = new ArrayList<Integer>();
            for (VenusServiceMappingDO mapping : serviceMappings) {
                logic_mapping_ids.add(mapping.getId());
            }
            if (CollectionUtils.isNotEmpty(logic_mapping_ids)) {
                LogUtils.CLEAR_INVALID.info("@@@@@@logicDeleteServiceMappings currentDateTime=>{},logic_mapping_ids=>{},serviceMappings=>{}@@@@@@@", new Object[]{currentDateTime, JSON.toJSONString(logic_mapping_ids, (boolean)true), JSON.toJSONString(serviceMappings)});
                this.venusServiceMappingDAO.logicDeleteServiceMappings(logic_mapping_ids);
            }
        }
        if (CollectionUtils.isNotEmpty(needDeleteServiceMappings = this.venusServiceMappingDAO.queryServiceMappings(8))) {
            ArrayList<Integer> delete_mapping_ids = new ArrayList<Integer>();
            ArrayList<Integer> server_ids = new ArrayList<Integer>();
            for (VenusServiceMappingDO mapping : needDeleteServiceMappings) {
                delete_mapping_ids.add(mapping.getId());
                server_ids.add(mapping.getServerId());
            }
            if (CollectionUtils.isNotEmpty(delete_mapping_ids)) {
                LogUtils.CLEAR_INVALID.info("@@@@@@currentDateTime=>{},delete_mapping_ids=>{},serviceMappings=>{}@@@@@@@", new Object[]{currentDateTime, JSON.toJSONString(delete_mapping_ids, (boolean)true), JSON.toJSONString(needDeleteServiceMappings)});
                this.venusServiceMappingDAO.deleteServiceMappings(delete_mapping_ids);
            }
            for (Integer serverId : server_ids) {
                this.deleteServer(serverId);
            }
        }
    }

    private void deleteServer(Integer serverId) {
        int mappingCountByServerId = this.venusServiceMappingDAO.getMappingCountByServerId(serverId);
        if (mappingCountByServerId <= 0) {
            this.venusServerDAO.deleteServer(serverId);
        }
    }

    public VenusServiceDAO getVenusServiceDAO() {
        return this.venusServiceDAO;
    }

    public void setVenusServiceDAO(VenusServiceDAO venusServiceDAO) {
        this.venusServiceDAO = venusServiceDAO;
    }

    public VenusServiceConfigDAO getVenusServiceConfigDAO() {
        return this.venusServiceConfigDAO;
    }

    public void setVenusServiceConfigDAO(VenusServiceConfigDAO venusServiceConfigDAO) {
        this.venusServiceConfigDAO = venusServiceConfigDAO;
    }

    public VenusApplicationDAO getVenusApplicationDAO() {
        return this.venusApplicationDAO;
    }

    public void setVenusApplicationDAO(VenusApplicationDAO venusApplicationDAO) {
        this.venusApplicationDAO = venusApplicationDAO;
    }

    public VenusServerDAO getVenusServerDAO() {
        return this.venusServerDAO;
    }

    public void setVenusServerDAO(VenusServerDAO venusServerDAO) {
        this.venusServerDAO = venusServerDAO;
    }

    public VenusServiceMappingDAO getVenusServiceMappingDAO() {
        return this.venusServiceMappingDAO;
    }

    public void setVenusServiceMappingDAO(VenusServiceMappingDAO venusServiceMappingDAO) {
        this.venusServiceMappingDAO = venusServiceMappingDAO;
    }

    public CacheVenusServerDAO getCacheVenusServerDAO() {
        return this.cacheVenusServerDAO;
    }

    public void setCacheVenusServerDAO(CacheVenusServerDAO cacheVenusServerDAO) {
        this.cacheVenusServerDAO = cacheVenusServerDAO;
    }

    public CacheVenusServiceDAO getCacheVenusServiceDAO() {
        return this.cacheVenusServiceDAO;
    }

    public void setCacheVenusServiceDAO(CacheVenusServiceDAO cacheVenusServiceDAO) {
        this.cacheVenusServiceDAO = cacheVenusServiceDAO;
    }

    public CacheServiceConfigDAO getCacheServiceConfigDAO() {
        return this.cacheServiceConfigDAO;
    }

    public void setCacheServiceConfigDAO(CacheServiceConfigDAO cacheServiceConfigDAO) {
        this.cacheServiceConfigDAO = cacheServiceConfigDAO;
    }

    public CacheVenusServiceMappingDAO getCacheVenusServiceMappingDAO() {
        return this.cacheVenusServiceMappingDAO;
    }

    public void setCacheVenusServiceMappingDAO(CacheVenusServiceMappingDAO cacheVenusServiceMappingDAO) {
        this.cacheVenusServiceMappingDAO = cacheVenusServiceMappingDAO;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public String getConnectUrl() {
        return this.connectUrl;
    }

    public void setConnectUrl(String connectUrl) {
        this.connectUrl = connectUrl;
    }

    public int getSampleMod() {
        return this.sampleMod;
    }

    public void setSampleMod(int sampleMod) {
        this.sampleMod = sampleMod;
    }

    public CacheApplicationDAO getCacheApplicationDAO() {
        return this.cacheApplicationDAO;
    }

    public void setCacheApplicationDAO(CacheApplicationDAO cacheApplicationDAO) {
        this.cacheApplicationDAO = cacheApplicationDAO;
    }

    public String getEnableLocalIp() {
        return this.enableLocalIp;
    }

    public void setEnableLocalIp(String enableLocalIp) {
        this.enableLocalIp = enableLocalIp;
    }

    public String getEnableFilterIp() {
        return this.enableFilterIp;
    }

    public void setEnableFilterIp(String enableFilterIp) {
        this.enableFilterIp = enableFilterIp;
    }

    public String getEnvIpRange() {
        return this.envIpRange;
    }

    public void setEnvIpRange(String envIpRange) {
        this.envIpRange = envIpRange;
    }

    public void updateServiceAppIds() {
        Integer totalCount = this.venusServiceDAO.getServiceCount();
        int PAGE_SIZE_200 = 200;
        if (null != totalCount && totalCount > 0) {
            int mod = totalCount % PAGE_SIZE_200;
            int count = totalCount / PAGE_SIZE_200;
            if (mod > 0) {
                ++count;
            }
            Integer mapId = null;
            for (int i = 0; i < count; ++i) {
                List<VenusServiceDO> services = this.venusServiceDAO.queryServices(PAGE_SIZE_200, mapId);
                if (!CollectionUtils.isNotEmpty(services)) continue;
                mapId = services.get(services.size() - 1).getId();
                for (VenusServiceDO serviceDO : services) {
                    String appCode = serviceDO.getName() + "_app";
                    int appId = 0;
                    if (serviceDO.getAppId() != 0 && serviceDO.getAppId() != null || !StringUtils.isNotBlank((String)appCode)) continue;
                    VenusApplicationDO application = this.venusApplicationDAO.getApplication(appCode);
                    if (null == application) {
                        VenusApplicationDO venusApplicationDO = new VenusApplicationDO();
                        venusApplicationDO.setAppCode(appCode);
                        venusApplicationDO.setCreateName("provider");
                        venusApplicationDO.setUpdateName("provider");
                        venusApplicationDO.setProvider(Boolean.valueOf(true));
                        venusApplicationDO.setConsumer(Boolean.valueOf(false));
                        venusApplicationDO.setNewApp(Boolean.valueOf(false));
                        appId = this.venusApplicationDAO.addApplication(venusApplicationDO);
                    } else {
                        appId = application.getId();
                        if (null == application.isProvider() || null != application.isProvider() && !application.isProvider().booleanValue()) {
                            application.setProvider(Boolean.valueOf(true));
                            this.venusApplicationDAO.updateApplication(application);
                        }
                    }
                    this.venusServiceDAO.updateServiceAppId(serviceDO.getId(), appId);
                }
            }
        }
    }

    private static String log_service_name(URL url) {
        String name = "";
        name = StringUtils.isNotBlank((String)url.getServiceName()) && !"null".equals(url.getServiceName()) ? url.getServiceName() : url.getInterfaceName();
        return name;
    }

    public void heartbeat(Map<String, Set<URL>> maps) {
        long start = System.currentTimeMillis();
        for (Map.Entry<String, Set<URL>> ent : maps.entrySet()) {
            this.heartbeatRegister(ent.getValue(), ent.getKey());
        }
        long end = System.currentTimeMillis() - start;
        if (end > 200L) {
            String logMsg = "";
            for (Map.Entry<String, Set<URL>> ent : maps.entrySet()) {
                String key = ent.getKey();
                if (!key.equals("provider") && !key.equals("consumer")) continue;
                Set<URL> urls = ent.getValue();
                if (CollectionUtils.isNotEmpty(urls) && StringUtils.isBlank((String)logMsg)) {
                    logMsg = MysqlRegisterService.getLogMsg(urls);
                }
                if (start % (long)this.sampleMod != 1L) continue;
                for (URL u : urls) {
                    u.setPath(null);
                    u.setProtocol(null);
                }
            }
            if (start % (long)this.sampleMod == 1L) {
                LogUtils.logSlow(end, "heartbeat maps=> " + JSON.toJSONString(maps));
            }
            if (StringUtils.isNotBlank((String)logMsg)) {
                LogUtils.logSlow(end, "heartbeat maps msg=> " + logMsg);
            }
        }
    }

    private static String getLogMsg(Set<URL> urls) {
        StringBuilder sb;
        block0: {
            sb = new StringBuilder();
            Iterator<URL> iterator = urls.iterator();
            if (!iterator.hasNext()) break block0;
            URL u = iterator.next();
            sb.append("app=>");
            sb.append(u.getApplication());
            sb.append("host=>");
            sb.append(u.getHost());
            sb.append("port=>");
            sb.append(u.getPort());
        }
        return sb.toString();
    }

    public List<VenusServiceDO> queryServiceMethods(String serviceName, String version) {
        List<VenusServiceDO> services = null;
        try {
            services = this.venusServiceDAO.queryServicesByName("", serviceName, version);
        }
        catch (Exception e) {
            LogUtils.ERROR_LOG.error("findServiceDefinitions queryServices \u8c03\u7528\u5f02\u5e38,serviceName=>" + serviceName + ",version=>" + version, (Throwable)e);
        }
        return services;
    }

    public void destroy() throws Exception {
        this.needRun = false;
        this.es.shutdown();
    }

    public List<String> queryAllServiceNames() {
        List<String> queryAllServiceNames = this.cacheVenusServiceDAO.queryAllServiceNames();
        if (CollectionUtils.isEmpty(queryAllServiceNames)) {
            ArrayList<String> returnList = new ArrayList<String>();
            Integer totalCount = this.venusServiceDAO.getServiceCount();
            if (null != totalCount && totalCount > 0) {
                int mod = totalCount % 200;
                int count = totalCount / 200;
                if (mod > 0) {
                    ++count;
                }
                int mapId = 0;
                for (int i = 0; i < count; ++i) {
                    List<VenusServiceDO> services = this.venusServiceDAO.queryServices(200, mapId);
                    if (!CollectionUtils.isNotEmpty(services)) continue;
                    mapId = services.get(services.size() - 1).getId();
                    for (VenusServiceDO vs : services) {
                        String name = vs.getName();
                        if (!RegistryUtil.isNotBlank((String)name) || returnList.contains(name)) continue;
                        returnList.add(name);
                    }
                }
            }
            return returnList;
        }
        return queryAllServiceNames;
    }

    public List<VenusServiceDO> queryServices(int start, int size) {
        return this.venusServiceDAO.queryPageServices(start, size);
    }

    public int getServicesCount() {
        return this.venusServiceDAO.getServiceCount();
    }

    public List<VenusServiceDO> searchServices(String keyword, String version) {
        return this.venusServiceDAO.queryServicesByKeyWord(keyword, version, 50);
    }

    private class UpdateHeartbeatTimeRunnable
    implements Runnable {
        private String threadName;

        public String getThreadName() {
            return this.threadName;
        }

        public void setThreadName(String threadName) {
            this.threadName = threadName;
        }

        public UpdateHeartbeatTimeRunnable(String threadName) {
            this.threadName = threadName;
        }

        @Override
        public void run() {
            while (MysqlRegisterService.this.needRun) {
                try {
                    int startSize = HEARTBEAT_QUEUE.size();
                    UpdateHeartBeatTimeDTO heartbeatDto = HEARTBEAT_QUEUE.poll();
                    if (null == heartbeatDto) continue;
                    int endSize = HEARTBEAT_QUEUE.size();
                    long start = System.currentTimeMillis();
                    boolean update = MysqlRegisterService.this.venusServiceMappingDAO.updateHeartBeatTime(heartbeatDto.getServerId(), heartbeatDto.getServiceIds(), heartbeatDto.getRole());
                    long consumerTime = System.currentTimeMillis() - start;
                    LogUtils.logSlow(consumerTime, "UpdateHeartbeatTimeRunnable run() ");
                    if (!update) {
                        LogUtils.HEARTBEAT_LOG.info("UpdateHeartbeatTimeRunnable.poll startSize=>{},endSize=>{},update=>{},heartbeatDto=>{}", new Object[]{startSize, endSize, update, JSON.toJSONString((Object)heartbeatDto)});
                    }
                    if (start % (long)MysqlRegisterService.this.sampleMod != 1L) continue;
                    LogUtils.HEARTBEAT_LOG.info("UpdateHeartbeatTimeRunnable.sampling startSize=>{},endSize=>{},update=>{},consumerTime=>{},heartbeatDto=>{}", new Object[]{startSize, endSize, update, consumerTime, JSON.toJSONString((Object)heartbeatDto)});
                }
                catch (Throwable e) {
                    LogUtils.ERROR_LOG.error("UpdateHeartbeatTimeRunnable consumer thread is error" + e.getMessage(), e);
                }
            }
        }
    }
}

