/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.registry.service.impl;

import com.meidusa.toolkit.common.runtime.GlobalScheduler;
import com.meidusa.venus.registry.LogUtils;
import com.meidusa.venus.registry.VenusRegisteException;
import com.meidusa.venus.registry.service.RegisterService;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class ClearInvalidService {
    private RegisterService registerService;

    public void init() throws Exception {
        LogUtils.CLEAR_INVALID.info("ClearInvalidService init ");
        GlobalScheduler.getInstance().scheduleAtFixedRate((Runnable)new ClearInvalidRunnable(), 2L, 30L, TimeUnit.SECONDS);
    }

    public void clearInvalid() throws VenusRegisteException {
        int seconds = 30;
        try {
            Date date = ClearInvalidService.getSubSecond(new Date(), seconds);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String currentDateTime = format.format(date);
            this.registerService.clearInvalidService(currentDateTime, seconds);
        }
        catch (Exception e) {
            LogUtils.ERROR_LOG.error("ClearInvalidRunnable is error", (Throwable)e);
        }
    }

    public static final Date getSubSecond(Date date, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, -second);
        return calendar.getTime();
    }

    public RegisterService getRegisterService() {
        return this.registerService;
    }

    public void setRegisterService(RegisterService registerService) {
        this.registerService = registerService;
    }

    private class ClearInvalidRunnable
    implements Runnable {
        private ClearInvalidRunnable() {
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            ClearInvalidService.this.clearInvalid();
            long consumerTime = System.currentTimeMillis() - start;
            LogUtils.logSlow5000(consumerTime, "ClearInvalidRunnable load() ");
            LogUtils.CLEAR_INVALID.info("ClearInvalidRunnable end consumerTime=>{}", (Object)consumerTime);
        }
    }
}

