/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.registry.dao.impl;

import com.meidusa.venus.registry.DAOException;
import com.meidusa.venus.registry.dao.VenusServiceMappingDAO;
import com.meidusa.venus.registry.dao.impl.ResultUtils;
import com.meidusa.venus.registry.data.move.ServiceMappingDTO;
import com.meidusa.venus.registry.domain.VenusServiceMappingDO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;

public class VenusServiceMappingDaoImpl
implements VenusServiceMappingDAO {
    private static final String SELECT_FIELDS_TABLE = "select id, server_id, service_id, version, active, sync,role,provider_app_id,consumer_app_id,is_delete,create_time, update_time,registe_time,heartbeat_time from t_venus_service_mapping ";
    private JdbcTemplate jdbcTemplate;

    public VenusServiceMappingDaoImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public boolean addServiceMapping(VenusServiceMappingDO mapping) throws DAOException {
        String sql = "insert into t_venus_service_mapping (server_id,service_id,provider_app_id,consumer_app_id,version, active, sync,role,is_delete,create_time, update_time,registe_time,heartbeat_time) values (?, ?, ?, ?, ?, ?, ?, ?, ?,now(), now(),now(),now())";
        int update = 0;
        try {
            update = this.jdbcTemplate.update(sql, new Object[]{mapping.getServerId(), mapping.getServiceId(), mapping.getProviderAppId(), mapping.getConsumerAppId(), mapping.getVersion(), mapping.isActive(), mapping.isSync(), mapping.getRole(), mapping.getIsDelete()});
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58\u670d\u52a1\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", e);
        }
        return update > 0;
    }

    @Override
    public boolean updateSubcribeServiceMapping(int id, int consumerAppId, boolean active, boolean isDelete) throws DAOException {
        String sql = "update t_venus_service_mapping set active = ?,is_delete=?,update_time=now(),registe_time=now(),heartbeat_time=now()";
        if (consumerAppId > 0) {
            sql = sql + ",consumer_app_id=? ";
        }
        sql = sql + " where id = ? ";
        int update = 0;
        try {
            update = consumerAppId > 0 ? this.jdbcTemplate.update(sql, new Object[]{active, isDelete, consumerAppId, id}) : this.jdbcTemplate.update(sql, new Object[]{active, isDelete, id});
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", e);
        }
        return update > 0;
    }

    @Override
    public boolean updateProviderServiceMapping(int id, boolean active, boolean isDelete, int providerAppId) throws DAOException {
        String sql = "update t_venus_service_mapping set active = ?,is_delete=?,update_time=now(),registe_time=now(),heartbeat_time=now()";
        if (providerAppId > 0) {
            sql = sql + ",provider_app_id=? ";
        }
        sql = sql + " where id = ?";
        int update = 0;
        try {
            update = providerAppId > 0 ? this.jdbcTemplate.update(sql, new Object[]{active, isDelete, providerAppId, id}) : this.jdbcTemplate.update(sql, new Object[]{active, isDelete, id});
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", e);
        }
        return update > 0;
    }

    @Override
    public boolean logicDeleteOldMappings(int serverId, int providerAppId, String role) throws DAOException {
        String sql = "update t_venus_service_mapping set active = 0,is_delete=1,update_time=now() ";
        sql = sql + " where server_id = ? and provider_app_id!=? and role=?";
        int update = 0;
        try {
            update = this.jdbcTemplate.update(sql, new Object[]{serverId, providerAppId, role});
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", e);
        }
        return update > 0;
    }

    @Override
    public boolean updateHeartBeatTime(int serverId, String role) throws DAOException {
        String sql = "update t_venus_service_mapping set is_delete=0,heartbeat_time = now() where server_id = ? and role=? ";
        int update = 0;
        try {
            update = this.jdbcTemplate.update(sql, new Object[]{serverId, role});
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u6620\u5c04\u5173\u7cfbheartbeat_time\u65f6\u95f4\u5f02\u5e38", e);
        }
        return update > 0;
    }

    @Override
    public boolean deleteServiceMapping(int id) throws DAOException {
        String sql = "delete from t_venus_service_mapping where id = ? ";
        int update = 0;
        try {
            update = this.jdbcTemplate.update(sql, new Object[]{id});
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", e);
        }
        return update > 0;
    }

    @Override
    public VenusServiceMappingDO getServiceMapping(Integer serverId, Integer serviceId, String role) throws DAOException {
        String sql = "select id, server_id, service_id, version, active, sync,role,provider_app_id,consumer_app_id,is_delete,create_time, update_time,registe_time,heartbeat_time from t_venus_service_mapping  where server_id = ? and service_id = ? and role=?";
        try {
            return (VenusServiceMappingDO)this.jdbcTemplate.query(sql, new Object[]{serverId, serviceId, role}, (ResultSetExtractor)new ResultSetExtractor<VenusServiceMappingDO>(){

                public VenusServiceMappingDO extractData(ResultSet rs) throws SQLException, DataAccessException {
                    if (rs.next()) {
                        return ResultUtils.resultToVenusServiceMappingDO(rs);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eserverId=>" + serverId + ",serviceId=>" + serviceId + "\u83b7\u53d6\u670d\u52a1\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", e);
        }
    }

    @Override
    public List<VenusServiceMappingDO> getServiceMapping(Integer serviceId, String role, boolean isDelete) throws DAOException {
        String sql = "select id, server_id, service_id, version, active, sync,role,provider_app_id,consumer_app_id,is_delete,create_time, update_time,registe_time,heartbeat_time from t_venus_service_mapping  where service_id = ? and role=? and is_delete=?";
        try {
            return (List)this.jdbcTemplate.query(sql, new Object[]{serviceId, role, isDelete}, (ResultSetExtractor)new ResultSetExtractor<List<VenusServiceMappingDO>>(){

                public List<VenusServiceMappingDO> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<VenusServiceMappingDO> returnList = new ArrayList<VenusServiceMappingDO>();
                    while (rs.next()) {
                        returnList.add(ResultUtils.resultToVenusServiceMappingDO(rs));
                    }
                    return returnList;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eserviceId=>" + serviceId + "\u83b7\u53d6\u670d\u52a1\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", e);
        }
    }

    @Override
    public VenusServiceMappingDO getServiceMapping(Integer id) throws DAOException {
        String sql = "select id, server_id, service_id, version, active, sync,role,provider_app_id,consumer_app_id,is_delete,create_time, update_time,registe_time,heartbeat_time from t_venus_service_mapping  where id = ?";
        try {
            return (VenusServiceMappingDO)this.jdbcTemplate.query(sql, new Object[]{id}, (ResultSetExtractor)new ResultSetExtractor<VenusServiceMappingDO>(){

                public VenusServiceMappingDO extractData(ResultSet rs) throws SQLException, DataAccessException {
                    if (rs.next()) {
                        return ResultUtils.resultToVenusServiceMappingDO(rs);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eID\uff1d>" + id + "\u83b7\u53d6\u670d\u52a1\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", e);
        }
    }

    @Override
    public List<VenusServiceMappingDO> getServiceMappings(Integer serverId) throws DAOException {
        String sql = "select id, server_id, service_id, version, active, sync,role,provider_app_id,consumer_app_id,is_delete,create_time, update_time,registe_time,heartbeat_time from t_venus_service_mapping  where server_id = ?";
        try {
            return (List)this.jdbcTemplate.query(sql, new Object[]{serverId}, (ResultSetExtractor)new ResultSetExtractor<List<VenusServiceMappingDO>>(){

                public List<VenusServiceMappingDO> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<VenusServiceMappingDO> returnList = new ArrayList<VenusServiceMappingDO>();
                    while (rs.next()) {
                        VenusServiceMappingDO mapping = ResultUtils.resultToVenusServiceMappingDO(rs);
                        returnList.add(mapping);
                    }
                    return returnList;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eserverID\uff1d>" + serverId + "\u83b7\u53d6\u670d\u52a1\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", e);
        }
    }

    @Override
    public List<VenusServiceMappingDO> getServiceMappings(String dateStr, int second) throws DAOException {
        String sql = "select m.id, m.server_id, m.service_id, m.version, m.active, m.sync,m.role,m.provider_app_id,m.consumer_app_id,m.is_delete,m.create_time, m.update_time,m.registe_time,m.heartbeat_time from t_venus_service_mapping as m left join t_venus_service as v on m.service_id=v.id where m.has_heartbeat=1 and m.is_delete=0 and m.heartbeat_time <= subdate(now(),interval " + second + " second) ";
        try {
            return (List)this.jdbcTemplate.query(sql, new Object[0], (ResultSetExtractor)new ResultSetExtractor<List<VenusServiceMappingDO>>(){

                public List<VenusServiceMappingDO> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<VenusServiceMappingDO> returnList = new ArrayList<VenusServiceMappingDO>();
                    while (rs.next()) {
                        VenusServiceMappingDO mapping = ResultUtils.resultToVenusServiceMappingDO(rs);
                        returnList.add(mapping);
                    }
                    return returnList;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eheartbeat_time\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\u51cf\u53bb" + second + "\u79d2\u83b7\u53d6\u670d\u52a1\u6620\u5c04\u5173\u7cfb\u5217\u8868\u5f02\u5e38", e);
        }
    }

    @Override
    public List<VenusServiceMappingDO> queryServiceMappings(int hour) throws DAOException {
        String sql = "select m.id, m.server_id, m.service_id, m.version, m.active, m.sync,m.role,m.provider_app_id,m.consumer_app_id,m.is_delete,m.create_time, m.update_time,m.registe_time,m.heartbeat_time from t_venus_service_mapping as m left join t_venus_service as v on m.service_id=v.id where m.has_heartbeat=1 and m.is_delete=1 and m.heartbeat_time <= subdate(now(),interval " + hour + " hour) ";
        try {
            return (List)this.jdbcTemplate.query(sql, new Object[0], (ResultSetExtractor)new ResultSetExtractor<List<VenusServiceMappingDO>>(){

                public List<VenusServiceMappingDO> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<VenusServiceMappingDO> returnList = new ArrayList<VenusServiceMappingDO>();
                    while (rs.next()) {
                        VenusServiceMappingDO mapping = ResultUtils.resultToVenusServiceMappingDO(rs);
                        returnList.add(mapping);
                    }
                    return returnList;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eheartbeat_time\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\u51cf\u53bb" + hour + "\u5c0f\u65f6\u83b7\u53d6\u670d\u52a1\u6620\u5c04\u5173\u7cfb\u5217\u8868\u5f02\u5e38", e);
        }
    }

    @Override
    public List<VenusServiceMappingDO> getDeleteServiceMappings(String updateTime, String role, boolean isDelete) throws DAOException {
        String sql = "select id, server_id, service_id, version, active, sync,role,provider_app_id,consumer_app_id,is_delete,create_time, update_time,registe_time,heartbeat_time from t_venus_service_mapping  where update_time >= ? and role=? and is_delete=?";
        try {
            return (List)this.jdbcTemplate.query(sql, new Object[]{updateTime, role, isDelete}, (ResultSetExtractor)new ResultSetExtractor<List<VenusServiceMappingDO>>(){

                public List<VenusServiceMappingDO> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<VenusServiceMappingDO> returnList = new ArrayList<VenusServiceMappingDO>();
                    while (rs.next()) {
                        VenusServiceMappingDO mapping = ResultUtils.resultToVenusServiceMappingDO(rs);
                        returnList.add(mapping);
                    }
                    return returnList;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u5927\u4e8e\u7b49\u4e8eupdate_time\uff1d>" + updateTime + "\u83b7\u53d6\u670d\u52a1\u6620\u5c04\u5173\u7cfb\u5217\u8868\u5f02\u5e38", e);
        }
    }

    @Override
    public List<VenusServiceMappingDO> getServiceMappings(int serviceId) throws DAOException {
        String sql = "select id, server_id, service_id, version, active, sync,role,provider_app_id,consumer_app_id,is_delete,create_time, update_time,registe_time,heartbeat_time from t_venus_service_mapping  where service_id = ?";
        try {
            return (List)this.jdbcTemplate.query(sql, new Object[]{serviceId}, (ResultSetExtractor)new ResultSetExtractor<List<VenusServiceMappingDO>>(){

                public List<VenusServiceMappingDO> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<VenusServiceMappingDO> returnList = new ArrayList<VenusServiceMappingDO>();
                    while (rs.next()) {
                        VenusServiceMappingDO mapping = ResultUtils.resultToVenusServiceMappingDO(rs);
                        returnList.add(mapping);
                    }
                    return returnList;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u7b49\u4e8eserviceId\uff1d>" + serviceId + "\u83b7\u53d6\u670d\u52a1\u6620\u5c04\u5173\u7cfb\u5217\u8868\u5f02\u5e38", e);
        }
    }

    @Override
    public boolean updateServiceMappings(List<Integer> ids) throws DAOException {
        if (ids.isEmpty()) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (Integer id : ids) {
            sb.append(id);
            sb.append(",");
        }
        String str = sb.substring(0, sb.length() - 1);
        String sql = "update t_venus_service_mapping set is_delete=?,update_time=now() where id in(" + str + ")";
        int update = 0;
        try {
            update = this.jdbcTemplate.update(sql, new Object[]{true});
        }
        catch (Exception e) {
            throw new DAOException("\u903b\u8f91\u5220\u9664\u66f4\u65b0\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", e);
        }
        return update > 0;
    }

    @Override
    public boolean deleteServiceMappings(List<Integer> ids) throws DAOException {
        if (ids.isEmpty()) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (Integer id : ids) {
            sb.append(id);
            sb.append(",");
        }
        String str = sb.substring(0, sb.length() - 1);
        String sql = "delete from t_venus_service_mapping where id in(" + str + ")";
        int update = 0;
        try {
            update = this.jdbcTemplate.update(sql);
        }
        catch (Exception e) {
            throw new DAOException("\u903b\u8f91\u5220\u9664\u66f4\u65b0\u6620\u5c04\u5173\u7cfb\u5f02\u5e38,sql=>" + sql, e);
        }
        return update > 0;
    }

    @Override
    public boolean logicDeleteServiceMappings(List<Integer> ids) throws DAOException {
        if (ids.isEmpty()) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (Integer id : ids) {
            sb.append(id);
            sb.append(",");
        }
        String str = sb.substring(0, sb.length() - 1);
        String sql = "update t_venus_service_mapping set is_delete=1 where id in(" + str + ")";
        int update = 0;
        try {
            update = this.jdbcTemplate.update(sql);
        }
        catch (Exception e) {
            throw new DAOException("\u903b\u8f91\u5220\u9664\u66f4\u65b0\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", e);
        }
        return update > 0;
    }

    @Override
    public boolean existServiceMapping(String hostName, int port, String serviceName, String version) throws DAOException {
        String sql = "SELECT count(map.id) as records FROM t_venus_service_mapping as map left join t_venus_server as s on map.server_id=s.id left join t_venus_service as v on v.id=map.service_id  where s.hostname='" + hostName + "' and s.port=" + port + " and v.name='" + serviceName + "' and map.role='provider'";
        sql = StringUtils.isBlank((String)version) || "null".equalsIgnoreCase(version) ? sql + " and map.version is null " : sql + " and map.version='" + version + "' ";
        try {
            return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class) > 0;
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u7b49\u4e8eserviceName\uff1d>" + serviceName + ",hostName=>" + hostName + ",port=>" + port + "\u83b7\u53d6\u670d\u52a1\u6620\u5c04\u5173\u7cfb\u4e2a\u6570\u5f02\u5e38", e);
        }
    }

    @Override
    public int getMappingCountByServerId(int serverId) throws DAOException {
        String sql = "SELECT count(map.id) as records FROM t_venus_service_mapping as map where map.server_id=" + serverId;
        try {
            return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eserverId\uff1d>" + serverId + ",\u83b7\u53d6\u670d\u52a1\u6620\u5c04\u5173\u7cfb\u4e2a\u6570\u5f02\u5e38", e);
        }
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public boolean updateHeartBeatTime(int serverId, List<Integer> serviceIds, String role) throws DAOException {
        if (serviceIds.isEmpty()) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (Integer id : serviceIds) {
            sb.append(id);
            sb.append(",");
        }
        String str = sb.substring(0, sb.length() - 1);
        String sql = "update t_venus_service_mapping set is_delete=0,has_heartbeat=1,heartbeat_time = now() where server_id = ? and role=? and service_id in(" + str + ")";
        int update = 0;
        try {
            update = this.jdbcTemplate.update(sql, new Object[]{serverId, role});
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0\u6620\u5c04\u5173\u7cfb\u5fc3\u8df3\u65f6\u95f4\u5f02\u5e38", e);
        }
        return update > 0;
    }

    @Override
    public List<ServiceMappingDTO> queryServiceMappings(List<String> serviceNames) throws DAOException {
        StringBuilder sb = new StringBuilder();
        for (String name : serviceNames) {
            sb.append("'");
            sb.append(name);
            sb.append("'");
            sb.append(",");
        }
        String nameStr = sb.substring(0, sb.length() - 1);
        String sql = "SELECT map.id as map_id,map.server_id,map.version,s.hostname as host_name,s.port,v.name as service_name,map.service_id FROM t_venus_service_mapping as map left join t_venus_server as s on map.server_id=s.id left join t_venus_service as v on v.id=map.service_id where v.name in(" + nameStr + ") and map.role=? and v.registe_type=? ";
        try {
            return (List)this.jdbcTemplate.query(sql, new Object[]{"provider", 0}, (ResultSetExtractor)new ResultSetExtractor<List<ServiceMappingDTO>>(){

                public List<ServiceMappingDTO> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<ServiceMappingDTO> returnList = new ArrayList<ServiceMappingDTO>();
                    while (rs.next()) {
                        returnList.add(ResultUtils.rsTransServiceMappingDTO(rs));
                    }
                    return returnList;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636esql=>" + sql + ",serviceName=>" + serviceNames + ";\u83b7\u53d6\u670d\u52a1\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", e);
        }
    }

    @Override
    public List<ServiceMappingDTO> queryServiceMappings(String serviceName) throws DAOException {
        String sql = "SELECT map.id as map_id,map.server_id,map.version,s.hostname as host_name,s.port,v.name as service_name,map.service_id FROM t_venus_service_mapping as map left join t_venus_server as s on map.server_id=s.id left join t_venus_service as v on v.id=map.service_id where v.name =? and role=? and v.registe_type=? ";
        try {
            return (List)this.jdbcTemplate.query(sql, new Object[]{serviceName, "provider", 0}, (ResultSetExtractor)new ResultSetExtractor<List<ServiceMappingDTO>>(){

                public List<ServiceMappingDTO> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<ServiceMappingDTO> returnList = new ArrayList<ServiceMappingDTO>();
                    while (rs.next()) {
                        returnList.add(ResultUtils.rsTransServiceMappingDTO(rs));
                    }
                    return returnList;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636esql=>" + sql + ",serviceName=>" + serviceName + ";\u83b7\u53d6\u670d\u52a1\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", e);
        }
    }

    @Override
    public int getMappingCount() throws DAOException {
        String sql = "SELECT count(id) as records FROM t_venus_service_mapping as map where role='provider' and is_delete=0";
        try {
            return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2mappint count\u51fa\u9519,\u83b7\u53d6\u670d\u52a1\u6620\u5c04\u5173\u7cfb\u4e2a\u6570\u5f02\u5e38", e);
        }
    }

    @Override
    public List<VenusServiceMappingDO> queryServiceMappings(Integer pageSize, Integer id) throws DAOException {
        String sql = "select id, server_id, service_id, version, active, sync,role,provider_app_id,consumer_app_id,is_delete,create_time, update_time,registe_time,heartbeat_time from t_venus_service_mapping  where id>" + id + " and role='" + "provider" + "' and is_delete=0 order by id asc limit " + pageSize;
        try {
            return (List)this.jdbcTemplate.query(sql, (ResultSetExtractor)new ResultSetExtractor<List<VenusServiceMappingDO>>(){

                public List<VenusServiceMappingDO> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<VenusServiceMappingDO> returnList = new ArrayList<VenusServiceMappingDO>();
                    while (rs.next()) {
                        returnList.add(ResultUtils.resultToVenusServiceMappingDO(rs));
                    }
                    return returnList;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eid=>" + id + "\u83b7\u53d6\u670d\u52a1\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", e);
        }
    }
}

