/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.registry.dao.impl;

import com.meidusa.venus.registry.DAOException;
import com.meidusa.venus.registry.dao.VenusServiceConfigDAO;
import com.meidusa.venus.registry.dao.impl.ResultUtils;
import com.meidusa.venus.registry.domain.VenusServiceConfigDO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;

public class VenusServiceConfigDaoImpl
implements VenusServiceConfigDAO {
    private JdbcTemplate jdbcTemplate;

    public VenusServiceConfigDaoImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public List<VenusServiceConfigDO> getServiceConfigs(Integer serviceId) throws DAOException {
        String sql = "select id, type,config,service_id,create_name,update_name,create_time, update_time from t_venus_service_config where service_id = ?";
        try {
            return (List)this.jdbcTemplate.query(sql, new Object[]{serviceId}, (ResultSetExtractor)new ResultSetExtractor<List<VenusServiceConfigDO>>(){

                public List<VenusServiceConfigDO> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<VenusServiceConfigDO> returnList = new ArrayList<VenusServiceConfigDO>();
                    while (rs.next()) {
                        returnList.add(ResultUtils.resultToVenusServiceConfigDO(rs));
                    }
                    return returnList;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eserviceId=>" + serviceId + "\u83b7\u53d6ServiceConfig\u5f02\u5e38", e);
        }
    }

    @Override
    public List<VenusServiceConfigDO> queryServiceConfigs(int pageSize, Integer id) throws DAOException {
        String sql = "select id, type,config,service_id,create_name,update_name,create_time, update_time from t_venus_service_config ";
        if (null != id) {
            sql = sql + " where id>" + id;
        }
        sql = sql + " order by id asc limit " + pageSize;
        try {
            return (List)this.jdbcTemplate.query(sql, new Object[0], (ResultSetExtractor)new ResultSetExtractor<List<VenusServiceConfigDO>>(){

                public List<VenusServiceConfigDO> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<VenusServiceConfigDO> returnList = new ArrayList<VenusServiceConfigDO>();
                    while (rs.next()) {
                        returnList.add(ResultUtils.resultToVenusServiceConfigDO(rs));
                    }
                    return returnList;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636esql=>" + sql + ";\u83b7\u53d6\u4e3b\u673a\u5217\u8868\u5f02\u5e38", e);
        }
    }

    @Override
    public int getServiceConfigCount() throws DAOException {
        String sql = "SELECT count(id) as records FROM t_venus_service_config ";
        try {
            return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636esql=>" + sql + ";\u83b7\u53d6\u4e3b\u673a\u8bb0\u5f55\u6570\u5f02\u5e38", e);
        }
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

