/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.registry.dao.impl;

import com.meidusa.venus.registry.DAOException;
import com.meidusa.venus.registry.dao.VenusServerDAO;
import com.meidusa.venus.registry.dao.impl.ResultUtils;
import com.meidusa.venus.registry.domain.VenusServerDO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class VenusServerDaoImpl
implements VenusServerDAO {
    private JdbcTemplate jdbcTemplate;

    public VenusServerDaoImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public int addServer(VenusServerDO venusServerDO) throws DAOException {
        final String sql = "insert into t_venus_server (hostname,port,create_time, update_time) values ('" + venusServerDO.getHostname() + "', " + venusServerDO.getPort() + ", now(), now())";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        int autoIncId = 0;
        this.jdbcTemplate.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(sql, 1);
                return ps;
            }
        }, (KeyHolder)keyHolder);
        autoIncId = keyHolder.getKey().intValue();
        return autoIncId;
    }

    @Override
    public boolean updateServer(VenusServerDO venusServerDO) throws DAOException {
        String sql = "update t_venus_server set hostname=?,port=?, update_time=now() where id=?";
        int update = 0;
        try {
            update = this.jdbcTemplate.update(sql, new Object[]{venusServerDO.getHostname(), venusServerDO.getPort(), venusServerDO.getId()});
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0venusServer\u5f02\u5e38", e);
        }
        return update > 0;
    }

    @Override
    public VenusServerDO getServer(Integer id) throws DAOException {
        String sql = "select id, hostname,port,create_time, update_time from t_venus_server where id = ?";
        try {
            return (VenusServerDO)this.jdbcTemplate.query(sql, new Object[]{id}, (ResultSetExtractor)new ResultSetExtractor<VenusServerDO>(){

                public VenusServerDO extractData(ResultSet rs) throws SQLException, DataAccessException {
                    if (rs.next()) {
                        return ResultUtils.resultToVenusServerDO(rs);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eID\u83b7\u53d6venusServer\u5f02\u5e38", e);
        }
    }

    @Override
    public List<VenusServerDO> getServers(List<Integer> ids) throws DAOException {
        StringBuilder sb = new StringBuilder();
        for (Integer id : ids) {
            sb.append(id);
            sb.append(",");
        }
        String str = sb.substring(0, sb.length() - 1);
        String sql = "select id, hostname,port,create_time, update_time from t_venus_server where id in(" + str + ")";
        try {
            return (List)this.jdbcTemplate.query(sql, (ResultSetExtractor)new ResultSetExtractor<List<VenusServerDO>>(){

                public List<VenusServerDO> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<VenusServerDO> returnList = new ArrayList<VenusServerDO>();
                    while (rs.next()) {
                        returnList.add(ResultUtils.resultToVenusServerDO(rs));
                    }
                    return returnList;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eIDS" + str + "\u83b7\u53d6venusServer\u5f02\u5e38", e);
        }
    }

    @Override
    public VenusServerDO getServer(String host, Integer port) throws DAOException {
        String sql = "select id, hostname,port,create_time, update_time from t_venus_server where hostname = ? and port = ? ";
        Object[] params = new Object[]{host, port};
        try {
            return (VenusServerDO)this.jdbcTemplate.query(sql, params, (ResultSetExtractor)new ResultSetExtractor<VenusServerDO>(){

                public VenusServerDO extractData(ResultSet rs) throws SQLException, DataAccessException {
                    if (rs.next()) {
                        return ResultUtils.resultToVenusServerDO(rs);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636ehost \u548c port \u83b7\u53d6venusServer\u5f02\u5e38", e);
        }
    }

    @Override
    public List<VenusServerDO> getServer(String host) throws DAOException {
        String sql = "select id, hostname,port,create_time, update_time from t_venus_server where hostname = ?  ";
        Object[] params = new Object[]{host};
        try {
            return (List)this.jdbcTemplate.query(sql, params, (ResultSetExtractor)new ResultSetExtractor<List<VenusServerDO>>(){

                public List<VenusServerDO> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<VenusServerDO> returnList = new ArrayList<VenusServerDO>();
                    while (rs.next()) {
                        VenusServerDO resultToVenusServerDO = ResultUtils.resultToVenusServerDO(rs);
                        returnList.add(resultToVenusServerDO);
                    }
                    return returnList;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636ehost\u83b7\u53d6venusServer\u5f02\u5e38", e);
        }
    }

    @Override
    public boolean deleteServer(int id) throws DAOException {
        String sql = "delete from t_venus_server where id =? ";
        int update = 0;
        try {
            update = this.jdbcTemplate.update(sql, new Object[]{id});
        }
        catch (Exception e) {
            throw new DAOException("\u903b\u8f91\u5220\u9664\u66f4\u65b0\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", e);
        }
        return update > 0;
    }

    @Override
    public Integer getServerCount() throws DAOException {
        String sql = "SELECT count(id) as records FROM t_venus_server ";
        try {
            return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636esql=>" + sql + ";\u83b7\u53d6\u4e3b\u673a\u8bb0\u5f55\u6570\u5f02\u5e38", e);
        }
    }

    @Override
    public List<VenusServerDO> queryServers(Integer pageSize, Integer id) throws DAOException {
        String sql = "SELECT id,hostname,port,create_time, update_time FROM t_venus_server ";
        if (null != id) {
            sql = sql + " where id>" + id;
        }
        sql = sql + " order by id asc limit " + pageSize;
        try {
            return (List)this.jdbcTemplate.query(sql, new Object[0], (ResultSetExtractor)new ResultSetExtractor<List<VenusServerDO>>(){

                public List<VenusServerDO> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<VenusServerDO> returnList = new ArrayList<VenusServerDO>();
                    while (rs.next()) {
                        returnList.add(ResultUtils.resultToVenusServerDO(rs));
                    }
                    return returnList;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636esql=>" + sql + ";\u83b7\u53d6\u4e3b\u673a\u5217\u8868\u5f02\u5e38", e);
        }
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

