/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.registry.dao.impl;

import com.meidusa.venus.registry.DAOException;
import com.meidusa.venus.registry.dao.VenusApplicationDAO;
import com.meidusa.venus.registry.dao.impl.ResultUtils;
import com.meidusa.venus.registry.domain.VenusApplicationDO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class VenusApplicationDaoImpl
implements VenusApplicationDAO {
    private static final String SELECT_FIELDS = "select id,app_code,provider,consumer,create_name,update_name,create_time,update_time,new_app from t_venus_application ";
    private JdbcTemplate jdbcTemplate;

    public VenusApplicationDaoImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public int addApplication(VenusApplicationDO venusApplicationDO) throws DAOException {
        final String sql = "insert into t_venus_application (app_code,provider,consumer,create_name,update_name,create_time, update_time,new_app) values ('" + venusApplicationDO.getAppCode() + "'," + venusApplicationDO.isProvider() + "," + venusApplicationDO.isConsumer() + ", '" + venusApplicationDO.getCreateName() + "', '" + venusApplicationDO.getUpdateName() + "', now(), now()," + venusApplicationDO.getNewApp() + ")";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        int autoIncId = 0;
        this.jdbcTemplate.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(sql, 1);
                return ps;
            }
        }, (KeyHolder)keyHolder);
        autoIncId = keyHolder.getKey().intValue();
        return autoIncId;
    }

    @Override
    public boolean updateApplication(VenusApplicationDO venusApplicationDO) throws DAOException {
        String sql = "update t_venus_application set provider=?,consumer=?,update_time=now() where id=?";
        int update = 0;
        try {
            update = this.jdbcTemplate.update(sql, new Object[]{venusApplicationDO.isProvider(), venusApplicationDO.isConsumer(), venusApplicationDO.getId()});
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0venusApplication\u5f02\u5e38", e);
        }
        return update > 0;
    }

    @Override
    public boolean updateApplication(boolean newApp, int id) throws DAOException {
        String sql = "update t_venus_application set new_app=? where id=?";
        int update = 0;
        try {
            update = this.jdbcTemplate.update(sql, new Object[]{newApp, id});
        }
        catch (Exception e) {
            throw new DAOException("\u66f4\u65b0venusApplication newApp\u5f02\u5e38", e);
        }
        return update > 0;
    }

    @Override
    public VenusApplicationDO getApplication(String appCode) throws DAOException {
        String sql = "select id,app_code,provider,consumer,create_name,update_name,create_time,update_time,new_app from t_venus_application  where app_code = ?";
        try {
            return (VenusApplicationDO)this.jdbcTemplate.query(sql, new Object[]{appCode}, (ResultSetExtractor)new ResultSetExtractor<VenusApplicationDO>(){

                public VenusApplicationDO extractData(ResultSet rs) throws SQLException, DataAccessException {
                    if (rs.next()) {
                        return ResultUtils.resultToVenusApplicationDO(rs);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e appCode \u83b7\u53d6venusApplication\u5f02\u5e38", e);
        }
    }

    @Override
    public VenusApplicationDO getApplication(Integer id) throws DAOException {
        String sql = "select id,app_code,provider,consumer,create_name,update_name,create_time,update_time,new_app from t_venus_application  where id = ?";
        try {
            return (VenusApplicationDO)this.jdbcTemplate.query(sql, new Object[]{id}, (ResultSetExtractor)new ResultSetExtractor<VenusApplicationDO>(){

                public VenusApplicationDO extractData(ResultSet rs) throws SQLException, DataAccessException {
                    if (rs.next()) {
                        return ResultUtils.resultToVenusApplicationDO(rs);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6venusApplication\u5f02\u5e38", e);
        }
    }

    @Override
    public int getApplicationCount() throws DAOException {
        String sql = "SELECT count(id) as records FROM t_venus_application ";
        try {
            return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636esql=>" + sql + ";\u83b7\u53d6\u4e3b\u673a\u8bb0\u5f55\u6570\u5f02\u5e38", e);
        }
    }

    @Override
    public List<VenusApplicationDO> queryApplications(Integer pageSize, Integer id) throws DAOException {
        String sql = SELECT_FIELDS;
        if (null != id) {
            sql = sql + " where id>" + id;
        }
        sql = sql + " order by id asc limit " + pageSize;
        try {
            return (List)this.jdbcTemplate.query(sql, new Object[0], (ResultSetExtractor)new ResultSetExtractor<List<VenusApplicationDO>>(){

                public List<VenusApplicationDO> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<VenusApplicationDO> returnList = new ArrayList<VenusApplicationDO>();
                    while (rs.next()) {
                        returnList.add(ResultUtils.resultToVenusApplicationDO(rs));
                    }
                    return returnList;
                }
            });
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636esql=>" + sql + ";\u83b7\u53d6\u4e3b\u673a\u5217\u8868\u5f02\u5e38", e);
        }
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

