/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.registry.dao.impl;

import com.meidusa.fastjson.JSON;
import com.meidusa.venus.registry.data.move.OldServerDO;
import com.meidusa.venus.registry.data.move.OldServiceDO;
import com.meidusa.venus.registry.data.move.OldServiceMappingDO;
import com.meidusa.venus.registry.data.move.ServiceMappingDTO;
import com.meidusa.venus.registry.domain.FlowControl;
import com.meidusa.venus.registry.domain.MockConfig;
import com.meidusa.venus.registry.domain.RouterRule;
import com.meidusa.venus.registry.domain.VenusApplicationDO;
import com.meidusa.venus.registry.domain.VenusServerDO;
import com.meidusa.venus.registry.domain.VenusServiceConfigDO;
import com.meidusa.venus.registry.domain.VenusServiceDO;
import com.meidusa.venus.registry.domain.VenusServiceMappingDO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ResultUtils {
    public static final VenusServerDO resultToVenusServerDO(ResultSet rs) throws SQLException {
        VenusServerDO venusServer = new VenusServerDO();
        venusServer.setId(Integer.valueOf(rs.getInt("id")));
        venusServer.setHostname(rs.getString("hostname"));
        venusServer.setPort(Integer.valueOf(rs.getInt("port")));
        venusServer.setCreateTime((Date)rs.getTimestamp("create_time"));
        venusServer.setUpdateTime((Date)rs.getTimestamp("update_time"));
        return venusServer;
    }

    public static final VenusServiceConfigDO resultToVenusServiceConfigDO(ResultSet rs) throws SQLException {
        VenusServiceConfigDO serviceConfig = new VenusServiceConfigDO();
        serviceConfig.setId(Integer.valueOf(rs.getInt("id")));
        serviceConfig.setType(rs.getInt("type"));
        serviceConfig.setConfig(rs.getString("config"));
        serviceConfig.setServiceId(Integer.valueOf(rs.getInt("service_id")));
        serviceConfig.setCreateName(rs.getString("create_name"));
        serviceConfig.setUpdateName(rs.getString("update_name"));
        serviceConfig.setCreateTime((Date)rs.getTimestamp("create_time"));
        serviceConfig.setUpdateTime((Date)rs.getTimestamp("update_time"));
        return serviceConfig;
    }

    public static final VenusServiceDO resultToVenusServiceDO(ResultSet rs) throws SQLException {
        VenusServiceDO venusService = new VenusServiceDO();
        venusService.setId(Integer.valueOf(rs.getInt("id")));
        venusService.setName(rs.getString("name"));
        venusService.setInterfaceName(rs.getString("interface_name"));
        venusService.setVersion(rs.getString("version"));
        venusService.setVersionRange(rs.getString("version_range"));
        venusService.setDescription(rs.getString("description"));
        venusService.setAppId(Integer.valueOf(rs.getInt("app_id")));
        venusService.setRegisteType(Integer.valueOf(rs.getInt("registe_type")));
        venusService.setMethods(rs.getString("methods"));
        venusService.setEndpoints(rs.getString("endpoints"));
        venusService.setDelete(rs.getBoolean("is_delete"));
        venusService.setCreateTime((Date)rs.getTimestamp("create_time"));
        venusService.setUpdateTime((Date)rs.getTimestamp("update_time"));
        return venusService;
    }

    public static final VenusServiceMappingDO resultToVenusServiceMappingDO(ResultSet rs) throws SQLException {
        VenusServiceMappingDO venusServiceMapping = new VenusServiceMappingDO();
        venusServiceMapping.setId(Integer.valueOf(rs.getInt("id")));
        venusServiceMapping.setVersion(rs.getString("version"));
        venusServiceMapping.setActive(rs.getBoolean("active"));
        venusServiceMapping.setSync(rs.getBoolean("sync"));
        venusServiceMapping.setServerId(Integer.valueOf(rs.getInt("server_id")));
        venusServiceMapping.setServiceId(Integer.valueOf(rs.getInt("service_id")));
        venusServiceMapping.setProviderAppId(Integer.valueOf(rs.getInt("provider_app_id")));
        venusServiceMapping.setConsumerAppId(Integer.valueOf(rs.getInt("consumer_app_id")));
        venusServiceMapping.setIsDelete(Boolean.valueOf(rs.getBoolean("is_delete")));
        venusServiceMapping.setCreateTime((Date)rs.getTimestamp("create_time"));
        venusServiceMapping.setUpdateTime((Date)rs.getTimestamp("update_time"));
        venusServiceMapping.setRegisteTime((Date)rs.getTimestamp("registe_time"));
        venusServiceMapping.setHeartbeatTime((Date)rs.getTimestamp("heartbeat_time"));
        return venusServiceMapping;
    }

    public static final VenusApplicationDO resultToVenusApplicationDO(ResultSet rs) throws SQLException {
        VenusApplicationDO application = new VenusApplicationDO();
        application.setId(Integer.valueOf(rs.getInt("id")));
        application.setAppCode(rs.getString("app_code"));
        application.setProvider(Boolean.valueOf(rs.getBoolean("provider")));
        application.setConsumer(Boolean.valueOf(rs.getBoolean("consumer")));
        application.setCreateName(rs.getString("create_name"));
        application.setUpdateName(rs.getString("update_name"));
        application.setCreateTime((Date)rs.getTimestamp("create_time"));
        application.setUpdateTime((Date)rs.getTimestamp("update_time"));
        application.setNewApp(Boolean.valueOf(rs.getBoolean("new_app")));
        return application;
    }

    public static final void setServiceConfigs(List<VenusServiceConfigDO> serviceConfigs) {
        if (CollectionUtils.isNotEmpty(serviceConfigs)) {
            for (VenusServiceConfigDO serviceConfig : serviceConfigs) {
                int type = serviceConfig.getType();
                if (type == 1) {
                    RouterRule routerRule = (RouterRule)JSON.parseObject((String)serviceConfig.getConfig(), RouterRule.class);
                    serviceConfig.setRouterRule(routerRule);
                }
                if (type == 2) {
                    FlowControl flowControl = (FlowControl)JSON.parseObject((String)serviceConfig.getConfig(), FlowControl.class);
                    serviceConfig.setFlowControl(flowControl);
                }
                if (type != 3) continue;
                MockConfig mockConfig = (MockConfig)JSON.parseObject((String)serviceConfig.getConfig(), MockConfig.class);
                serviceConfig.setMockConfig(mockConfig);
            }
        }
    }

    public static final OldServiceMappingDO rsToOldServiceMappingDO(ResultSet rs) throws SQLException {
        OldServiceMappingDO oldServiceMapping = new OldServiceMappingDO();
        oldServiceMapping.setActive(rs.getBoolean("active"));
        oldServiceMapping.setCreateTime(rs.getTimestamp("create_time"));
        oldServiceMapping.setDescription(rs.getString("description"));
        oldServiceMapping.setHostName(rs.getString("host_name"));
        oldServiceMapping.setMapId(rs.getInt("map_id"));
        oldServiceMapping.setPort(rs.getInt("port"));
        oldServiceMapping.setServerId(rs.getInt("server_id"));
        oldServiceMapping.setServiceId(rs.getInt("service_id"));
        oldServiceMapping.setServiceName(rs.getString("service_name"));
        oldServiceMapping.setSync(rs.getBoolean("sync"));
        oldServiceMapping.setUpdateTime(rs.getTimestamp("update_time"));
        oldServiceMapping.setVersion(rs.getString("version"));
        return oldServiceMapping;
    }

    public static final ServiceMappingDTO rsTransServiceMappingDTO(ResultSet rs) throws SQLException {
        ServiceMappingDTO oldServiceMapping = new ServiceMappingDTO();
        oldServiceMapping.setMapId(rs.getInt("map_id"));
        oldServiceMapping.setVersionRange(rs.getString("version"));
        oldServiceMapping.setServerId(rs.getInt("server_id"));
        oldServiceMapping.setHostName(rs.getString("host_name"));
        oldServiceMapping.setPort(rs.getInt("port"));
        oldServiceMapping.setServiceId(rs.getInt("service_id"));
        oldServiceMapping.setServiceName(rs.getString("service_name"));
        return oldServiceMapping;
    }

    public static final OldServiceDO rsToOldServiceDO(ResultSet rs) throws SQLException {
        OldServiceDO oldService = new OldServiceDO();
        oldService.setId(rs.getInt("id"));
        oldService.setServiceName(rs.getString("service_name"));
        oldService.setDescription(rs.getString("description"));
        return oldService;
    }

    public static final OldServerDO rsToOldServerDO(ResultSet rs) throws SQLException {
        OldServerDO oldServer = new OldServerDO();
        oldServer.setId(rs.getInt("id"));
        oldServer.setHostName(rs.getString("hostname"));
        oldServer.setPort(rs.getInt("port"));
        return oldServer;
    }
}

