/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.registry.dao.impl;

import com.meidusa.toolkit.common.runtime.GlobalScheduler;
import com.meidusa.venus.registry.DAOException;
import com.meidusa.venus.registry.LogUtils;
import com.meidusa.venus.registry.dao.CacheVenusServiceMappingDAO;
import com.meidusa.venus.registry.dao.VenusServiceMappingDAO;
import com.meidusa.venus.registry.domain.VenusServiceMappingDO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;

public class CacheVenusServiceMappingDaoImpl
implements CacheVenusServiceMappingDAO {
    private VenusServiceMappingDAO venusServiceMappingDAO;
    private Map<Integer, List<VenusServiceMappingDO>> cacheServiceMappingMap = new HashMap<Integer, List<VenusServiceMappingDO>>();
    private static final int PAGE_SIZE_200 = 200;
    private volatile boolean loacCacheRunning = false;

    public VenusServiceMappingDAO getVenusServiceMappingDAO() {
        return this.venusServiceMappingDAO;
    }

    public void setVenusServiceMappingDAO(VenusServiceMappingDAO venusServiceMappingDAO) {
        this.venusServiceMappingDAO = venusServiceMappingDAO;
    }

    public void init() {
        GlobalScheduler.getInstance().scheduleAtFixedRate((Runnable)new LoadCacheServicesMappingRunnable(), 1L, 20L, TimeUnit.SECONDS);
    }

    public void load() {
        Integer totalCount;
        this.loacCacheRunning = true;
        if (this.loacCacheRunning) {
            this.cacheServiceMappingMap.clear();
        }
        if (null != (totalCount = Integer.valueOf(this.venusServiceMappingDAO.getMappingCount())) && totalCount > 0) {
            int mod = totalCount % 200;
            int count = totalCount / 200;
            if (mod > 0) {
                ++count;
            }
            int id = 0;
            for (int i = 0; i < count; ++i) {
                List<VenusServiceMappingDO> services = this.venusServiceMappingDAO.queryServiceMappings(200, id);
                if (!CollectionUtils.isNotEmpty(services)) continue;
                id = services.get(services.size() - 1).getId();
                for (VenusServiceMappingDO vs : services) {
                    this.putToMap(vs.getServiceId(), vs);
                }
            }
        }
        this.loacCacheRunning = false;
    }

    private void putToMap(Integer key, VenusServiceMappingDO vs) {
        List<VenusServiceMappingDO> list = this.cacheServiceMappingMap.get(key);
        if (null == list) {
            list = new ArrayList<VenusServiceMappingDO>();
            list.add(vs);
            this.cacheServiceMappingMap.put(key, list);
        } else if (!list.contains(vs)) {
            list.add(vs);
        }
    }

    @Override
    public List<VenusServiceMappingDO> queryServiceMappings(int serviceId) throws DAOException {
        if (this.loacCacheRunning) {
            return null;
        }
        if (serviceId > 0) {
            return this.cacheServiceMappingMap.get(serviceId);
        }
        return null;
    }

    private class LoadCacheServicesMappingRunnable
    implements Runnable {
        private LoadCacheServicesMappingRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long start = System.currentTimeMillis();
                CacheVenusServiceMappingDaoImpl.this.load();
                long end = System.currentTimeMillis();
                long consumerTime = end - start;
                LogUtils.logCacheSlow(consumerTime, "LoadCacheServicesMappingRunnable load() ");
                LogUtils.DEFAULT_LOG.info("LoadCacheServicesMappingRunnable start=>{}, end=>{},consumerTime=>{},cacheServiceMappingMap size=>{}", new Object[]{start, end, consumerTime, CacheVenusServiceMappingDaoImpl.this.cacheServiceMappingMap.size()});
            }
            catch (Exception e) {
                LogUtils.ERROR_LOG.error("load service mapping cache data error", (Throwable)e);
            }
            finally {
                CacheVenusServiceMappingDaoImpl.this.loacCacheRunning = false;
            }
        }
    }
}

