/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.registry.dao.impl;

import com.meidusa.toolkit.common.runtime.GlobalScheduler;
import com.meidusa.venus.URL;
import com.meidusa.venus.registry.DAOException;
import com.meidusa.venus.registry.LogUtils;
import com.meidusa.venus.registry.dao.CacheVenusServiceDAO;
import com.meidusa.venus.registry.dao.VenusServiceDAO;
import com.meidusa.venus.registry.domain.VenusServiceDO;
import com.meidusa.venus.registry.util.RegistryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CacheVenusServiceDaoImpl
implements CacheVenusServiceDAO {
    private VenusServiceDAO venusServiceDAO;
    private Map<String, List<VenusServiceDO>> cacheServiceMap = new HashMap<String, List<VenusServiceDO>>();
    private Map<String, List<VenusServiceDO>> nameServiceMap = new HashMap<String, List<VenusServiceDO>>();
    private List<VenusServiceDO> cacheServices = new ArrayList<VenusServiceDO>();
    private static final int PAGE_SIZE_200 = 200;
    private volatile boolean loacCacheRunning = false;

    public VenusServiceDAO getVenusServiceDAO() {
        return this.venusServiceDAO;
    }

    public void setVenusServiceDAO(VenusServiceDAO venusServiceDAO) {
        this.venusServiceDAO = venusServiceDAO;
    }

    public void init() {
        GlobalScheduler.getInstance().scheduleAtFixedRate((Runnable)new LoadCacheServicesRunnable(), 1L, 10L, TimeUnit.SECONDS);
    }

    public void load() {
        Integer totalCount;
        this.loacCacheRunning = true;
        if (this.loacCacheRunning) {
            this.cacheServices.clear();
            this.cacheServiceMap.clear();
            this.nameServiceMap.clear();
        }
        if (null != (totalCount = this.venusServiceDAO.getServiceCount()) && totalCount > 0) {
            int mod = totalCount % 200;
            int count = totalCount / 200;
            if (mod > 0) {
                ++count;
            }
            int mapId = 0;
            for (int i = 0; i < count; ++i) {
                List<VenusServiceDO> services = this.venusServiceDAO.queryServices(200, mapId);
                if (!CollectionUtils.isNotEmpty(services)) continue;
                mapId = services.get(services.size() - 1).getId();
                for (VenusServiceDO vs : services) {
                    if (RegistryUtil.isNotBlank((String)vs.getInterfaceName())) {
                        String interfaceNamekey = RegistryUtil.getCacheKey((String)vs.getInterfaceName(), (String)vs.getVersion());
                        this.putToMap(interfaceNamekey, vs);
                        this.putToNameMap(vs.getName(), vs);
                    }
                    if (RegistryUtil.isNotBlank((String)vs.getName())) {
                        String namekey = RegistryUtil.getCacheKey((String)vs.getName(), (String)vs.getVersion());
                        this.putToMap(namekey, vs);
                        this.putToNameMap(vs.getName(), vs);
                    }
                    String key = RegistryUtil.getCacheKey((VenusServiceDO)vs);
                    this.putToMap(key, vs);
                }
            }
        }
        this.loacCacheRunning = false;
    }

    private void putToMap(String key, VenusServiceDO vs) {
        List<VenusServiceDO> list = this.cacheServiceMap.get(key);
        if (null == list) {
            list = new ArrayList<VenusServiceDO>();
            list.add(vs);
            this.cacheServiceMap.put(key, list);
        } else if (!list.contains(vs)) {
            list.add(vs);
        }
    }

    private void putToNameMap(String key, VenusServiceDO vs) {
        List<VenusServiceDO> list = this.nameServiceMap.get(key);
        if (null == list) {
            list = new ArrayList<VenusServiceDO>();
            list.add(vs);
            this.nameServiceMap.put(key, list);
        } else if (!list.contains(vs)) {
            list.add(vs);
        }
    }

    @Override
    public List<VenusServiceDO> queryServices(String interfaceName, String serviceName, String version, String role) throws DAOException {
        if (StringUtils.isBlank((String)interfaceName) && StringUtils.isBlank((String)serviceName)) {
            throw new DAOException("serviceName\u4e0einterfaceName\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (this.loacCacheRunning) {
            return new ArrayList<VenusServiceDO>();
        }
        if (role.equals("consumer")) {
            List<VenusServiceDO> list2;
            List<VenusServiceDO> list;
            ArrayList<VenusServiceDO> returnList = new ArrayList<VenusServiceDO>();
            if (RegistryUtil.isNotBlank((String)serviceName) && CollectionUtils.isNotEmpty(list = this.nameServiceMap.get(serviceName))) {
                returnList.addAll(list);
            }
            if (RegistryUtil.isNotBlank((String)interfaceName) && CollectionUtils.isNotEmpty(list2 = this.nameServiceMap.get(interfaceName))) {
                returnList.addAll(list2);
            }
            return returnList;
        }
        if (RegistryUtil.isNotBlank((String)serviceName) && RegistryUtil.isNotBlank((String)interfaceName)) {
            String key1 = RegistryUtil.getCacheKey((String)interfaceName, (String)version);
            String key2 = RegistryUtil.getCacheKey((String)serviceName, (String)version);
            List<VenusServiceDO> list = this.cacheServiceMap.get(key1);
            List<VenusServiceDO> list2 = this.cacheServiceMap.get(key2);
            ArrayList<VenusServiceDO> returnList = new ArrayList<VenusServiceDO>();
            if (CollectionUtils.isNotEmpty(list)) {
                returnList.addAll(list);
            }
            if (CollectionUtils.isNotEmpty(list2)) {
                returnList.addAll(list2);
            }
            return returnList;
        }
        String key = RegistryUtil.getCacheKey((String)interfaceName, (String)serviceName, (String)version);
        return this.cacheServiceMap.get(key);
    }

    @Override
    public List<VenusServiceDO> queryServices(URL url) throws DAOException {
        if (this.loacCacheRunning) {
            return null;
        }
        String serviceName = url.getServiceName();
        if (RegistryUtil.isNotBlank((String)serviceName)) {
            String version = url.getVersion();
            if (RegistryUtil.isNotBlank((String)version)) {
                return this.cacheServiceMap.get(RegistryUtil.getCacheKey((String)serviceName, (String)version));
            }
            return this.nameServiceMap.get(serviceName);
        }
        return null;
    }

    @Override
    public List<String> queryAllServiceNames() throws DAOException {
        if (this.loacCacheRunning) {
            return new ArrayList<String>();
        }
        ArrayList<String> returnList = new ArrayList<String>();
        for (VenusServiceDO vs : this.cacheServices) {
            String name = vs.getName();
            if (!RegistryUtil.isNotBlank((String)name) || returnList.contains(name)) continue;
            returnList.add(name);
        }
        return returnList;
    }

    private class LoadCacheServicesRunnable
    implements Runnable {
        private LoadCacheServicesRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long start = System.currentTimeMillis();
                CacheVenusServiceDaoImpl.this.load();
                long end = System.currentTimeMillis();
                long consumerTime = end - start;
                LogUtils.logCacheSlow(consumerTime, "LoadCacheServicesRunnable load() ");
                LogUtils.DEFAULT_LOG.info("LoadCacheServicesRunnable start=>{}, end=>{},consumerTime=>{},cacheServices size=>{},cacheServiceMap size=>{}", new Object[]{start, end, consumerTime, CacheVenusServiceDaoImpl.this.cacheServices.size(), CacheVenusServiceDaoImpl.this.cacheServiceMap.size()});
            }
            catch (Exception e) {
                LogUtils.ERROR_LOG.error("load service cache data error", (Throwable)e);
            }
            finally {
                CacheVenusServiceDaoImpl.this.loacCacheRunning = false;
            }
        }
    }
}

