/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.registry.dao.impl;

import com.meidusa.toolkit.common.runtime.GlobalScheduler;
import com.meidusa.venus.registry.DAOException;
import com.meidusa.venus.registry.LogUtils;
import com.meidusa.venus.registry.dao.CacheServiceConfigDAO;
import com.meidusa.venus.registry.dao.VenusServiceConfigDAO;
import com.meidusa.venus.registry.domain.VenusServiceConfigDO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;

public class CacheVenusServiceConfigDaoImpl
implements CacheServiceConfigDAO {
    private static final int PAGE_SIZE_200 = 200;
    private VenusServiceConfigDAO venusServiceConfigDAO;
    private Map<Integer, List<VenusServiceConfigDO>> cacheVenusServiceConfigMap = new HashMap<Integer, List<VenusServiceConfigDO>>();
    private AtomicInteger cacheTotalCount = new AtomicInteger(0);
    private volatile boolean loacCacheRunning = false;

    public VenusServiceConfigDAO getVenusServiceConfigDAO() {
        return this.venusServiceConfigDAO;
    }

    public void setVenusServiceConfigDAO(VenusServiceConfigDAO venusServiceConfigDAO) {
        this.venusServiceConfigDAO = venusServiceConfigDAO;
    }

    public void init() {
        GlobalScheduler.getInstance().scheduleAtFixedRate((Runnable)new LoadCacheVenusServiceConfigRunnable(), 1L, 5L, TimeUnit.SECONDS);
    }

    @Override
    public List<VenusServiceConfigDO> getVenusServiceConfig(Integer serviceId) throws DAOException {
        if (this.loacCacheRunning) {
            return null;
        }
        return this.cacheVenusServiceConfigMap.get(serviceId);
    }

    void load() {
        this.loacCacheRunning = true;
        if (this.loacCacheRunning) {
            this.cacheVenusServiceConfigMap.clear();
        }
        Integer totalCount = this.venusServiceConfigDAO.getServiceConfigCount();
        this.cacheTotalCount.set(totalCount);
        if (null != totalCount && totalCount > 0) {
            int mod = totalCount % 200;
            int count = totalCount / 200;
            if (mod > 0) {
                ++count;
            }
            int id = 0;
            for (int i = 0; i < count; ++i) {
                List<VenusServiceConfigDO> queryVenusServiceConfigs = this.venusServiceConfigDAO.queryServiceConfigs(200, id);
                if (!CollectionUtils.isNotEmpty(queryVenusServiceConfigs)) continue;
                id = queryVenusServiceConfigs.get(queryVenusServiceConfigs.size() - 1).getId();
                for (VenusServiceConfigDO serviceConfigDO : queryVenusServiceConfigs) {
                    this.putToMap(serviceConfigDO.getServiceId(), serviceConfigDO);
                }
            }
        }
        this.loacCacheRunning = false;
    }

    private void putToMap(Integer key, VenusServiceConfigDO vs) {
        List<VenusServiceConfigDO> list = this.cacheVenusServiceConfigMap.get(key);
        if (null == list) {
            list = new ArrayList<VenusServiceConfigDO>();
            list.add(vs);
            this.cacheVenusServiceConfigMap.put(key, list);
        } else if (!list.contains(vs)) {
            list.add(vs);
        }
    }

    @Override
    public boolean isLoacCacheRunning() {
        return this.loacCacheRunning;
    }

    @Override
    public int getVenusServiceConfigCount() throws DAOException {
        return this.cacheTotalCount.get();
    }

    private class LoadCacheVenusServiceConfigRunnable
    implements Runnable {
        private LoadCacheVenusServiceConfigRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long start = System.currentTimeMillis();
                CacheVenusServiceConfigDaoImpl.this.load();
                long consumerTime = System.currentTimeMillis() - start;
                LogUtils.logCacheSlow(consumerTime, "LoadCacheVenusServiceConfigRunnable load() ");
                LogUtils.DEFAULT_LOG.info("LoadCacheVenusServiceConfigRunnable start=>{}, end=>{},consumerTime=>{},cacheVenusServiceConfigMap size=>{}", new Object[]{start, System.currentTimeMillis(), consumerTime, CacheVenusServiceConfigDaoImpl.this.cacheVenusServiceConfigMap.size()});
            }
            catch (Throwable e) {
                LogUtils.ERROR_LOG.error("load serviceConfigs cache data error", e);
            }
            finally {
                CacheVenusServiceConfigDaoImpl.this.loacCacheRunning = false;
            }
        }
    }
}

