/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.registry.dao.impl;

import com.meidusa.toolkit.common.runtime.GlobalScheduler;
import com.meidusa.venus.registry.DAOException;
import com.meidusa.venus.registry.LogUtils;
import com.meidusa.venus.registry.dao.CacheVenusServerDAO;
import com.meidusa.venus.registry.dao.VenusServerDAO;
import com.meidusa.venus.registry.domain.VenusServerDO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;

public class CacheVenusServerDaoImpl
implements CacheVenusServerDAO {
    private static final int PAGE_SIZE_200 = 200;
    private VenusServerDAO venusServerDAO;
    private List<VenusServerDO> cacheServers = new ArrayList<VenusServerDO>();
    private Map<String, VenusServerDO> cacheServerMap = new HashMap<String, VenusServerDO>();
    private Map<Integer, VenusServerDO> cacheIdServerMap = new HashMap<Integer, VenusServerDO>();
    private volatile boolean loacCacheRunning = false;

    public VenusServerDAO getVenusServerDAO() {
        return this.venusServerDAO;
    }

    public void setVenusServerDAO(VenusServerDAO venusServerDAO) {
        this.venusServerDAO = venusServerDAO;
    }

    public void init() {
        GlobalScheduler.getInstance().scheduleAtFixedRate((Runnable)new LoadCacheServersRunnable(), 1L, 2L, TimeUnit.SECONDS);
    }

    @Override
    public VenusServerDO getServer(String host, int port) throws DAOException {
        if (this.loacCacheRunning) {
            return null;
        }
        return this.cacheServerMap.get(this.getKey(host, port));
    }

    private VenusServerDO getOneServer(String host, int port) {
        for (VenusServerDO server : this.cacheServers) {
            if (!server.getHostname().equals(host) || server.getPort() != port) continue;
            return server;
        }
        return null;
    }

    private String getKey(String host, int port) {
        return host + ":" + port;
    }

    void load() {
        Integer totalCount;
        this.loacCacheRunning = true;
        if (this.loacCacheRunning) {
            this.cacheServerMap.clear();
            this.cacheIdServerMap.clear();
        }
        if (null != (totalCount = this.venusServerDAO.getServerCount()) && totalCount > 0) {
            int mod = totalCount % 200;
            int count = totalCount / 200;
            if (mod > 0) {
                ++count;
            }
            int id = 0;
            for (int i = 0; i < count; ++i) {
                List<VenusServerDO> queryServers = this.venusServerDAO.queryServers(200, id);
                if (!CollectionUtils.isNotEmpty(queryServers)) continue;
                id = queryServers.get(queryServers.size() - 1).getId();
                for (VenusServerDO serverDO : queryServers) {
                    String key = this.getKey(serverDO.getHostname(), serverDO.getPort());
                    this.cacheServerMap.put(key, serverDO);
                    this.cacheIdServerMap.put(serverDO.getId(), serverDO);
                }
            }
        }
        this.loacCacheRunning = false;
    }

    private boolean contains(VenusServerDO serverDO) {
        if (CollectionUtils.isNotEmpty(this.cacheServers)) {
            Iterator<VenusServerDO> iterator = this.cacheServers.iterator();
            while (iterator.hasNext()) {
                VenusServerDO ser = iterator.next();
                if (!ser.getHostname().equals(serverDO.getHostname()) || null == serverDO.getPort() || serverDO.getPort().intValue() != ser.getPort().intValue()) continue;
                if (ser.getId() == serverDO.getId()) {
                    return true;
                }
                iterator.remove();
            }
        }
        return false;
    }

    @Override
    public List<VenusServerDO> getServers(List<Integer> ids) throws DAOException {
        if (this.loacCacheRunning) {
            return null;
        }
        ArrayList<VenusServerDO> returnList = new ArrayList<VenusServerDO>();
        for (Integer id : ids) {
            VenusServerDO venusServerDO = this.cacheIdServerMap.get(id);
            if (null == venusServerDO) continue;
            returnList.add(venusServerDO);
        }
        return returnList;
    }

    private class LoadCacheServersRunnable
    implements Runnable {
        private LoadCacheServersRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long start = System.currentTimeMillis();
                CacheVenusServerDaoImpl.this.load();
                long consumerTime = System.currentTimeMillis() - start;
                LogUtils.logCacheSlow(consumerTime, "LoadCacheServersRunnable load() ");
                LogUtils.DEFAULT_LOG.info("LoadCacheServersRunnable start=>{}, end=>{},consumerTime=>{},cacheServers size=>{}", new Object[]{start, System.currentTimeMillis(), consumerTime, CacheVenusServerDaoImpl.this.cacheServers.size()});
            }
            catch (Exception e) {
                LogUtils.ERROR_LOG.error("load server cache data error", (Throwable)e);
            }
            finally {
                CacheVenusServerDaoImpl.this.loacCacheRunning = false;
            }
        }
    }
}

