/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.registry.dao.impl;

import com.meidusa.toolkit.common.runtime.GlobalScheduler;
import com.meidusa.venus.registry.DAOException;
import com.meidusa.venus.registry.LogUtils;
import com.meidusa.venus.registry.dao.CacheApplicationDAO;
import com.meidusa.venus.registry.dao.VenusApplicationDAO;
import com.meidusa.venus.registry.domain.VenusApplicationDO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;

public class CacheVenusApplicationDaoImpl
implements CacheApplicationDAO {
    private static final int PAGE_SIZE_200 = 200;
    private VenusApplicationDAO venusApplicationDAO;
    private Map<Integer, VenusApplicationDO> cacheIdApplicationMap = new HashMap<Integer, VenusApplicationDO>();
    private Map<String, VenusApplicationDO> cacheCodeApplicationMap = new HashMap<String, VenusApplicationDO>();
    private volatile boolean loacCacheRunning = false;

    public VenusApplicationDAO getVenusApplicationDAO() {
        return this.venusApplicationDAO;
    }

    public void setVenusApplicationDAO(VenusApplicationDAO venusApplicationDAO) {
        this.venusApplicationDAO = venusApplicationDAO;
    }

    public void init() {
        GlobalScheduler.getInstance().scheduleAtFixedRate((Runnable)new LoadCacheApplicationsRunnable(), 1L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public VenusApplicationDO getApplication(Integer id) throws DAOException {
        if (this.loacCacheRunning) {
            return null;
        }
        return this.cacheIdApplicationMap.get(id);
    }

    @Override
    public VenusApplicationDO getApplication(String appCode) throws DAOException {
        if (this.loacCacheRunning) {
            return null;
        }
        return this.cacheCodeApplicationMap.get(appCode);
    }

    void load() {
        Integer totalCount;
        this.loacCacheRunning = true;
        if (this.loacCacheRunning) {
            this.cacheCodeApplicationMap.clear();
            this.cacheIdApplicationMap.clear();
        }
        if (null != (totalCount = Integer.valueOf(this.venusApplicationDAO.getApplicationCount())) && totalCount > 0) {
            int mod = totalCount % 200;
            int count = totalCount / 200;
            if (mod > 0) {
                ++count;
            }
            int id = 0;
            for (int i = 0; i < count; ++i) {
                List<VenusApplicationDO> queryApplications = this.venusApplicationDAO.queryApplications(200, id);
                if (!CollectionUtils.isNotEmpty(queryApplications)) continue;
                id = queryApplications.get(queryApplications.size() - 1).getId();
                for (VenusApplicationDO applicationDO : queryApplications) {
                    this.cacheIdApplicationMap.put(applicationDO.getId(), applicationDO);
                    this.cacheCodeApplicationMap.put(applicationDO.getAppCode(), applicationDO);
                }
            }
        }
        this.loacCacheRunning = false;
    }

    private class LoadCacheApplicationsRunnable
    implements Runnable {
        private LoadCacheApplicationsRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long start = System.currentTimeMillis();
                CacheVenusApplicationDaoImpl.this.load();
                long consumerTime = System.currentTimeMillis() - start;
                LogUtils.logCacheSlow(consumerTime, "LoadCacheApplicationsRunnable load() ");
                LogUtils.DEFAULT_LOG.info("LoadCacheApplicationsRunnable start=>{}, end=>{},consumerTime=>{},cacheCodeApplicationMap size=>{}", new Object[]{start, System.currentTimeMillis(), consumerTime, CacheVenusApplicationDaoImpl.this.cacheCodeApplicationMap.size()});
            }
            catch (Throwable e) {
                LogUtils.ERROR_LOG.error("load application cache data error", e);
            }
            finally {
                CacheVenusApplicationDaoImpl.this.loacCacheRunning = false;
            }
        }
    }
}

