/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.monitor.athena.reporter.impl;

import com.meidusa.venus.monitor.athena.AthenaTransactionId;
import com.meidusa.venus.monitor.athena.reporter.ClientTransactionReporter;
import com.meidusa.venus.monitor.athena.reporter.impl.AbstractTransactionReporter;
import com.meidusa.venus.monitor.athena.support.TransactionThreadLocal;
import com.saic.framework.athena.configuration.client.entity.RemoteContext;
import com.saic.framework.athena.configuration.client.entity.impl.RemoteContextInstance;
import com.saic.framework.athena.message.Transaction;
import com.saic.framework.athena.site.helper.AthenaUtils;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientTransactionReporter
extends AbstractTransactionReporter
implements ClientTransactionReporter {
    private static Logger logger = LoggerFactory.getLogger(DefaultClientTransactionReporter.class);

    @Override
    public AthenaTransactionId startTransaction(String itemName) {
        AthenaTransactionId transactionId = new AthenaTransactionId();
        try {
            RemoteContextInstance context = new RemoteContextInstance();
            AthenaUtils.getInstance().logRemoteCallClient((RemoteContext)context);
            transactionId.setRootId(context.getProperty("_athenaRootMessageId"));
            transactionId.setParentId(context.getProperty("_athenaParentMessageId"));
            transactionId.setMessageId(context.getProperty("_athenaChildMessageId"));
            Stack transactionStack = (Stack)TransactionThreadLocal.getInstance().get();
            Transaction transaction = AthenaUtils.getInstance().newTransaction("rpc_client", itemName);
            if (transaction != null) {
                transactionStack.add(transaction);
            }
        }
        catch (Exception e) {
            logger.error("client startTransaction error.", (Throwable)e);
            return null;
        }
        return transactionId;
    }

    @Override
    public AthenaTransactionId newTransaction() {
        AthenaTransactionId transactionId = new AthenaTransactionId();
        RemoteContextInstance context = new RemoteContextInstance();
        AthenaUtils.getInstance().logRemoteCallClient((RemoteContext)context);
        transactionId.setRootId(context.getProperty("_athenaRootMessageId"));
        transactionId.setParentId(context.getProperty("_athenaParentMessageId"));
        transactionId.setMessageId(context.getProperty("_athenaChildMessageId"));
        return transactionId;
    }
}

