/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.monitor.athena.filter;

import com.meidusa.venus.ClientInvocationOperation;
import com.meidusa.venus.Filter;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Result;
import com.meidusa.venus.URL;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.monitor.athena.AthenaTransactionId;
import com.meidusa.venus.monitor.athena.reporter.ClientTransactionReporter;
import com.meidusa.venus.monitor.athena.reporter.impl.DefaultClientTransactionReporter;
import com.meidusa.venus.support.EndpointWrapper;
import com.meidusa.venus.support.ServiceWrapper;
import com.meidusa.venus.support.VenusThreadContext;
import com.meidusa.venus.support.VenusUtil;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.lang.reflect.Method;
import org.slf4j.Logger;

public class ClientAthenaMonitorFilter
implements Filter {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private ClientTransactionReporter clientTransactionReporter = null;

    public void init() throws RpcException {
        this.clientTransactionReporter = new DefaultClientTransactionReporter();
    }

    public Result beforeInvoke(Invocation invocation, URL url) throws RpcException {
        try {
            ClientInvocationOperation clientInvocation = (ClientInvocationOperation)invocation;
            ServiceWrapper service = clientInvocation.getService();
            if (service == null || !service.isAthenaFlag()) {
                return null;
            }
            EndpointWrapper endpoint = clientInvocation.getEndpoint();
            Method method = clientInvocation.getMethod();
            String apiName = VenusUtil.getApiName((Method)method, (ServiceWrapper)service, (EndpointWrapper)endpoint);
            AthenaTransactionId athenaTransactionId = this.clientTransactionReporter.startTransaction(apiName);
            VenusThreadContext.set((String)"athenaTransactionId", (Object)athenaTransactionId);
            if (athenaTransactionId != null) {
                if (athenaTransactionId.getRootId() != null) {
                    byte[] athenaId = athenaTransactionId.getRootId().getBytes();
                    clientInvocation.setAthenaId(athenaId);
                }
                if (athenaTransactionId.getParentId() != null) {
                    byte[] parentId = athenaTransactionId.getParentId().getBytes();
                    clientInvocation.setParentId(parentId);
                }
                if (athenaTransactionId.getMessageId() != null) {
                    byte[] messageId = athenaTransactionId.getMessageId().getBytes();
                    clientInvocation.setMessageId(messageId);
                }
            }
            return null;
        }
        catch (Throwable e) {
            if (exceptionLogger.isErrorEnabled()) {
                exceptionLogger.error("ClientAthenaMonitorFilter.beforeInvoke error.", e);
            }
            return null;
        }
    }

    public Result throwInvoke(Invocation invocation, URL url, Throwable e) throws RpcException {
        return null;
    }

    public Result afterInvoke(Invocation invocation, URL url) throws RpcException {
        try {
            Integer clientInputSize;
            ClientInvocationOperation clientInvocation = (ClientInvocationOperation)invocation;
            ServiceWrapper service = clientInvocation.getService();
            if (service == null || !service.isAthenaFlag()) {
                return null;
            }
            Integer clientOutputSize = (Integer)VenusThreadContext.get((String)"clientOutputSize");
            if (clientOutputSize != null) {
                this.clientTransactionReporter.setOutputSize(clientOutputSize.intValue());
            }
            if ((clientInputSize = (Integer)VenusThreadContext.get((String)"clientInputSize")) != null) {
                this.clientTransactionReporter.setInputSize(clientInputSize.intValue());
            }
            this.clientTransactionReporter.commit();
            return null;
        }
        catch (Throwable e) {
            if (exceptionLogger.isErrorEnabled()) {
                exceptionLogger.error("ClientAthenaMonitorFilter.afterInvoke error.", e);
            }
            return null;
        }
    }

    public void destroy() throws RpcException {
    }
}

