/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.frontend.http;

import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.packet.ServiceResponsePacket;
import com.meidusa.venus.io.utils.GZipUtil;
import java.io.UnsupportedEncodingException;

public class JsonVenusResponsePacket
extends ServiceResponsePacket {
    private static final long serialVersionUID = 1L;
    public byte[] traceId;

    public JsonVenusResponsePacket() {
        this.type = 0x2000002;
    }

    protected void readBody(ServicePacketBuffer buffer) {
        super.readBody(buffer);
        if (buffer.hasRemaining()) {
            byte f = (byte)(this.flags & 0x10);
            if (f == 16) {
                byte[] bts = buffer.readLengthCodedBytes();
                if (bts != null & bts.length > 0) {
                    bts = GZipUtil.decompress((byte[])bts);
                    this.result = new String(bts, PACKET_CHARSET);
                }
            } else {
                this.result = buffer.readLengthCodedString(PACKET_CHARSET);
            }
        }
        if (buffer.hasRemaining()) {
            this.traceId = new byte[16];
            buffer.readBytes(this.traceId);
        }
    }

    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
        super.writeBody(buffer);
        if (this.result != null) {
            byte[] bts = this.result.toString().getBytes(PACKET_CHARSET);
            if (bts != null) {
                if (PacketConstant.AUTO_COMPRESS_SIZE > 0 && bts.length > PacketConstant.AUTO_COMPRESS_SIZE) {
                    buffer.writeLengthCodedBytes(GZipUtil.compress((byte[])bts));
                    this.flags = (byte)(this.flags | 0x10);
                } else {
                    buffer.writeLengthCodedBytes(bts);
                }
            } else {
                buffer.writeInt(0);
            }
        } else {
            buffer.writeInt(0);
        }
        if (this.traceId == null) {
            this.traceId = EMPTY_TRACE_ID;
        }
        buffer.writeBytes(this.traceId);
    }
}

