/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.frontend.http;

import com.meidusa.venus.io.packet.AbstractServiceRequestPacket;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.utils.GZipUtil;
import java.io.UnsupportedEncodingException;

public class JsonVenusRequestPacket
extends AbstractServiceRequestPacket {
    private static final long serialVersionUID = 1L;
    public String params;
    public byte[] traceId;

    public JsonVenusRequestPacket() {
        this.type = 0x2000001;
    }

    protected void readBody(ServicePacketBuffer buffer) {
        super.readBody(buffer);
        if (buffer.hasRemaining()) {
            byte f = (byte)(this.flags & 0x10);
            if (f == 16) {
                byte[] bts = buffer.readLengthCodedBytes();
                if (bts != null & bts.length > 0) {
                    bts = GZipUtil.decompress((byte[])bts);
                    this.params = new String(bts, PACKET_CHARSET);
                }
            } else {
                this.params = buffer.readLengthCodedString(PACKET_CHARSET);
            }
        }
        if (buffer.hasRemaining()) {
            this.traceId = new byte[16];
            buffer.readBytes(this.traceId);
        }
    }

    protected void writeBody(ServicePacketBuffer buffer) throws UnsupportedEncodingException {
        super.writeBody(buffer);
        if (this.params != null) {
            byte[] bts = this.params.getBytes(PACKET_CHARSET);
            if (bts != null) {
                if (PacketConstant.AUTO_COMPRESS_SIZE > 0 && bts.length > PacketConstant.AUTO_COMPRESS_SIZE) {
                    buffer.writeLengthCodedBytes(GZipUtil.compress((byte[])bts));
                    this.flags = (byte)(this.flags | 0x10);
                } else {
                    buffer.writeLengthCodedBytes(bts);
                }
            } else {
                buffer.writeInt(0);
            }
        } else {
            buffer.writeInt(0);
        }
        if (this.traceId == null) {
            this.traceId = EMPTY_TRACE_ID;
        }
        buffer.writeBytes(this.traceId);
    }
}

