/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.frontend.http;

import com.meidusa.fastjson.JSON;
import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.JSONObject;
import com.meidusa.fastmark.feature.SerializerFeature;
import com.meidusa.toolkit.common.poolable.InvalidVirtualPoolException;
import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.toolkit.util.StringUtil;
import com.meidusa.toolkit.util.TimeUtil;
import com.meidusa.venus.annotations.RemoteException;
import com.meidusa.venus.annotations.util.AnnotationUtil;
import com.meidusa.venus.backend.RequestInfo;
import com.meidusa.venus.backend.Response;
import com.meidusa.venus.backend.profiling.UtilTimerStack;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.ExceptionLevel;
import com.meidusa.venus.exception.VenusExceptionLevel;
import com.meidusa.venus.frontend.http.JsonVenusNotifyPacket;
import com.meidusa.venus.frontend.http.JsonVenusRequestPacket;
import com.meidusa.venus.frontend.http.JsonVenusResponsePacket;
import com.meidusa.venus.io.network.VenusBIOConnection;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.DummyAuthenPacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.HandshakePacket;
import com.meidusa.venus.io.packet.OKPacket;
import com.meidusa.venus.io.packet.PacketConstant;
import com.meidusa.venus.io.packet.VenusStatusRequestPacket;
import com.meidusa.venus.io.packet.VenusStatusResponsePacket;
import com.meidusa.venus.service.monitor.MonitorRuntime;
import com.meidusa.venus.util.UUID;
import com.meidusa.venus.util.VenusTracerUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VenusHttpServlet2
extends HttpServlet {
    private static SerializerFeature[] JSON_FEATURE = new SerializerFeature[]{SerializerFeature.ShortString};
    private static final String _VENUS_TRACE_ID = "_venus_trace_id_";
    private static final String _VENUS_CLIENT_ID = "_venus_client_id_";
    private static final String VERSION = "v";
    private static final String VERSION_HEADER = "version";
    private static Logger logger = LoggerFactory.getLogger(VenusHttpServlet2.class);
    private static String ENDPOINT_INVOKED_TIME = "invoked Total Time: ";
    private Pattern servicePattern = null;
    private String urlPattern;
    private static final long serialVersionUID = 1L;
    private Tuple<String, Integer>[] runtimeTuples = null;
    private Tuple<String, Integer>[] sourceIpAddressTuples = null;
    private volatile long currentIndex = 0L;
    private String ipAddressList = null;
    Timer timer = new Timer("Check remote Connection");

    public void init(ServletConfig config) throws ServletException {
        String[] ipList;
        super.init(config);
        String servletName = config.getServletName();
        this.urlPattern = config.getInitParameter("uri-pattern");
        if (StringUtils.isEmpty((String)this.urlPattern)) {
            throw new ServletException("servlet=" + servletName + "  init-param=uri-prefix cannot be null");
        }
        this.urlPattern = this.urlPattern.trim();
        this.servicePattern = Pattern.compile(this.urlPattern);
        this.ipAddressList = config.getInitParameter("remoteIpAddressList");
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        for (String s : ipList = StringUtil.split((String)this.ipAddressList, (String)", ")) {
            String[] tmp = StringUtil.split((String)s, (String)":");
            Tuple tuple = new Tuple();
            tuple.left = tmp[0];
            tuple.right = tmp.length >= 2 ? Integer.valueOf(tmp[1]) : Integer.valueOf(16800);
            list.add(tuple);
        }
        this.sourceIpAddressTuples = list.toArray(new Tuple[list.size()]);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                VenusHttpServlet2.this.checkAll();
            }
        }, 3000L, 5000L);
    }

    private void checkAll() {
        ArrayList<Tuple<String, Integer>> list = new ArrayList<Tuple<String, Integer>>();
        for (Tuple<String, Integer> tuple : this.sourceIpAddressTuples) {
            try {
                if (!this.checkRemoteVenus((String)tuple.left, (Integer)tuple.right)) continue;
                list.add(tuple);
            }
            catch (Exception e) {
                logger.error("check remote error", (Throwable)e);
            }
        }
        this.runtimeTuples = list.toArray(new Tuple[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkRemoteVenus(String ip, int port) throws Exception {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(ip, port));
        try {
            VenusBIOConnection conn = new VenusBIOConnection(socket, System.currentTimeMillis());
            byte[] tmp = conn.read();
            HandshakePacket packet = new HandshakePacket();
            packet.init(tmp);
            DummyAuthenPacket dummy = new DummyAuthenPacket();
            socket.getOutputStream().write(dummy.toByteArray());
            tmp = conn.read();
            OKPacket ok = new OKPacket();
            ok.init(tmp);
            conn.write(new VenusStatusRequestPacket().toByteArray());
            tmp = conn.read();
            VenusStatusResponsePacket res = new VenusStatusResponsePacket();
            res.init(tmp);
            if (res.status == 1) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            socket.close();
        }
        return false;
    }

    private VenusBIOConnection getConnectionPolling() throws Exception {
        int i = 0;
        while (true) {
            try {
                if (this.runtimeTuples.length == 0) {
                    throw new InvalidVirtualPoolException(this.ipAddressList + " invalid");
                }
                Tuple<String, Integer>[] current = this.runtimeTuples;
                Tuple<String, Integer> tuple = current[(int)(this.currentIndex++ % (long)current.length)];
                return this.getConnection((String)tuple.left, (Integer)tuple.right);
            }
            catch (Exception e) {
                if (++i <= this.runtimeTuples.length) continue;
                throw new InvalidVirtualPoolException(this.ipAddressList + " invalid");
            }
            break;
        }
    }

    private VenusBIOConnection getConnection(String ip, int port) throws Exception {
        Socket socket = new Socket();
        socket.setSoTimeout(10000);
        socket.setTcpNoDelay(true);
        socket.connect(new InetSocketAddress(ip, port), 5000);
        VenusBIOConnection conn = new VenusBIOConnection(socket, System.currentTimeMillis());
        byte[] tmp = conn.read();
        HandshakePacket packet = new HandshakePacket();
        packet.init(tmp);
        DummyAuthenPacket dummy = new DummyAuthenPacket();
        socket.getOutputStream().write(dummy.toByteArray());
        tmp = conn.read();
        OKPacket ok = new OKPacket();
        ok.init(tmp);
        return conn;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Matcher matcher;
        String uri = req.getRequestURI().trim();
        if (!req.getContextPath().equals("/")) {
            uri = uri.substring(req.getContextPath().length());
        }
        if (!this.urlPattern.endsWith("/") && uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if (!(matcher = this.servicePattern.matcher(uri)).matches() || matcher.groupCount() < 2) {
            Response result = new Response();
            result.setErrorCode(18004000);
            result.setErrorMessage("requst not matcher");
            this.writeResponse(req, resp, result);
            return;
        }
        resp.setContentType("application/json");
        JSONObject parameterMap = null;
        String service = matcher.group(1);
        String method = matcher.group(2);
        String clientID = req.getHeader(_VENUS_CLIENT_ID);
        String traceId = req.getHeader(_VENUS_TRACE_ID);
        String apiName = service + "." + method;
        String v = req.getParameter(VERSION);
        if (StringUtils.isEmpty((String)v)) {
            v = req.getHeader(VERSION_HEADER);
        }
        int version = 0;
        try {
            version = Integer.parseInt(v == null ? "0" : v);
        }
        catch (NumberFormatException e) {
            version = 0;
        }
        try {
            if (req.getContentLength() > 0) {
                byte[] message = new byte[req.getContentLength()];
                req.getInputStream().read(message);
                parameterMap = JSON.parseObject((String)new String(message, "UTF-8"));
            } else {
                parameterMap = new HashMap();
            }
            Set keys = req.getParameterMap().keySet();
            for (String key : keys) {
                parameterMap.put(key, req.getParameter(key));
            }
            parameterMap.remove(VERSION);
        }
        catch (Exception e) {
            int errorCode = 18005000;
            if (e instanceof JSONException) {
                errorCode = 18004000;
            }
            if (e instanceof CodedException) {
                CodedException codeEx = (CodedException)e;
                errorCode = codeEx.getErrorCode();
            }
            if (e instanceof VenusExceptionLevel) {
                if (((VenusExceptionLevel)e).getLevel() != null) {
                    this.logDependsOnLevel(((VenusExceptionLevel)e).getLevel(), logger, e.getMessage() + " client:{clientID=" + clientID + ",ip=" + req.getRemoteAddr() + ", apiName=" + service + "." + method + "}", e);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage() + " [ip=" + req.getRemoteAddr() + ", apiName=" + apiName + "]", (Throwable)e);
            }
            Response result = new Response();
            result.setErrorCode(errorCode);
            result.setErrorMessage(e.getMessage());
            this.writeResponse(req, resp, result);
            return;
        }
        Response result = null;
        long startTime = TimeUtil.currentTimeMillis();
        boolean isError = false;
        byte[] traceIdByt = null;
        try {
            if (StringUtil.isEmpty((String)traceId)) {
                traceIdByt = VenusTracerUtil.randomUUID();
                UUID uuid = new UUID(VenusTracerUtil.randomUUID());
                traceId = uuid.toString();
            }
            result = this.handleRequest(apiName, version, traceId, (Map<String, Object>)parameterMap);
        }
        catch (Exception e) {
            int errorCode = 18005000;
            if (e instanceof CodedException) {
                CodedException codeEx = (CodedException)e;
                errorCode = codeEx.getErrorCode();
            }
            if (errorCode >= 18000000 && errorCode < 19000000) {
                isError = true;
            }
            result = new Response();
            result.setErrorCode(errorCode);
            result.setErrorMessage(e.getMessage());
            logger.error("error when invoke", (Throwable)e);
            return;
        }
        finally {
            long endTime = TimeUtil.currentTimeMillis();
            VenusTracerUtil.logResult((long)(endTime - startTime), (String)traceId, (String)apiName, (String)JSON.toJSONString((Object)parameterMap, (SerializerFeature[])JSON_FEATURE), (String)JSON.toJSONString((Object)result, (SerializerFeature[])JSON_FEATURE));
            this.writeResponse(req, resp, result);
            MonitorRuntime.getInstance().calculateAverage(service, method, endTime - startTime, isError);
        }
    }

    private void logDependsOnLevel(ExceptionLevel level, Logger specifiedLogger, String msg, Throwable e) {
        switch (level) {
            case DEBUG: {
                specifiedLogger.debug(msg, e);
                break;
            }
            case INFO: {
                specifiedLogger.info(msg, e);
                break;
            }
            case TRACE: {
                specifiedLogger.trace(msg, e);
                break;
            }
            case WARN: {
                specifiedLogger.warn(msg, e);
                break;
            }
            case ERROR: {
                specifiedLogger.error(msg, e);
                break;
            }
        }
    }

    private void writeResponse(HttpServletRequest req, HttpServletResponse resp, Response result) throws IOException {
        resp.setContentType("application/json");
        resp.getOutputStream().write(JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}).getBytes(PacketConstant.PACKET_CHARSET));
    }

    private void writeResponse(HttpServletRequest req, HttpServletResponse resp, String result) throws IOException {
        resp.setContentType("application/json");
        resp.getOutputStream().write(result.getBytes(PacketConstant.PACKET_CHARSET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response handleRequest(String api, int version, String traceId, Map<String, Object> paramters) {
        Response response = new Response();
        VenusBIOConnection conn = null;
        try {
            UtilTimerStack.push((String)ENDPOINT_INVOKED_TIME);
            conn = this.getConnectionPolling();
            JsonVenusRequestPacket request = new JsonVenusRequestPacket();
            request.apiName = api;
            request.params = JSON.toJSONString(paramters);
            request.serviceVersion = version;
            conn.write(request.toByteArray());
            byte[] bts = conn.read();
            int type = AbstractServicePacket.getType((byte[])bts);
            if (type == -1) {
                ErrorPacket error = new ErrorPacket();
                error.init(bts);
                response.setErrorCode(error.errorCode);
                response.setErrorMessage(error.message);
            } else if (type == 0x4000001) {
                JsonVenusNotifyPacket notify = new JsonVenusNotifyPacket();
                notify.init(bts);
                response.setResult(notify.callbackObject);
            } else {
                JsonVenusResponsePacket responsePacket = new JsonVenusResponsePacket();
                responsePacket.init(bts);
                response.setResult(responsePacket.result);
            }
        }
        catch (Throwable e) {
            RemoteException re = (RemoteException)AnnotationUtil.getAnnotation((Annotation[])e.getClass().getAnnotations(), RemoteException.class);
            if (re != null) {
                response.setErrorCode(re.errorCode());
            } else {
                response.setErrorCode(18005000);
            }
            response.setErrorMessage(e.getMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
            UtilTimerStack.pop((String)ENDPOINT_INVOKED_TIME);
        }
        return response;
    }

    private RequestInfo getRequestInfo(HttpServletRequest req) {
        RequestInfo info = new RequestInfo();
        info.setRemoteIp(req.getRemoteHost());
        info.setProtocol(RequestInfo.Protocol.HTTP);
        info.setAccept("application/json");
        return info;
    }
}

