/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.support;

import com.meidusa.toolkit.common.util.StringUtil;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.annotations.Endpoint;
import com.meidusa.venus.annotations.Service;
import com.meidusa.venus.support.EndpointWrapper;
import com.meidusa.venus.support.ServiceWrapper;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VenusUtil {
    private static Logger logger = LoggerFactory.getLogger(VenusUtil.class);
    private static final String ATHENA_INTERFACE_SIMPLE_NAME = "AthenaDataService";
    private static final String ATHENA_INTERFACE_FULL_NAME = "com.athena.service.api.AthenaDataService";

    public static String getServicePath(Invocation invocation) {
        String servicePath = invocation.getServiceInterfaceName() + "/" + invocation.getServiceName() + "?version=" + invocation.getVersion();
        return servicePath;
    }

    public static String getMethodPath(Invocation invocation) {
        String methodPath = invocation.getServiceInterfaceName() + "/" + invocation.getServiceName() + "?version=" + invocation.getVersion() + "&method=" + invocation.getMethodName();
        return methodPath;
    }

    public static String getApiName(Method method, Service service, Endpoint endpoint) {
        String serviceName = null;
        serviceName = service == null || StringUtil.isEmpty((String)service.name()) ? method.getDeclaringClass().getCanonicalName() : service.name();
        String methodName = method.getName();
        methodName = endpoint == null || StringUtil.isEmpty((String)endpoint.name()) ? method.getName() : endpoint.name();
        return serviceName + "." + methodName;
    }

    public static String getApiName(Method method, ServiceWrapper service, EndpointWrapper endpoint) {
        String serviceName = null;
        serviceName = service == null || StringUtil.isEmpty((String)service.getName()) ? method.getDeclaringClass().getCanonicalName() : service.getName();
        String methodName = method.getName();
        methodName = endpoint == null || StringUtil.isEmpty((String)endpoint.getName()) ? method.getName() : endpoint.getName();
        return serviceName + "." + methodName;
    }

    public static boolean isAthenaInterface(Invocation invocation) {
        try {
            String serviceInterfaceName = invocation.getServiceInterfaceName();
            if (ATHENA_INTERFACE_SIMPLE_NAME.equalsIgnoreCase(serviceInterfaceName) || ATHENA_INTERFACE_FULL_NAME.equalsIgnoreCase(serviceInterfaceName)) {
                return true;
            }
            String apiName = invocation.getApiName();
            if (apiName.contains(ATHENA_INTERFACE_SIMPLE_NAME)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

