/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.support;

import com.meidusa.venus.support.MonitorResource;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.util.Map;
import org.slf4j.Logger;

public class MonitorResourceFacade
implements MonitorResource {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private static MonitorResourceFacade monitorResourceFacade;
    private MonitorResource defaultMonitorResource = null;

    private MonitorResourceFacade() {
        this.initDefaultMonitorResource();
    }

    public static MonitorResourceFacade getInstance() {
        if (monitorResourceFacade == null) {
            monitorResourceFacade = new MonitorResourceFacade();
        }
        return monitorResourceFacade;
    }

    @Override
    public void init() {
        block3: {
            try {
                if (this.defaultMonitorResource != null) {
                    this.defaultMonitorResource.init();
                }
            }
            catch (Exception e) {
                if (!exceptionLogger.isErrorEnabled()) break block3;
                exceptionLogger.error("init failed.", (Throwable)e);
            }
        }
    }

    @Override
    public void addProperty(String key, Object object) {
        block3: {
            try {
                if (this.defaultMonitorResource != null) {
                    this.defaultMonitorResource.addProperty(key, object);
                }
            }
            catch (Exception e) {
                if (!exceptionLogger.isErrorEnabled()) break block3;
                exceptionLogger.error("addProperty failed.", (Throwable)e);
            }
        }
    }

    @Override
    public Object getProperty(String key) {
        try {
            if (this.defaultMonitorResource != null) {
                return this.defaultMonitorResource.getProperty(key);
            }
            return null;
        }
        catch (Exception e) {
            if (exceptionLogger.isErrorEnabled()) {
                exceptionLogger.error("getProperty failed.", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public Map<String, Object> getAllProperties() {
        try {
            if (this.defaultMonitorResource != null) {
                return this.defaultMonitorResource.getAllProperties();
            }
            return null;
        }
        catch (Exception e) {
            if (exceptionLogger.isErrorEnabled()) {
                exceptionLogger.error("getAllProperties failed.", (Throwable)e);
            }
            return null;
        }
    }

    void initDefaultMonitorResource() {
        block3: {
            try {
                Class<?> clz = Class.forName("com.meidusa.venus.manager.service.DefaultMonitorResource");
                Object obj = clz.newInstance();
                if (obj != null) {
                    this.defaultMonitorResource = (MonitorResource)obj;
                }
            }
            catch (Exception e) {
                if (!exceptionLogger.isErrorEnabled()) break block3;
                exceptionLogger.error("load resource failed.", (Throwable)e);
            }
        }
    }
}

