/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus;

import com.meidusa.venus.Destroyier;
import com.meidusa.venus.Invoker;
import com.meidusa.venus.PackageValid;
import com.meidusa.venus.Protocol;
import com.meidusa.venus.ServiceFactory;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.exception.VenusConfigException;
import com.meidusa.venus.exception.XmlVenusExceptionFactory;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.support.MonitorResourceFacade;
import com.meidusa.venus.support.VenusContext;
import com.meidusa.venus.util.VenusLoggerFactory;
import com.saike.commons.Application;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import sun.misc.URLClassPath;

public class VenusApplication
implements InitializingBean,
DisposableBean {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private String name;
    private Application application;
    private boolean enableFilter = true;
    private static VenusApplication venusApplication;
    private static boolean isDestroyed;
    private static List<ServiceFactory> serviceFactoryList;
    private static List<Invoker> invokerList;
    private static List<Protocol> protocolList;
    private static List<Destroyier> serviceManagerList;

    private VenusApplication() {
        venusApplication = this;
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownListener()));
    }

    public static VenusApplication getInstance() {
        return venusApplication;
    }

    public void afterPropertiesSet() throws Exception {
        this.valid();
        this.init();
    }

    void valid() {
        if (StringUtils.isEmpty((String)this.name) && (this.application == null || StringUtils.isEmpty((String)this.application.getAppName()))) {
            throw new VenusConfigException("venusApplication name and application not allow empty.");
        }
        this.validFilteJars();
        this.validModulesVersion();
    }

    void validFilteJars() {
        List<String> clsPaths = this.getJarsFromClassLoader();
        logger.info("#########class path list begin#####");
        for (String item : clsPaths) {
            logger.info(item);
        }
        logger.info("#########class path list end#####");
        String[] filteJars = new String[]{"venus-annotations-3(.*?).jar", "venus-common-base-3(.*?).jar", "venus-common-exception-3(.*?).jar", "venus-common-io-3(.*?).jar", "venus-common-service-3(.*?).jar", "venus-common-validator-3(.*?).jar", "venus-client-3(.*?).jar", "venus-backend-3(.*?).jar", "venus-extension-athena-3(.*?).jar", "venus-athena-impl-3(.*?).jar"};
        List<String> filteJarList = Arrays.asList(filteJars);
        if (CollectionUtils.isEmpty(filteJarList)) {
            return;
        }
        String wsepr = "\\";
        String lsepr = "/";
        for (String item : clsPaths) {
            String clsPathName;
            int indexof = -1;
            if (item.lastIndexOf(wsepr) != -1) {
                indexof = item.lastIndexOf(wsepr);
            } else if (item.lastIndexOf(lsepr) != -1) {
                indexof = item.lastIndexOf(lsepr);
            }
            if (indexof == -1 || !(clsPathName = item.substring(indexof + 1, item.length())).endsWith(".jar")) continue;
            String jarName = clsPathName;
            for (String filteJarName : filteJarList) {
                Pattern r = Pattern.compile(filteJarName);
                Matcher m = r.matcher(jarName);
                if (!m.find()) continue;
                throw new VenusConfigException("found incompatible jar:" + jarName + ",please exclude.more detail info to see http://cf.dds.com/pages/viewpage.action?pageId=12456812 2.3.1 section.");
            }
        }
    }

    List<String> getJarsFromClassLoader() {
        ArrayList<String> jars = new ArrayList<String>();
        ArrayList<String> clazzLoaderJars = new ArrayList<String>();
        ClassLoader clazzLoader = Thread.currentThread().getContextClassLoader();
        logger.info("#######clazzLoader:{}", (Object)clazzLoader);
        try {
            if (clazzLoader != null && clazzLoader instanceof URLClassLoader) {
                URL[] urls;
                URLClassLoader urlClassLoader = (URLClassLoader)clazzLoader;
                for (URL url : urls = urlClassLoader.getURLs()) {
                    jars.add(url.getPath());
                }
                Field field = urlClassLoader.getClass().getDeclaredField("ucp");
                field.setAccessible(true);
                Object ucpValue = field.get(urlClassLoader);
                if (ucpValue != null && ucpValue instanceof URLClassPath) {
                    URLClassPath urlClassPath = (URLClassPath)ucpValue;
                    Field loadersField = urlClassPath.getClass().getDeclaredField("lmap");
                    loadersField.setAccessible(true);
                    Object lmapValue = loadersField.get(urlClassPath);
                    if (lmapValue != null && lmapValue instanceof Map) {
                        Map mm = (Map)lmapValue;
                        for (Map.Entry entry : mm.entrySet()) {
                            String clsPath = entry.getKey().toString();
                            clazzLoaderJars.add(clsPath);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            return jars;
        }
        return clazzLoaderJars;
    }

    List<String> getJarsFromSystemVal() {
        ArrayList<String> jars = new ArrayList<String>();
        String clsPath = System.getProperty("java.class.path");
        if (StringUtils.isEmpty((String)clsPath)) {
            return jars;
        }
        String[] clsPaths = clsPath.split(";");
        if (clsPaths == null || clsPaths.length == 0) {
            return jars;
        }
        for (int i = 0; i < clsPaths.length; ++i) {
            jars.add(clsPaths[i]);
        }
        return jars;
    }

    void validModulesVersion() {
        String[] packages = new String[]{"com.meidusa.venus.CommonBasePackageValid", "com.meidusa.venus.exception.CommonExceptionPackageValid", "com.meidusa.venus.io.RemotePackageValid", "com.meidusa.venus.client.ClientPackageValid"};
        List<String> packegeList = Arrays.asList(packages);
        if (CollectionUtils.isEmpty(packegeList)) {
            return;
        }
        for (String pkgName : packegeList) {
            String errorMsg;
            try {
                Class<?> pkgClz = Class.forName(pkgName);
                PackageValid packageValid = (PackageValid)pkgClz.newInstance();
                packageValid.valid();
            }
            catch (ClassNotFoundException e) {
                errorMsg = String.format("class %s not found,please check jar config.", pkgName);
                throw new VenusConfigException(errorMsg);
            }
            catch (InstantiationException e) {
                errorMsg = String.format("class %s instance failed,please check jar config.", pkgName);
                throw new VenusConfigException(errorMsg);
            }
            catch (IllegalAccessException e) {
                errorMsg = String.format("class %s access failed,please check jar config.", pkgName);
                throw new VenusConfigException(errorMsg);
            }
            catch (Exception e) {
                errorMsg = String.format("class %s valid failed,please check jar config.", pkgName);
                throw new VenusConfigException(errorMsg);
            }
        }
    }

    void init() {
        if (StringUtils.isEmpty((String)this.name)) {
            this.name = this.application.getAppName();
        }
        logger.info("#######application name:{}", (Object)this.name);
        VenusContext.getInstance().setApplication(this.name);
        SerializerFactory.init();
        XmlVenusExceptionFactory.getInstance().init();
        MonitorResourceFacade.getInstance().init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        if (logger.isWarnEnabled()) {
            logger.warn("spring container destroy,release resource.");
        }
        Class<VenusApplication> clazz = VenusApplication.class;
        synchronized (VenusApplication.class) {
            if (!isDestroyed) {
                this.doDestroy();
                isDestroyed = true;
            } else {
                logger.info("spring container already released.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void doDestroy() {
        block2: {
            try {
                this.releaseInvoker();
                this.releaseProtocol();
                this.releaseServiceManager();
                this.releaseServiceFactory();
            }
            catch (Throwable e) {
                if (!exceptionLogger.isErrorEnabled()) break block2;
                exceptionLogger.error("release resource failed.", e);
            }
        }
    }

    void releaseInvoker() {
        if (CollectionUtils.isEmpty(invokerList)) {
            return;
        }
        for (Invoker invoker : invokerList) {
            if (invoker == null) continue;
            try {
                invoker.destroy();
            }
            catch (RpcException e) {
                if (!exceptionLogger.isErrorEnabled()) continue;
                exceptionLogger.error("release invoker failed.", (Throwable)e);
            }
        }
    }

    void releaseServiceFactory() {
        if (CollectionUtils.isEmpty(serviceFactoryList)) {
            return;
        }
        for (ServiceFactory serviceFactory : serviceFactoryList) {
            if (serviceFactory == null) continue;
            try {
                serviceFactory.destroy();
            }
            catch (Exception e) {
                if (!exceptionLogger.isErrorEnabled()) continue;
                exceptionLogger.error("release serviceFactory failed.", (Throwable)e);
            }
        }
    }

    void releaseServiceManager() {
        if (CollectionUtils.isEmpty(serviceManagerList)) {
            return;
        }
        for (Destroyier serviceManager : serviceManagerList) {
            if (serviceManager == null) continue;
            try {
                serviceManager.destroy();
            }
            catch (Exception e) {
                if (!exceptionLogger.isErrorEnabled()) continue;
                exceptionLogger.error("release serviceManager failed.", (Throwable)e);
            }
        }
    }

    void releaseProtocol() {
        if (CollectionUtils.isEmpty(protocolList)) {
            return;
        }
        for (Protocol protocol : protocolList) {
            if (protocol == null) continue;
            try {
                protocol.destroy();
            }
            catch (Exception e) {
                if (!exceptionLogger.isErrorEnabled()) continue;
                exceptionLogger.error("release protocol failed.", (Throwable)e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnableFilter() {
        return this.enableFilter;
    }

    public void setEnableFilter(boolean enableFilter) {
        this.enableFilter = enableFilter;
    }

    public static List<Invoker> getInvokerList() {
        return invokerList;
    }

    public static List<ServiceFactory> getServiceFactoryList() {
        return serviceFactoryList;
    }

    public static List<Destroyier> getServiceManagerList() {
        return serviceManagerList;
    }

    public static List<Protocol> getProtocolList() {
        return protocolList;
    }

    public static void addInvoker(Invoker invoker) {
        invokerList.add(invoker);
    }

    public static void addServiceFactory(ServiceFactory serviceFactory) {
        serviceFactoryList.add(serviceFactory);
    }

    public static void addServiceManager(Destroyier serviceManager) {
        serviceManagerList.add(serviceManager);
    }

    public static void addProtocol(Protocol protocol) {
        protocolList.add(protocol);
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    static {
        isDestroyed = false;
        serviceFactoryList = new ArrayList<ServiceFactory>();
        invokerList = new ArrayList<Invoker>();
        protocolList = new ArrayList<Protocol>();
        serviceManagerList = new ArrayList<Destroyier>();
    }

    class ShutdownListener
    implements Runnable {
        ShutdownListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (logger.isWarnEnabled()) {
                logger.warn("venusApplication exit,release resource.");
            }
            Class<VenusApplication> clazz = VenusApplication.class;
            synchronized (VenusApplication.class) {
                if (!isDestroyed) {
                    VenusApplication.this.doDestroy();
                    isDestroyed = true;
                } else {
                    logger.info("venusApplication already released.");
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

