/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus;

import com.meidusa.venus.RemoteConfig;
import com.meidusa.venus.ServiceDefinitionExtra;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

public class URL
implements Serializable {
    private static final long serialVersionUID = -4259657535674215341L;
    private String protocol = "venus";
    private String path;
    private String interfaceName;
    private String serviceName;
    private String version;
    private String versionRange;
    private String methods;
    private String endpoints;
    private String application;
    private String host;
    private int port;
    private int weight = 1;
    private String loadbanlance;
    private boolean consumerCheck;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private RemoteConfig remoteConfig;
    private ServiceDefinitionExtra serviceDefinition;

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public String getProperty(String key) {
        if (this.properties.get(key) == null) {
            return null;
        }
        return String.valueOf(this.properties.get(key));
    }

    public static URL parse(String url) {
        if (StringUtils.isNotBlank((String)url)) {
            int indexOf;
            URL u = new URL();
            if (url.startsWith("venus://")) {
                u.setProtocol("venus");
                url = url.replaceFirst("venus://", "");
            }
            if (url.startsWith("/")) {
                url = url.replaceFirst("/", "");
            }
            if (url.startsWith("subscrible://")) {
                u.setProtocol("subscrible");
                url = url.replaceFirst("subscrible://", "");
            }
            if ((indexOf = url.indexOf("?")) != -1) {
                String path = url.substring(0, indexOf);
                u.setPath(path);
                String properties = url.substring(indexOf + 1);
                String[] splits = properties.split("&");
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 0; i < splits.length; ++i) {
                    String str = splits[i];
                    String[] split = str.split("=");
                    if (split.length <= 1) continue;
                    map.put(split[0], split[1]);
                    if (split[0].equals("protocol")) {
                        u.setProtocol(split[1]);
                    }
                    if (split[0].equals("port")) {
                        u.setPort(Integer.valueOf(split[1]));
                    }
                    if (split[0].equals("host")) {
                        u.setHost(split[1]);
                    }
                    if (split[0].equals("version")) {
                        u.setVersion(split[1]);
                    }
                    if (split[0].equals("versionRange")) {
                        u.setVersionRange(split[1]);
                    }
                    if (split[0].equals("loadbanlance")) {
                        u.setLoadbanlance(split[1]);
                    }
                    if (split[0].equals("application")) {
                        u.setApplication(split[1]);
                    }
                    if (split[0].equals("methods")) {
                        u.setMethods(split[1]);
                    }
                    if (!split[0].equals("endpoints")) continue;
                    u.setEndpoints(split[1]);
                }
                u.setProperties(map);
                if (path.contains(".") || path.contains("/")) {
                    if (path.contains("/")) {
                        String interfaceName = path.substring(0, path.indexOf("/"));
                        String serviceName = path.substring(path.indexOf("/") + 1);
                        u.setServiceName(serviceName);
                        u.setInterfaceName(interfaceName);
                    } else {
                        u.setServiceName(path);
                    }
                } else {
                    u.setServiceName(path);
                }
            }
            return u;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.application == null ? 0 : this.application.hashCode());
        result = 31 * result + (this.consumerCheck ? 1231 : 1237);
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.interfaceName == null ? 0 : this.interfaceName.hashCode());
        result = 31 * result + (this.loadbanlance == null ? 0 : this.loadbanlance.hashCode());
        result = 31 * result + (this.methods == null ? 0 : this.methods.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        URL other = (URL)obj;
        if (this.application == null ? other.application != null : !this.application.equals(other.application)) {
            return false;
        }
        if (this.consumerCheck != other.consumerCheck) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.interfaceName == null ? other.interfaceName != null : !this.interfaceName.equals(other.interfaceName)) {
            return false;
        }
        if (this.loadbanlance == null ? other.loadbanlance != null : !this.loadbanlance.equals(other.loadbanlance)) {
            return false;
        }
        if (this.methods == null ? other.methods != null : !this.methods.equals(other.methods)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol)) {
            return false;
        }
        if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getLoadbanlance() {
        return this.loadbanlance;
    }

    public void setLoadbanlance(String loadbanlance) {
        this.loadbanlance = loadbanlance;
    }

    public boolean isConsumerCheck() {
        return this.consumerCheck;
    }

    public void setConsumerCheck(boolean consumerCheck) {
        this.consumerCheck = consumerCheck;
    }

    public String getMethods() {
        return this.methods;
    }

    public void setMethods(String methods) {
        this.methods = methods;
    }

    public RemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    public void setRemoteConfig(RemoteConfig remoteConfig) {
        this.remoteConfig = remoteConfig;
    }

    public ServiceDefinitionExtra getServiceDefinition() {
        return this.serviceDefinition;
    }

    public void setServiceDefinition(ServiceDefinitionExtra serviceDefinition) {
        this.serviceDefinition = serviceDefinition;
    }

    public String getVersionRange() {
        return this.versionRange;
    }

    public void setVersionRange(String versionRange) {
        this.versionRange = versionRange;
    }

    public String getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(String endpoints) {
        this.endpoints = endpoints;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public static void main(String[] args) {
        String url = "/com.chexiang.order.OrderService/orderService?version=1.0.0&host=192.168.1.1&port=9000&application=order-service&loadbanlance=random";
        URL u = URL.parse(url);
        System.out.println(u);
        url = "/com.chexiang.order.OrderService/orderService?version=1.0.0&protocol=venus&versionRange=[1,3]&host=192.168.1.1&port=9000&methods=getOrderById[java.lang.String],selectAllOrder[java.lang.String]";
        u = URL.parse(url);
        System.out.println(u);
    }
}

