/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client;

import com.meidusa.toolkit.common.bean.BeanContext;
import com.meidusa.toolkit.common.bean.BeanContextBean;
import com.meidusa.toolkit.common.bean.config.ConfigUtil;
import com.meidusa.toolkit.common.bean.config.ConfigurationException;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.toolkit.net.ConnectionManager;
import com.meidusa.toolkit.net.util.StringUtil;
import com.meidusa.venus.annotations.Endpoint;
import com.meidusa.venus.client.InvocationListenerContainer;
import com.meidusa.venus.client.RemoteContainer;
import com.meidusa.venus.client.RemotingInvocationHandler;
import com.meidusa.venus.client.ServiceFactory;
import com.meidusa.venus.client.VenusConstant;
import com.meidusa.venus.client.VenusNIOMessageHandler;
import com.meidusa.venus.client.net.VenusBIOConnectionFactory;
import com.meidusa.venus.client.net.VenusNIOConnectionFactory;
import com.meidusa.venus.client.xml.bean.FactoryConfig;
import com.meidusa.venus.client.xml.bean.PoolConfig;
import com.meidusa.venus.client.xml.bean.Remote;
import com.meidusa.venus.client.xml.bean.ServiceConfig;
import com.meidusa.venus.client.xml.bean.VenusClient;
import com.meidusa.venus.digester.DigesterRuleParser;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.VenusExceptionFactory;
import com.meidusa.venus.exception.XmlVenusExceptionFactory;
import com.meidusa.venus.poolable.MultipleLoadBalanceObjectPool;
import com.meidusa.venus.poolable.PoolableObjectPool;
import com.meidusa.venus.util.FileWatchdog;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.xmlrules.FromXmlRuleSet;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.ResourceUtils;

public class VenusServiceFactory
implements ServiceFactory,
BeanFactoryAware,
InitializingBean,
BeanFactoryPostProcessor {
    private static Logger logger = LoggerFactory.getLogger(ServiceFactory.class);
    private Map<Class<?>, Tuple<Object, RemotingInvocationHandler>> servicesMap = new HashMap();
    private Map<String, Tuple<Object, RemotingInvocationHandler>> serviceBeanMap = new HashMap<String, Tuple<Object, RemotingInvocationHandler>>();
    private BeanFactory beanFactory;
    private ConnectionManager connManager;
    private String[] configFiles;
    private BeanContext beanContext;
    private boolean enableAsync = true;
    private boolean shutdown = false;
    private Map<String, Tuple<com.meidusa.venus.poolable.ObjectPool, com.meidusa.venus.poolable.ObjectPool>> poolMap = new HashMap<String, Tuple<com.meidusa.venus.poolable.ObjectPool, com.meidusa.venus.poolable.ObjectPool>>();
    private List<com.meidusa.venus.poolable.ObjectPool> realPools = new ArrayList<com.meidusa.venus.poolable.ObjectPool>();
    private InvocationListenerContainer container = new InvocationListenerContainer();
    private VenusNIOMessageHandler handler = new VenusNIOMessageHandler();
    private VenusExceptionFactory venusExceptionFactory;
    private Map<Class<?>, ServiceConfig> serviceConfig = new HashMap();
    private int asyncExecutorSize = 10;
    private boolean needPing = false;
    private Timer reloadTimer = new Timer();
    private boolean enableReload = true;

    public boolean isEnableReload() {
        return this.enableReload;
    }

    public void setEnableReload(boolean enableReload) {
        this.enableReload = enableReload;
    }

    public boolean isNeedPing() {
        return this.needPing;
    }

    public void setNeedPing(boolean needPing) {
        this.needPing = needPing;
    }

    public boolean isEnableAsync() {
        return this.enableAsync;
    }

    public void setEnableAsync(boolean enableAsync) {
        this.enableAsync = enableAsync;
    }

    public int getAsyncExecutorSize() {
        return this.asyncExecutorSize;
    }

    public void setAsyncExecutorSize(int asyncExecutorSize) {
        this.asyncExecutorSize = asyncExecutorSize;
    }

    public VenusExceptionFactory getVenusExceptionFactory() {
        return this.venusExceptionFactory;
    }

    public void setVenusExceptionFactory(VenusExceptionFactory venusExceptionFactory) {
        this.venusExceptionFactory = venusExceptionFactory;
    }

    public String[] getConfigFiles() {
        return this.configFiles;
    }

    public void setConfigFiles(String[] configFiles) {
        this.configFiles = configFiles;
    }

    @Override
    public <T> T getService(Class<T> t) {
        if (this.shutdown) {
            throw new IllegalStateException("service factory has been shutdown");
        }
        Tuple<Object, RemotingInvocationHandler> object = this.servicesMap.get(t);
        return (T)object.left;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        block8: {
            logger.trace("current Venus Client id=" + VenusConstant.VENUS_CLIENT_ID);
            if (this.venusExceptionFactory == null) {
                XmlVenusExceptionFactory xmlVenusExceptionFactory = new XmlVenusExceptionFactory();
                xmlVenusExceptionFactory.setConfigFiles(new String[]{"classpath:com/meidusa/venus/exception/VenusSystemException.xml"});
                xmlVenusExceptionFactory.init();
                this.venusExceptionFactory = xmlVenusExceptionFactory;
            }
            this.handler.setVenusExceptionFactory(this.venusExceptionFactory);
            if (this.enableAsync && this.connManager == null) {
                ExecutorService excutors = Executors.newFixedThreadPool(this.getAsyncExecutorSize());
                try {
                    this.connManager = new ConnectionManager();
                }
                catch (IOException e) {
                    throw new InitialisationException((Throwable)e);
                }
                this.connManager.setExecutor(excutors);
                this.connManager.start();
            }
            this.beanContext = new BeanContext(){

                public Object getBean(String beanName) {
                    if (VenusServiceFactory.this.beanFactory != null) {
                        return VenusServiceFactory.this.beanFactory.getBean(beanName);
                    }
                    return null;
                }

                public Object createBean(Class clazz) throws Exception {
                    if (VenusServiceFactory.this.beanFactory instanceof AutowireCapableBeanFactory) {
                        AutowireCapableBeanFactory factory = (AutowireCapableBeanFactory)VenusServiceFactory.this.beanFactory;
                        return factory.autowire(clazz, 1, false);
                    }
                    return null;
                }
            };
            BeanContextBean.getInstance().setBeanContext(this.beanContext);
            BeanUtilsBean.setInstance((BeanUtilsBean)new BeanUtilsBean(new ConvertUtilsBean(), new PropertyUtilsBean()){

                public void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException {
                    block8: {
                        if (value instanceof String) {
                            PropertyDescriptor descriptor = null;
                            try {
                                descriptor = this.getPropertyUtils().getPropertyDescriptor(bean, name);
                                if (descriptor == null) {
                                    return;
                                }
                                if (descriptor.getPropertyType().isEnum()) {
                                    Class<?> clazz = descriptor.getPropertyType();
                                    value = Enum.valueOf(clazz, (String)value);
                                    break block8;
                                }
                                Object temp = null;
                                try {
                                    temp = ConfigUtil.filter((String)((String)value), (BeanContext)VenusServiceFactory.this.beanContext);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (temp == null) {
                                    temp = ConfigUtil.filter((String)((String)value));
                                }
                                value = temp;
                            }
                            catch (NoSuchMethodException e) {
                                return;
                            }
                        }
                    }
                    super.setProperty(bean, name, value);
                }
            });
            this.handler.setContainer(this.container);
            this.reloadConfiguration();
            if (this.enableReload) {
                File[] files = new File[this.configFiles.length];
                int i = 0;
                while (i < this.configFiles.length) {
                    try {
                        files[i] = ResourceUtils.getFile((String)this.configFiles[i].trim());
                    }
                    catch (FileNotFoundException e) {
                        logger.warn(e.getMessage());
                        this.enableReload = false;
                        logger.warn("venus serviceFactory configuration reload disabled!");
                        break block8;
                    }
                    ++i;
                }
                VenusFileWatchdog dog = new VenusFileWatchdog(files);
                dog.setDelay(10000L);
                dog.start();
            }
        }
    }

    private synchronized void reloadConfiguration() throws Exception {
        HashMap servicesMap = new HashMap();
        HashMap<String, Tuple<com.meidusa.venus.poolable.ObjectPool, com.meidusa.venus.poolable.ObjectPool>> poolMap = new HashMap<String, Tuple<com.meidusa.venus.poolable.ObjectPool, com.meidusa.venus.poolable.ObjectPool>>();
        HashMap serviceConfig = new HashMap();
        ArrayList<com.meidusa.venus.poolable.ObjectPool> realPools = new ArrayList<com.meidusa.venus.poolable.ObjectPool>();
        try {
            this.loadConfiguration(poolMap, servicesMap, serviceConfig, realPools);
        }
        catch (Exception e) {
            this.reloadTimer.schedule((TimerTask)new ClosePoolTask(realPools), 30000L);
            throw e;
        }
        this.poolMap = poolMap;
        for (Map.Entry entry : servicesMap.entrySet()) {
            Class key = (Class)entry.getKey();
            Tuple source = (Tuple)entry.getValue();
            Tuple<Object, RemotingInvocationHandler> target = this.servicesMap.get(key);
            if (target != null) {
                ((RemotingInvocationHandler)target.right).setBioConnPool(((RemotingInvocationHandler)source.getRight()).getBioConnPool());
                ((RemotingInvocationHandler)target.right).setNioConnPool(((RemotingInvocationHandler)source.getRight()).getNioConnPool());
                ((RemotingInvocationHandler)target.right).setSerializeType((byte)((RemotingInvocationHandler)target.right).getSerializeType());
                continue;
            }
            this.servicesMap.put(key, (Tuple<Object, RemotingInvocationHandler>)source);
        }
        this.serviceConfig = serviceConfig;
        List<com.meidusa.venus.poolable.ObjectPool> oldPools = this.realPools;
        this.realPools = realPools;
        this.reloadTimer.schedule((TimerTask)new ClosePoolTask(oldPools), 30000L);
    }

    private void loadConfiguration(Map<String, Tuple<com.meidusa.venus.poolable.ObjectPool, com.meidusa.venus.poolable.ObjectPool>> poolMap, Map<Class<?>, Tuple<Object, RemotingInvocationHandler>> servicesMap, Map<Class<?>, ServiceConfig> serviceConfig, List<com.meidusa.venus.poolable.ObjectPool> realPools) throws Exception {
        VenusClient all = new VenusClient();
        String[] stringArray = this.configFiles;
        int n = this.configFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            string2 = (String)ConfigUtil.filter((String)string2);
            FromXmlRuleSet ruleSet = new FromXmlRuleSet(this.getClass().getResource("venusClientRule.xml"), (org.apache.commons.digester.xmlrules.DigesterRuleParser)new DigesterRuleParser());
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.addRuleSet((RuleSet)ruleSet);
            try {
                InputStream is = ResourceUtils.getURL((String)string2.trim()).openStream();
                VenusClient venus = (VenusClient)digester.parse(is);
                for (Map.Entry<Class<?>, ServiceConfig> entry : venus.getServiceMap().entrySet()) {
                    ServiceConfig config = entry.getValue();
                    if (config.getType() != null) continue;
                    throw new ConfigurationException("Service type can not be null:" + string2);
                }
                all.getRemoteMap().putAll(venus.getRemoteMap());
                all.getServiceMap().putAll(venus.getServiceMap());
            }
            catch (Exception e) {
                throw new ConfigurationException("can not parser xml:" + string2, (Throwable)e);
            }
            ++n2;
        }
        for (Map.Entry<String, Remote> entry : all.getRemoteMap().entrySet()) {
            RemoteContainer container = this.createRemoteContainer(entry.getValue(), realPools);
            Tuple tuple = new Tuple();
            tuple.left = container.getBioPool();
            tuple.right = container.getNioPool();
            poolMap.put(entry.getKey(), (Tuple<com.meidusa.venus.poolable.ObjectPool, com.meidusa.venus.poolable.ObjectPool>)tuple);
        }
        for (Map.Entry<Object, Object> entry : all.getServiceMap().entrySet()) {
            ServiceConfig config = (ServiceConfig)entry.getValue();
            Remote remote = all.getRemoteMap().get(config.getRemote());
            Tuple tuple = null;
            if (!StringUtil.isEmpty((String)config.getRemote())) {
                tuple = poolMap.get(config.getRemote());
                if (tuple == null) {
                    throw new ConfigurationException("remote=" + config.getRemote() + " not found!!");
                }
            } else {
                String ipAddress = config.getIpAddressList();
                tuple = poolMap.get(ipAddress);
                if (ipAddress != null && tuple == null) {
                    RemoteContainer container = this.createRemoteContainer(ipAddress, realPools);
                    tuple = new Tuple();
                    tuple.left = container.getBioPool();
                    tuple.right = container.getNioPool();
                    poolMap.put(ipAddress, (Tuple<com.meidusa.venus.poolable.ObjectPool, com.meidusa.venus.poolable.ObjectPool>)tuple);
                }
            }
            if (tuple != null) {
                RemotingInvocationHandler invocationHandler = new RemotingInvocationHandler();
                invocationHandler.setBioConnPool((ObjectPool)tuple.left);
                invocationHandler.setNioConnPool((ObjectPool)tuple.right);
                invocationHandler.setServiceFactory(this);
                invocationHandler.setVenusExceptionFactory(this.getVenusExceptionFactory());
                if (remote != null && remote.getAuthenticator() != null) {
                    invocationHandler.setSerializeType(remote.getAuthenticator().getSerializeType());
                }
                invocationHandler.setContainer(this.container);
                Object object = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{config.getType()}, (InvocationHandler)invocationHandler);
                Method[] methodArray = config.getType().getMethods();
                int n3 = methodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method method = methodArray[n4];
                    Endpoint endpoint = method.getAnnotation(Endpoint.class);
                    if (endpoint != null) {
                        Class<?>[] eclazz;
                        Class<?>[] classArray = eclazz = method.getExceptionTypes();
                        int n5 = eclazz.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Class<?> clazz = classArray[n6];
                            if (this.venusExceptionFactory != null && CodedException.class.isAssignableFrom(clazz)) {
                                this.venusExceptionFactory.addException(clazz);
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
                serviceConfig.put(config.getType(), config);
                Tuple serviceTuple = new Tuple(object, (Object)invocationHandler);
                servicesMap.put(config.getType(), (Tuple<Object, RemotingInvocationHandler>)serviceTuple);
                if (config.getBeanName() == null) continue;
                this.serviceBeanMap.put(config.getBeanName(), (Tuple<Object, RemotingInvocationHandler>)serviceTuple);
                continue;
            }
            if (config.getInstance() != null) {
                Tuple serviceTuple = new Tuple(config.getInstance(), null);
                servicesMap.put(config.getType(), (Tuple<Object, RemotingInvocationHandler>)serviceTuple);
                if (config.getBeanName() == null) continue;
                this.serviceBeanMap.put(config.getBeanName(), (Tuple<Object, RemotingInvocationHandler>)serviceTuple);
                continue;
            }
            throw new ConfigurationException("Service instance or ipAddressList or remote can not be null:" + config.getType());
        }
    }

    private RemoteContainer createRemoteContainer(String ipAddress, List<com.meidusa.venus.poolable.ObjectPool> realPools) throws Exception {
        RemoteContainer container = new RemoteContainer();
        if (!StringUtil.isEmpty((String)ipAddress)) {
            String[] ipList = StringUtil.split((String)ipAddress, (String)", ");
            PoolableObjectPool[] bioPools = new PoolableObjectPool[ipList.length];
            PoolableObjectPool[] nioPools = new PoolableObjectPool[ipList.length];
            int i = 0;
            while (i < ipList.length) {
                nioPools[i] = new PoolableObjectPool();
                bioPools[i] = new PoolableObjectPool();
                VenusNIOConnectionFactory nioFactory = new VenusNIOConnectionFactory();
                VenusBIOConnectionFactory bioFactory = new VenusBIOConnectionFactory();
                bioFactory.setNeedPing(this.needPing);
                String[] temp = StringUtil.split((String)ipList[i], (String)":");
                if (temp.length > 1) {
                    nioFactory.setIpAddress(temp[0]);
                    nioFactory.setPort(Integer.valueOf(temp[1]));
                    bioFactory.setIpAddress(temp[0]);
                    bioFactory.setPort(Integer.valueOf(temp[1]));
                } else {
                    nioFactory.setIpAddress(temp[0]);
                    nioFactory.setPort(16800);
                    bioFactory.setIpAddress(temp[0]);
                    bioFactory.setPort(16800);
                }
                if (this.isEnableAsync()) {
                    nioFactory.setConnectionManager(this.connManager);
                    nioFactory.setMessageHandler(this.handler);
                    nioFactory.init();
                    nioPools[i].setFactory((PoolableObjectFactory)nioFactory);
                    nioPools[i].setName("n-connPool-" + nioFactory.getIpAddress());
                    nioPools[i].init();
                    realPools.add((com.meidusa.venus.poolable.ObjectPool)nioPools[i]);
                }
                bioPools[i].setName("b-connPool-" + nioFactory.getIpAddress());
                bioPools[i].setFactory((PoolableObjectFactory)bioFactory);
                bioPools[i].init();
                realPools.add((com.meidusa.venus.poolable.ObjectPool)bioPools[i]);
                ++i;
            }
            if (ipList.length > 1) {
                MultipleLoadBalanceObjectPool bioPool = new MultipleLoadBalanceObjectPool(1, (com.meidusa.venus.poolable.ObjectPool[])bioPools);
                MultipleLoadBalanceObjectPool nioPool = new MultipleLoadBalanceObjectPool(1, (com.meidusa.venus.poolable.ObjectPool[])nioPools);
                bioPool.setName("b-multi-connPool\uff0d" + ipAddress);
                nioPool.setName("n-multi-connPool\uff0d" + ipAddress);
                bioPool.init();
                nioPool.init();
                realPools.add((com.meidusa.venus.poolable.ObjectPool)bioPool);
                realPools.add((com.meidusa.venus.poolable.ObjectPool)nioPool);
                container.setBioPool((com.meidusa.venus.poolable.ObjectPool)bioPool);
                container.setNioPool((com.meidusa.venus.poolable.ObjectPool)nioPool);
            } else {
                container.setBioPool((com.meidusa.venus.poolable.ObjectPool)bioPools[0]);
                container.setNioPool((com.meidusa.venus.poolable.ObjectPool)nioPools[0]);
            }
        } else {
            throw new IllegalArgumentException(" ipaddress cannot be null");
        }
        return container;
    }

    private RemoteContainer createRemoteContainer(Remote remote, List<com.meidusa.venus.poolable.ObjectPool> realPools) throws Exception {
        RemoteContainer container = new RemoteContainer();
        FactoryConfig factoryConfig = remote.getFactory();
        PoolConfig poolConfig = remote.getPool();
        String ipAddress = factoryConfig.getIpAddressList();
        if (!StringUtil.isEmpty((String)ipAddress)) {
            String[] ipList = StringUtil.split((String)ipAddress, (String)", ");
            PoolableObjectPool[] bioPools = new PoolableObjectPool[ipList.length];
            PoolableObjectPool[] nioPools = new PoolableObjectPool[ipList.length];
            int i = 0;
            while (i < ipList.length) {
                String[] temp;
                nioPools[i] = new PoolableObjectPool();
                bioPools[i] = new PoolableObjectPool();
                if (poolConfig != null) {
                    BeanUtils.copyProperties((Object)nioPools[i], (Object)poolConfig);
                    BeanUtils.copyProperties((Object)bioPools[i], (Object)poolConfig);
                }
                VenusNIOConnectionFactory nioFactory = new VenusNIOConnectionFactory();
                if (remote.getAuthenticator() != null) {
                    nioFactory.setAuthenticator(remote.getAuthenticator());
                }
                VenusBIOConnectionFactory bioFactory = new VenusBIOConnectionFactory();
                if (remote != null && remote.getAuthenticator() != null) {
                    bioFactory.setAuthenticator(remote.getAuthenticator());
                }
                bioFactory.setNeedPing(this.needPing);
                if (factoryConfig != null) {
                    BeanUtils.copyProperties((Object)((Object)nioFactory), (Object)factoryConfig);
                    BeanUtils.copyProperties((Object)bioFactory, (Object)factoryConfig);
                }
                if ((temp = StringUtil.split((String)ipList[i], (String)":")).length > 1) {
                    nioFactory.setIpAddress(temp[0]);
                    nioFactory.setPort(Integer.valueOf(temp[1]));
                    bioFactory.setIpAddress(temp[0]);
                    bioFactory.setPort(Integer.valueOf(temp[1]));
                } else {
                    nioFactory.setIpAddress(temp[0]);
                    nioFactory.setPort(16800);
                    bioFactory.setIpAddress(temp[0]);
                    bioFactory.setPort(16800);
                }
                if (this.isEnableAsync()) {
                    nioFactory.setConnectionManager(this.connManager);
                    nioFactory.setMessageHandler(this.handler);
                    nioFactory.init();
                    nioPools[i].setFactory((PoolableObjectFactory)nioFactory);
                    nioPools[i].setName("n-connPool-" + nioFactory.getIpAddress());
                    nioPools[i].init();
                    realPools.add((com.meidusa.venus.poolable.ObjectPool)nioPools[i]);
                }
                bioPools[i].setName("b-connPool-" + bioFactory.getIpAddress());
                bioPools[i].setFactory((PoolableObjectFactory)bioFactory);
                bioPools[i].init();
                realPools.add((com.meidusa.venus.poolable.ObjectPool)bioPools[i]);
                ++i;
            }
            if (ipList.length > 1) {
                MultipleLoadBalanceObjectPool bioPool = new MultipleLoadBalanceObjectPool(1, (com.meidusa.venus.poolable.ObjectPool[])bioPools);
                MultipleLoadBalanceObjectPool nioPool = new MultipleLoadBalanceObjectPool(1, (com.meidusa.venus.poolable.ObjectPool[])nioPools);
                bioPool.setName("b-multi-connPool\uff0d" + remote.getName());
                nioPool.setName("n-multi-connPool\uff0d" + remote.getName());
                container.setBioPool((com.meidusa.venus.poolable.ObjectPool)bioPool);
                container.setNioPool((com.meidusa.venus.poolable.ObjectPool)nioPool);
                bioPool.init();
                nioPool.init();
                realPools.add((com.meidusa.venus.poolable.ObjectPool)bioPool);
                realPools.add((com.meidusa.venus.poolable.ObjectPool)nioPool);
            } else {
                container.setBioPool((com.meidusa.venus.poolable.ObjectPool)bioPools[0]);
                container.setNioPool((com.meidusa.venus.poolable.ObjectPool)nioPools[0]);
            }
        } else {
            throw new IllegalArgumentException("remtoe=" + remote.getName() + ", ipaddress cannot be null");
        }
        container.setRemote(remote);
        return container;
    }

    public ServiceConfig getServiceConfig(Class<?> type) {
        return this.serviceConfig.get(type);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory cbf = beanFactory;
            for (Map.Entry<Class<?>, Tuple<Object, RemotingInvocationHandler>> entry : this.servicesMap.entrySet()) {
                cbf.registerResolvableDependency(entry.getKey(), entry.getValue().left);
            }
            for (Map.Entry<Object, Tuple<Object, RemotingInvocationHandler>> entry : this.serviceBeanMap.entrySet()) {
                cbf.registerSingleton((String)entry.getKey(), entry.getValue().left);
            }
        }
    }

    @Override
    public synchronized void destroy() {
        this.shutdown = true;
        if (this.connManager != null && this.connManager.isAlive()) {
            this.connManager.shutdown();
        }
    }

    class ClosePoolTask
    extends TimerTask {
        List<com.meidusa.venus.poolable.ObjectPool> pools;

        public ClosePoolTask(List<com.meidusa.venus.poolable.ObjectPool> pools) {
            this.pools = pools;
        }

        @Override
        public void run() {
            for (com.meidusa.venus.poolable.ObjectPool pool : this.pools) {
                try {
                    pool.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class VenusFileWatchdog
    extends FileWatchdog {
        protected VenusFileWatchdog(File ... file) {
            super(file);
        }

        protected void doOnChange() {
            try {
                VenusServiceFactory.this.reloadConfiguration();
            }
            catch (Exception e) {
                logger.error("reload configuration error", (Throwable)e);
            }
        }
    }
}

