/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client;

import com.meidusa.toolkit.common.util.StringUtil;
import com.meidusa.venus.annotations.Endpoint;
import com.meidusa.venus.annotations.Service;
import com.meidusa.venus.annotations.util.AnnotationUtil;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.metainfo.EndpointParameter;
import com.meidusa.venus.metainfo.EndpointParameterUtil;
import com.meidusa.venus.util.VenusAnnotationUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VenusInvocationHandler
implements InvocationHandler {
    private static Logger logger = LoggerFactory.getLogger(VenusInvocationHandler.class);
    private static Logger exceptionLogger = LoggerFactory.getLogger((String)"venus.client.exception");
    private Map<String, Object> singletonServiceMap = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Service service = null;
        Endpoint endpoint = null;
        try {
            endpoint = (Endpoint)AnnotationUtil.getAnnotation((Annotation[])method.getAnnotations(), Endpoint.class);
            if (endpoint != null) {
                service = (Service)AnnotationUtil.getAnnotation((Annotation[])method.getDeclaringClass().getAnnotations(), Service.class);
                if (StringUtil.isEmpty((String)service.implement())) {
                    EndpointParameter[] params = EndpointParameterUtil.getPrameters((Method)method);
                    return this.invokeRemoteService(service, endpoint, method, params, args);
                }
                Object serviceImpl = null;
                if (service.singleton()) {
                    serviceImpl = this.singletonServiceMap.get(service.implement());
                    if (serviceImpl == null) {
                        Map<String, Object> map = this.singletonServiceMap;
                        synchronized (map) {
                            serviceImpl = this.singletonServiceMap.get(service.implement());
                            if (serviceImpl == null) {
                                serviceImpl = Class.forName(service.implement(), true, Thread.currentThread().getContextClassLoader()).newInstance();
                                this.singletonServiceMap.put(service.implement(), serviceImpl);
                            }
                        }
                    }
                } else {
                    serviceImpl = Class.forName(service.implement(), true, Thread.currentThread().getContextClassLoader()).newInstance();
                }
                return method.invoke(serviceImpl, args);
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                return method.invoke((Object)this, args);
            }
            logger.error("remote invoke error: endpoint annotation not declare on method=" + method.getName());
            throw new IllegalAccessException("remote invoke error: endpoint annotation not declare on method=" + method.getName());
        }
        catch (Throwable e) {
            if (!(e instanceof CodedException)) {
                if (exceptionLogger.isInfoEnabled()) {
                    exceptionLogger.info("invoke service error,api=" + VenusAnnotationUtils.getApiname((Method)method, (Service)service, (Endpoint)endpoint), e);
                }
            } else if (exceptionLogger.isDebugEnabled()) {
                exceptionLogger.debug("invoke service error,api=" + VenusAnnotationUtils.getApiname((Method)method, (Service)service, (Endpoint)endpoint), e);
            }
            throw e;
        }
    }

    protected abstract Object invokeRemoteService(Service var1, Endpoint var2, Method var3, EndpointParameter[] var4, Object[] var5) throws Exception;
}

