/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.client.net;

import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.MessageHandler;
import com.meidusa.venus.client.authenticate.Authenticator;
import com.meidusa.venus.client.authenticate.DummyAuthenticator;
import com.meidusa.venus.client.net.PoolableConnectionFactory;
import com.meidusa.venus.client.net.VenusNIOConnection;
import com.meidusa.venus.io.packet.AuthenPacket;
import com.meidusa.venus.io.packet.HandshakePacket;
import java.nio.channels.SocketChannel;
import org.apache.commons.pool.PoolableObjectFactory;

public class VenusNIOConnectionFactory
extends PoolableConnectionFactory
implements PoolableObjectFactory {
    private Authenticator<HandshakePacket, AuthenPacket> authenticator = new DummyAuthenticator<AuthenPacket>();
    private MessageHandler<VenusNIOConnection> messageHandler;
    private int outQueueMaxSize = 1;

    public int getOutQueueMaxSize() {
        return this.outQueueMaxSize;
    }

    public MessageHandler<VenusNIOConnection> getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(MessageHandler<VenusNIOConnection> messageHandler) {
        this.messageHandler = messageHandler;
    }

    public Authenticator<HandshakePacket, AuthenPacket> getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    protected Connection newConnectionInstance(SocketChannel channel, long createStamp) {
        VenusNIOConnection conn = new VenusNIOConnection(channel, createStamp);
        conn.setAuthenticator(this.getAuthenticator());
        conn.setMessageHandler(this.messageHandler);
        conn.setOutQueueMaxSize(this.outQueueMaxSize);
        return conn;
    }
}

