/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.support;

import com.meidusa.toolkit.net.Connection;
import com.meidusa.venus.Result;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.backend.support.ServerResponseWrapper;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.DefaultVenusException;
import com.meidusa.venus.io.network.VenusFrontendConnection;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.OKPacket;
import com.meidusa.venus.io.packet.ServiceAPIPacket;
import com.meidusa.venus.io.packet.ServiceNofityPacket;
import com.meidusa.venus.io.packet.VenusRouterPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceNofityPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceRequestPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceResponsePacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.notify.ReferenceInvocationListener;
import com.meidusa.venus.util.ThreadLocalMap;
import com.meidusa.venus.util.Utils;
import com.meidusa.venus.util.VenusLoggerFactory;
import com.meidusa.venus.util.VenusTracerUtil;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerResponseHandler {
    private static Logger logger = LoggerFactory.getLogger(ServerResponseHandler.class);
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();

    public void writeResponseForResponse(ServerResponseWrapper wrapper) throws Exception {
        VenusFrontendConnection conn = wrapper.getConn();
        VenusRouterPacket routerPacket = wrapper.getRouterPacket();
        ServiceAPIPacket apiPacket = wrapper.getApiPacket();
        SerializeServiceRequestPacket request = wrapper.getRequest();
        Endpoint endpoint = wrapper.getEndpoint();
        Result result = wrapper.getResult();
        short serializeType = wrapper.getSerializeType();
        Serializer serializer = SerializerFactory.getSerializer((short)serializeType);
        if (result.getErrorCode() == 0) {
            SerializeServiceResponsePacket response = new SerializeServiceResponsePacket(serializer, endpoint.getMethod().getGenericReturnType());
            if (request != null) {
                AbstractServicePacket.copyHead((AbstractServicePacket)request, (AbstractServicePacket)response);
            } else if (apiPacket != null) {
                AbstractServicePacket.copyHead((AbstractServicePacket)apiPacket, (AbstractServicePacket)response);
            }
            response.result = result.getResult();
            this.postMessageBack((Connection)conn, routerPacket, (AbstractServicePacket)response);
        } else {
            ErrorPacket error = this.toErrorPacket(result, (AbstractServicePacket)request, apiPacket, serializer);
            this.postMessageBack((Connection)conn, routerPacket, (AbstractServicePacket)error);
        }
    }

    public void writeResponseForOk(ServerResponseWrapper wrapper) throws Exception {
        VenusFrontendConnection conn = wrapper.getConn();
        VenusRouterPacket routerPacket = wrapper.getRouterPacket();
        ServiceAPIPacket apiPacket = wrapper.getApiPacket();
        SerializeServiceRequestPacket request = wrapper.getRequest();
        Result result = wrapper.getResult();
        short serializeType = wrapper.getSerializeType();
        Serializer serializer = SerializerFactory.getSerializer((short)serializeType);
        if (result.getErrorCode() == 0) {
            OKPacket ok = new OKPacket();
            if (request != null) {
                AbstractServicePacket.copyHead((AbstractServicePacket)request, (AbstractServicePacket)ok);
            } else if (apiPacket != null) {
                AbstractServicePacket.copyHead((AbstractServicePacket)apiPacket, (AbstractServicePacket)ok);
            }
            this.postMessageBack((Connection)conn, routerPacket, (AbstractServicePacket)ok);
        } else {
            ErrorPacket error = this.toErrorPacket(result, (AbstractServicePacket)request, apiPacket, serializer);
            this.postMessageBack((Connection)conn, routerPacket, (AbstractServicePacket)error);
        }
    }

    ErrorPacket toErrorPacket(Result result, AbstractServicePacket request, ServiceAPIPacket apiPacket, Serializer serializer) throws Exception {
        ErrorPacket error = new ErrorPacket();
        if (request != null) {
            AbstractServicePacket.copyHead((AbstractServicePacket)request, (AbstractServicePacket)error);
        } else if (apiPacket != null) {
            AbstractServicePacket.copyHead((AbstractServicePacket)apiPacket, (AbstractServicePacket)error);
        }
        error.errorCode = result.getErrorCode();
        error.message = result.getErrorMessage();
        Throwable ex = result.getException();
        if (ex != null) {
            Map mpd = Utils.getBeanPropertyDescriptor(ex.getClass());
            HashMap additionalData = new HashMap();
            for (Map.Entry entry : mpd.entrySet()) {
                additionalData.put(entry.getKey(), ((PropertyDescriptor)entry.getValue()).getReadMethod().invoke((Object)ex, new Object[0]));
            }
            error.additionalData = serializer.encode(additionalData);
        }
        return error;
    }

    public void writeResponseForNotify(ServerResponseWrapper wrapper) throws Exception {
        VenusFrontendConnection conn = wrapper.getConn();
        VenusRouterPacket routerPacket = wrapper.getRouterPacket();
        ServiceAPIPacket apiPacket = wrapper.getApiPacket();
        SerializeServiceRequestPacket request = wrapper.getRequest();
        Result result = wrapper.getResult();
        Serializer serializer = SerializerFactory.getSerializer((short)conn.getSerializeType());
        ReferenceInvocationListener referenceInvocationListener = (ReferenceInvocationListener)wrapper.getInvocationListener();
        if (result.getErrorCode() == 0) {
            SerializeServiceNofityPacket response = new SerializeServiceNofityPacket(serializer, null);
            if (request != null) {
                AbstractServicePacket.copyHead((AbstractServicePacket)request, (AbstractServicePacket)response);
            } else if (apiPacket != null) {
                AbstractServicePacket.copyHead((AbstractServicePacket)apiPacket, (AbstractServicePacket)response);
            }
            response.callbackObject = result.getResult();
            response.apiName = request.apiName;
            response.identityData = referenceInvocationListener.getIdentityData();
            byte[] traceID = (byte[])ThreadLocalMap.get((Object)"REQUEST_TRACE_ID");
            if (traceID == null) {
                traceID = VenusTracerUtil.randomUUID();
                ThreadLocalMap.put((Object)"REQUEST_TRACE_ID", (Object)traceID);
            }
            response.traceId = traceID;
            this.postMessageBack((Connection)conn, routerPacket, (AbstractServicePacket)response);
        } else {
            ServiceNofityPacket response = this.toNotifyPacket(result, (AbstractServicePacket)request, apiPacket, referenceInvocationListener, serializer);
            this.postMessageBack((Connection)conn, routerPacket, (AbstractServicePacket)response);
        }
    }

    ServiceNofityPacket toNotifyPacket(Result result, AbstractServicePacket request, ServiceAPIPacket apiPacket, ReferenceInvocationListener referenceInvocationListener, Serializer serializer) throws Exception {
        Throwable e = null;
        e = result.getException() == null ? new DefaultVenusException(result.getErrorCode(), result.getErrorMessage()) : result.getException();
        SerializeServiceNofityPacket response = new SerializeServiceNofityPacket(serializer, null);
        if (request != null) {
            AbstractServicePacket.copyHead((AbstractServicePacket)request, (AbstractServicePacket)response);
        } else if (apiPacket != null) {
            AbstractServicePacket.copyHead((AbstractServicePacket)apiPacket, (AbstractServicePacket)response);
        }
        if (e instanceof CodedException) {
            CodedException codedException = (CodedException)e;
            response.errorCode = codedException.getErrorCode();
        } else {
            response.errorCode = 18005000;
        }
        if (e != null) {
            Map mpd = Utils.getBeanPropertyDescriptor(e.getClass());
            HashMap additionalData = new HashMap();
            for (Map.Entry entry : mpd.entrySet()) {
                try {
                    additionalData.put(entry.getKey(), ((PropertyDescriptor)entry.getValue()).getReadMethod().invoke((Object)e, new Object[0]));
                }
                catch (Exception ex) {
                    if (!logger.isErrorEnabled()) continue;
                    exceptionLogger.error("read config properpty error", (Throwable)ex);
                }
            }
            response.additionalData = serializer.encode(additionalData);
            response.errorMessage = e.getMessage();
        }
        response.apiName = ((SerializeServiceRequestPacket)request).apiName;
        response.identityData = referenceInvocationListener.getIdentityData();
        byte[] traceID = VenusTracerUtil.getTracerID();
        if (traceID == null) {
            traceID = VenusTracerUtil.randomTracerID();
        }
        response.traceId = traceID;
        return response;
    }

    void postMessageBack(Connection conn, VenusRouterPacket routerPacket, AbstractServicePacket response) {
        if (routerPacket == null) {
            conn.write(response.toByteBuffer());
        } else {
            routerPacket.data = response.toByteArray();
            conn.write(routerPacket.toByteBuffer());
        }
    }
}

