/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.services.xml;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.meidusa.fastjson.JSON;
import com.meidusa.toolkit.common.bean.BeanContext;
import com.meidusa.toolkit.common.bean.BeanContextBean;
import com.meidusa.toolkit.common.bean.config.ConfigurationException;
import com.meidusa.venus.Destroyier;
import com.meidusa.venus.URL;
import com.meidusa.venus.VenusApplication;
import com.meidusa.venus.backend.VenusProtocol;
import com.meidusa.venus.backend.services.AbstractServiceManager;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.backend.services.Interceptor;
import com.meidusa.venus.backend.services.Service;
import com.meidusa.venus.backend.services.SingletonService;
import com.meidusa.venus.backend.services.xml.config.ExportService;
import com.meidusa.venus.backend.services.xml.config.InterceptorDef;
import com.meidusa.venus.backend.services.xml.config.VenusServerConfig;
import com.meidusa.venus.backend.services.xml.support.BackendBeanContext;
import com.meidusa.venus.backend.services.xml.support.BackendBeanUtilsBean;
import com.meidusa.venus.exception.VenusConfigException;
import com.meidusa.venus.monitor.VenusMonitorFactory;
import com.meidusa.venus.registry.Register;
import com.meidusa.venus.registry.VenusRegistryFactory;
import com.meidusa.venus.support.VenusContext;
import com.meidusa.venus.util.NetUtil;
import com.meidusa.venus.util.VenusBeanUtilsBean;
import com.meidusa.venus.util.VenusLoggerFactory;
import com.thoughtworks.xstream.XStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class XmlFileServiceManager
extends AbstractServiceManager
implements InitializingBean,
BeanFactoryAware,
ApplicationContextAware {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private Resource[] configFiles;
    private BeanFactory beanFactory;
    private BeanContext beanContext;
    private ApplicationContext applicationContext;
    private VenusApplication venusApplication;
    private VenusProtocol venusProtocol;
    private VenusRegistryFactory venusRegistryFactory;
    private VenusMonitorFactory venusMonitorFactory;

    public Resource[] getConfigFiles() {
        return this.configFiles;
    }

    public void setConfigFiles(Resource ... configFiles) {
        this.configFiles = configFiles;
    }

    public XmlFileServiceManager() {
        VenusApplication.addServiceManager((Destroyier)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.valid();
        this.init();
    }

    void valid() {
        if (this.venusApplication == null) {
            throw new VenusConfigException("venusApplication not config.");
        }
        if (this.venusProtocol == null) {
            throw new VenusConfigException("venusProtocol not config.");
        }
        if ((this.venusRegistryFactory == null || this.venusRegistryFactory.getRegister() == null) && logger.isWarnEnabled()) {
            logger.warn("venusRegistryFactory not enabled,will disable service registe.");
        }
        if (this.venusMonitorFactory == null && logger.isWarnEnabled()) {
            logger.warn("venusMonitorFactory not enabled,will disable monitor reporte.");
        }
    }

    void init() {
        this.initContext();
        this.initProtocol();
        this.initConfiguration();
    }

    void initContext() {
        if (this.applicationContext != null) {
            VenusContext.getInstance().setApplicationContext(this.applicationContext);
        }
        this.beanContext = new BackendBeanContext(this.beanFactory);
        BeanContextBean.getInstance().setBeanContext(this.beanContext);
        VenusBeanUtilsBean.setInstance((BeanUtilsBean)new BackendBeanUtilsBean(new ConvertUtilsBean(), new PropertyUtilsBean(), this.beanContext));
        if (this.beanContext != null) {
            VenusContext.getInstance().setBeanContext(this.beanContext);
        }
    }

    void initProtocol() {
        try {
            this.venusProtocol.setSrvMgr(this);
            this.venusProtocol.init();
        }
        catch (Exception e) {
            throw new RuntimeException("init protocol failed.", e);
        }
    }

    void initConfiguration() {
        VenusServerConfig venusServerConfig = this.parseServerConfig();
        List<ExportService> exportServiceList = venusServerConfig.getExportServices();
        if (CollectionUtils.isEmpty(exportServiceList)) {
            if (logger.isWarnEnabled()) {
                logger.warn("not config export services.");
            }
            return;
        }
        for (ExportService exportService : exportServiceList) {
            this.initSerivce(exportService);
        }
    }

    private VenusServerConfig parseServerConfig() {
        HashMap<String, String> exportBeanMap = new HashMap<String, String>();
        VenusServerConfig allVenusServerConfig = new VenusServerConfig();
        ArrayList<ExportService> allExportServiceList = new ArrayList<ExportService>();
        allVenusServerConfig.setExportServices(allExportServiceList);
        XStream xStream = new XStream();
        xStream.autodetectAnnotations(true);
        xStream.processAnnotations(VenusServerConfig.class);
        xStream.processAnnotations(ExportService.class);
        xStream.processAnnotations(InterceptorDef.class);
        for (Resource configFile : this.configFiles) {
            try {
                VenusServerConfig venusServerConfig = (VenusServerConfig)xStream.fromXML(configFile.getURL());
                HashMap<String, InterceptorDef> interceptorDefMap = new HashMap<String, InterceptorDef>();
                if (CollectionUtils.isNotEmpty(venusServerConfig.getInterceptorDefList())) {
                    for (InterceptorDef interceptorDef : venusServerConfig.getInterceptorDefList()) {
                        String interceptorClassName = interceptorDef.getClazz();
                        try {
                            Object obj = Class.forName(interceptorClassName).newInstance();
                            if (!(obj instanceof Interceptor)) {
                                throw new ConfigurationException("init inteceptor failed:" + interceptorClassName + ",not interceptor class.");
                            }
                            interceptorDef.setInterceptor((Interceptor)obj);
                        }
                        catch (Exception e) {
                            throw new ConfigurationException("init inteceptor failed:" + interceptorClassName, (Throwable)e);
                        }
                        interceptorDefMap.put(interceptorDef.getName(), interceptorDef);
                    }
                }
                if (CollectionUtils.isEmpty(venusServerConfig.getExportServices())) {
                    throw new VenusConfigException("not found service config.");
                }
                for (ExportService exportService : venusServerConfig.getExportServices()) {
                    String[] inters;
                    String serviceInterfaceName = exportService.getType();
                    if (serviceInterfaceName == null) {
                        throw new VenusConfigException("Service type can not be null:" + configFile);
                    }
                    Class<?> serviceInterface = null;
                    try {
                        serviceInterface = Class.forName(serviceInterfaceName);
                        exportService.setServiceInterface(serviceInterface);
                    }
                    catch (ClassNotFoundException e) {
                        throw new VenusConfigException("service interface class not found:" + serviceInterfaceName);
                    }
                    String refBeanName = exportService.getRef();
                    try {
                        Object refBean = this.beanFactory.getBean(refBeanName);
                        exportService.setActive(true);
                        exportService.setInstance(refBean);
                        exportBeanMap.put(serviceInterfaceName, refBean.getClass() + "@" + refBean.hashCode());
                    }
                    catch (BeansException e) {
                        throw new ConfigurationException("ref bean not found:" + refBeanName, (Throwable)e);
                    }
                    com.meidusa.venus.annotations.Service serviceAnno = serviceInterface.getAnnotation(com.meidusa.venus.annotations.Service.class);
                    if (serviceAnno == null) {
                        throw new VenusConfigException(String.format("service %s service annotation not declare", serviceInterface.getName()));
                    }
                    String serviceName = serviceAnno.name();
                    if (StringUtils.isEmpty((String)serviceName)) {
                        serviceName = serviceInterface.getCanonicalName();
                    }
                    exportService.setServiceName(serviceName);
                    exportService.setVersion(serviceAnno.version());
                    exportService.setAthenaFlag(serviceAnno.athenaFlag());
                    exportService.setDescription(serviceAnno.description());
                    String interceptors = exportService.getInterceptors();
                    if (!StringUtils.isNotEmpty((String)interceptors) || (inters = interceptors.trim().split(",")) == null || inters.length <= 0) continue;
                    ArrayList<Interceptor> interceptorList = new ArrayList<Interceptor>();
                    for (String inter : inters) {
                        if (interceptorDefMap.get(inter) == null) {
                            throw new VenusConfigException("interceptor:" + inter + " not defined.");
                        }
                        InterceptorDef interceptorDef = (InterceptorDef)interceptorDefMap.get(inter);
                        interceptorList.add(interceptorDef.getInterceptor());
                    }
                    exportService.setInterceptorList(interceptorList);
                }
                allExportServiceList.addAll(venusServerConfig.getExportServices());
            }
            catch (Exception e) {
                throw new ConfigurationException("parser venus server config failed:" + configFile.getFilename(), (Throwable)e);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("##########export beans###########:\n{}.", (Object)JSON.toJSONString(exportBeanMap, (boolean)true));
        }
        return allVenusServerConfig;
    }

    void initSerivce(ExportService exportService) {
        block3: {
            Service service = this.initServiceStub(exportService);
            if (this.isNeedRegiste(exportService)) {
                try {
                    this.registeService(exportService, service);
                }
                catch (Exception e) {
                    if (!exceptionLogger.isErrorEnabled()) break block3;
                    exceptionLogger.error("registe service failed,will retry.", (Throwable)e);
                }
            }
        }
    }

    protected Service initServiceStub(ExportService exportService) {
        if (logger.isInfoEnabled()) {
            logger.info("init service stub:{}.", (Object)exportService.getServiceInterface().getName());
        }
        SingletonService service = new SingletonService();
        service.setType(exportService.getServiceInterface());
        service.setInstance(exportService.getInstance());
        Class<?> serviceInterface = exportService.getServiceInterface();
        serviceInterface.cast(exportService.getInstance());
        service.setName(exportService.getServiceName());
        service.setVersion(exportService.getVersion());
        service.setSupportVersionRange(exportService.getSupportVersionRange());
        service.setAthenaFlag(exportService.isAthenaFlag());
        service.setDescription(exportService.getDescription());
        service.setActive(exportService.isActive());
        Method[] methods = service.getType().getMethods();
        Multimap<String, Endpoint> endpoints = this.initEndpoinits(service, methods, exportService);
        service.setEndpoints(endpoints);
        this.serviceMap.put(exportService.getServiceName(), service);
        return service;
    }

    boolean isNeedRegiste(ExportService exportService) {
        return this.venusRegistryFactory != null && this.venusRegistryFactory.getRegister() != null;
    }

    void registeService(ExportService exportService, Service service) {
        String endpointNames;
        String appName = this.venusApplication.getName();
        String serviceInterfaceName = exportService.getServiceInterface().getName();
        String serviceName = exportService.getServiceName();
        int version = exportService.getVersion();
        String host = NetUtil.getLocalIp();
        String port = String.valueOf(this.venusProtocol.getPort());
        StringBuffer buf = new StringBuffer();
        buf.append("/").append(serviceInterfaceName);
        buf.append("/").append(serviceName);
        buf.append("?version=").append(String.valueOf(version));
        buf.append("&application=").append(appName);
        buf.append("&host=").append(host);
        buf.append("&port=").append(port);
        String methodsDef = this.getMethodsDefOfService(service);
        if (StringUtils.isNotEmpty((String)methodsDef)) {
            buf.append("&methods=").append(methodsDef);
        }
        if (StringUtils.isNotEmpty((String)(endpointNames = this.getEndpointMethodsDefOfService(service)))) {
            buf.append("&endpoints=").append(endpointNames);
        }
        if (exportService.getSupportVersionRange() != null) {
            buf.append("&versionRange=").append(exportService.getSupportVersionRange().toString());
        }
        String registerUrl = buf.toString();
        URL url = URL.parse((String)registerUrl);
        this.venusRegistryFactory.getRegister().registe(url);
    }

    public void destroy() throws Exception {
        Register register;
        if (this.venusRegistryFactory != null && this.venusRegistryFactory.getRegister() != null && (register = this.venusRegistryFactory.getRegister()) != null) {
            register.destroy();
        }
    }

    String getMethodsDefOfService(Service service) {
        StringBuffer buf = new StringBuffer();
        Multimap<String, Endpoint> endpointMultimap = service.getEndpoints();
        Collection endpoints = endpointMultimap.values();
        if (CollectionUtils.isNotEmpty((Collection)endpoints)) {
            int i = 0;
            for (Endpoint endpoint : endpoints) {
                String methodDef = this.getMethodDefOfEndpoint(endpoint);
                buf.append(methodDef);
                if (i < endpoints.size() - 1) {
                    buf.append(";");
                }
                ++i;
            }
        }
        String methodsDef = buf.toString();
        return methodsDef;
    }

    String getMethodDefOfEndpoint(Endpoint endpoint) {
        StringBuffer buf = new StringBuffer();
        buf.append(endpoint.getMethod().getName());
        buf.append("[");
        Class<?>[] paramClzArr = endpoint.getMethod().getParameterTypes();
        if (paramClzArr != null && paramClzArr.length > 0) {
            int i = 0;
            for (Class<?> paramClz : paramClzArr) {
                buf.append(paramClz.getName());
                if (i < paramClzArr.length - 1) {
                    buf.append(",");
                }
                ++i;
            }
        }
        buf.append("]");
        return buf.toString();
    }

    String getEndpointMethodsDefOfService(Service service) {
        StringBuffer buf = new StringBuffer();
        Multimap<String, Endpoint> endpointMultimap = service.getEndpoints();
        Collection endpoints = endpointMultimap.values();
        if (CollectionUtils.isNotEmpty((Collection)endpoints)) {
            int i = 0;
            for (Endpoint endpoint : endpoints) {
                String endpointName = endpoint.getName();
                buf.append(endpointName);
                if (i < endpoints.size() - 1) {
                    buf.append(";");
                }
                ++i;
            }
        }
        String methodsDef = buf.toString();
        return methodsDef;
    }

    Multimap<String, Endpoint> initEndpoinits(Service service, Method[] methods, ExportService exportService) {
        HashMultimap endpointMultimap = HashMultimap.create();
        for (Method method : methods) {
            if (!method.isAnnotationPresent(com.meidusa.venus.annotations.Endpoint.class)) continue;
            Endpoint endpoint = this.initEndpoint(method);
            if (CollectionUtils.isNotEmpty(exportService.getInterceptorList())) {
                endpoint.setInterceptorList(exportService.getInterceptorList());
            }
            endpoint.setService(service);
            endpointMultimap.put((Object)endpoint.getName(), (Object)endpoint);
        }
        return endpointMultimap;
    }

    public VenusProtocol getVenusProtocol() {
        return this.venusProtocol;
    }

    public void setVenusProtocol(VenusProtocol venusProtocol) {
        this.venusProtocol = venusProtocol;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public VenusRegistryFactory getVenusRegistryFactory() {
        return this.venusRegistryFactory;
    }

    public void setVenusRegistryFactory(VenusRegistryFactory venusRegistryFactory) {
        this.venusRegistryFactory = venusRegistryFactory;
    }

    public VenusApplication getVenusApplication() {
        return this.venusApplication;
    }

    public void setVenusApplication(VenusApplication venusApplication) {
        this.venusApplication = venusApplication;
    }

    public VenusMonitorFactory getVenusMonitorFactory() {
        return this.venusMonitorFactory;
    }

    public void setVenusMonitorFactory(VenusMonitorFactory venusMonitorFactory) {
        this.venusMonitorFactory = venusMonitorFactory;
    }
}

