/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.invoker;

import com.meidusa.venus.Filter;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Invoker;
import com.meidusa.venus.Result;
import com.meidusa.venus.URL;
import com.meidusa.venus.VenusApplication;
import com.meidusa.venus.backend.filter.valid.ServerValidFilter;
import com.meidusa.venus.backend.invoker.VenusServerInvoker;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.monitor.VenusMonitorFactory;
import com.meidusa.venus.monitor.athena.filter.ServerAthenaMonitorFilter;
import com.meidusa.venus.monitor.filter.ServerVenusMonitorFilter;
import com.meidusa.venus.support.VenusThreadContext;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class VenusServerInvokerProxy
implements Invoker {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private VenusServerInvoker venusServerInvoker = new VenusServerInvoker();
    private List<Filter> beforeFilters = new ArrayList<Filter>();
    private List<Filter> throwFilters = new ArrayList<Filter>();
    private List<Filter> afterFilters = new ArrayList<Filter>();
    private ServerValidFilter serverValidFilter = new ServerValidFilter();
    private static ServerVenusMonitorFilter serverVenusMonitorFilter = null;
    private ServerAthenaMonitorFilter serverAthenaMonitorFilter = null;

    public VenusServerInvokerProxy() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws RpcException {
        VenusServerInvokerProxy venusServerInvokerProxy = this;
        synchronized (venusServerInvokerProxy) {
            VenusApplication venusApplication = VenusApplication.getInstance();
            if (venusApplication != null && venusApplication.isEnableFilter()) {
                this.initFilters();
            } else {
                logger.warn("venus application is undefined or disabled filters,will disable filters.");
            }
        }
    }

    public Result invoke(Invocation invocation, URL url) throws RpcException {
        Result result = null;
        try {
            for (Filter filter : this.getBeforeFilters()) {
                result = filter.beforeInvoke(invocation, null);
                if (result == null) continue;
                VenusThreadContext.set((String)"responseResult", (Object)result);
                Result result2 = result;
                return result2;
            }
            result = this.venusServerInvoker.invoke(invocation, url);
            VenusThreadContext.set((String)"responseResult", (Object)result);
            Result result3 = result;
            return result3;
        }
        catch (Throwable e) {
            VenusThreadContext.set((String)"responseException", (Object)e);
            for (Filter filter : this.getThrowFilters()) {
                result = filter.throwInvoke(invocation, null, e);
                if (result == null) continue;
                VenusThreadContext.set((String)"responseResult", (Object)result);
                Result result4 = result;
                return result4;
            }
            throw e;
        }
        finally {
            for (Filter filter : this.getAfterFilters()) {
                filter.afterInvoke(invocation, url);
            }
        }
    }

    void initFilters() {
        this.initMonitorFilters();
        this.addBeforeFilters();
        this.addThrowFilters();
        this.addAfterFilters();
    }

    void initMonitorFilters() {
        VenusMonitorFactory venusMonitorFactory = VenusMonitorFactory.getInstance();
        if (venusMonitorFactory != null) {
            if (venusMonitorFactory.isEnableVenusReport()) {
                if (serverVenusMonitorFilter == null) {
                    try {
                        serverVenusMonitorFilter = new ServerVenusMonitorFilter();
                        serverVenusMonitorFilter.init();
                    }
                    catch (Exception e) {
                        logger.warn("###########init venus monitor failed,will disabled venus report.", (Throwable)e);
                    }
                }
            } else if (logger.isWarnEnabled()) {
                logger.warn("############not enable venus report,venus monitor filter diabled##############");
            }
            if (venusMonitorFactory.isEnableAthenaReport()) {
                try {
                    this.serverAthenaMonitorFilter = new ServerAthenaMonitorFilter();
                    this.serverAthenaMonitorFilter.init();
                }
                catch (Throwable e) {
                    logger.warn("#############init athena monitor failed,will disabled athena report.", e);
                }
            } else if (logger.isWarnEnabled()) {
                logger.warn("############not enable athena report,athena monitor filter diabled##############");
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn("############not enable monitor report,vensu and athena monitor filter diabled##############");
        }
    }

    void addBeforeFilters() {
        this.beforeFilters.add(this.serverValidFilter);
        if (serverVenusMonitorFilter != null) {
            this.beforeFilters.add((Filter)serverVenusMonitorFilter);
        }
        if (this.serverAthenaMonitorFilter != null) {
            this.beforeFilters.add((Filter)this.serverAthenaMonitorFilter);
        }
    }

    void addThrowFilters() {
        if (serverVenusMonitorFilter != null) {
            this.throwFilters.add((Filter)serverVenusMonitorFilter);
        }
        if (this.serverAthenaMonitorFilter != null) {
            this.throwFilters.add((Filter)this.serverAthenaMonitorFilter);
        }
    }

    void addAfterFilters() {
        if (serverVenusMonitorFilter != null) {
            this.afterFilters.add((Filter)serverVenusMonitorFilter);
        }
        if (this.serverAthenaMonitorFilter != null) {
            this.afterFilters.add((Filter)this.serverAthenaMonitorFilter);
        }
    }

    public List<Filter> getBeforeFilters() {
        return this.beforeFilters;
    }

    public List<Filter> getThrowFilters() {
        return this.throwFilters;
    }

    public List<Filter> getAfterFilters() {
        return this.afterFilters;
    }

    public void destroy() throws RpcException {
    }
}

