/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.invoker;

import com.meidusa.fastmark.feature.SerializerFeature;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Invoker;
import com.meidusa.venus.Result;
import com.meidusa.venus.URL;
import com.meidusa.venus.backend.ServerInvocation;
import com.meidusa.venus.backend.context.RequestContext;
import com.meidusa.venus.backend.invoker.VenusServerInvocationEndpoint;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.backend.services.ServiceManager;
import com.meidusa.venus.backend.support.UtilTimerStack;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.io.support.VenusStatus;
import com.meidusa.venus.util.ThreadLocalMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VenusServerInvoker
implements Invoker {
    private static Logger logger = LoggerFactory.getLogger(VenusServerInvoker.class);
    private static String ENDPOINT_INVOKED_TIME = "invoked Total Time: ";
    private static SerializerFeature[] JSON_FEATURE = new SerializerFeature[]{SerializerFeature.ShortString, SerializerFeature.IgnoreNonFieldGetter, SerializerFeature.SkipTransientField};
    private ServiceManager serviceManager;

    public void init() throws RpcException {
    }

    public Result invoke(Invocation invocation, URL url) throws RpcException {
        ServerInvocation serverInvocation = (ServerInvocation)invocation;
        Endpoint endpointDef = serverInvocation.getEndpointDef();
        RequestContext requestContext = serverInvocation.getRequestContext();
        try {
            UtilTimerStack.push(ENDPOINT_INVOKED_TIME);
            VenusServerInvocationEndpoint invocationEndpoint = new VenusServerInvocationEndpoint(requestContext, endpointDef);
            Object result = invocationEndpoint.invoke();
            Result result2 = new Result(result);
            return result2;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            if (e instanceof OutOfMemoryError) {
                VenusStatus.getInstance().setStatus((byte)4);
            }
            throw e;
        }
        finally {
            ThreadLocalMap.remove((Object)"_REQUEST_CONTEXT_");
            ThreadLocalMap.remove((Object)"REQUEST_TRACE_ID");
            UtilTimerStack.pop(ENDPOINT_INVOKED_TIME);
        }
    }

    public void destroy() throws RpcException {
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }
}

