/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.invoker;

import com.meidusa.venus.Result;
import com.meidusa.venus.backend.ServerInvocation;
import com.meidusa.venus.backend.support.ServerResponseHandler;
import com.meidusa.venus.backend.support.ServerResponseWrapper;
import com.meidusa.venus.io.network.VenusFrontendConnection;
import com.meidusa.venus.io.packet.VenusRouterPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceRequestPacket;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.notify.ReferenceInvocationListener;
import com.meidusa.venus.util.VenusLoggerFactory;
import org.slf4j.Logger;

public class VenusServerInvocationListener<T>
implements InvocationListener<T> {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private static Logger tracerLogger = VenusLoggerFactory.getTracerLogger();
    private VenusFrontendConnection conn;
    private VenusRouterPacket routerPacket;
    private ReferenceInvocationListener<T> source;
    private SerializeServiceRequestPacket request;
    private ServerInvocation invocation;
    private boolean isResponsed = false;
    private ServerResponseHandler responseHandler;

    public boolean isResponsed() {
        return this.isResponsed;
    }

    public VenusServerInvocationListener(VenusFrontendConnection conn, ReferenceInvocationListener<T> source, SerializeServiceRequestPacket request, VenusRouterPacket routerPacket, ServerInvocation invocation) {
        this.conn = conn;
        this.source = source;
        this.request = request;
        this.routerPacket = routerPacket;
        this.invocation = invocation;
    }

    public void callback(T object) {
        block3: {
            Result result = new Result(object);
            ServerResponseWrapper responseEntityWrapper = ServerResponseWrapper.parse(this.invocation, result, false);
            try {
                if (tracerLogger.isInfoEnabled()) {
                    tracerLogger.info("send notify response,rpcId:{}.", (Object)this.invocation.getRpcId());
                }
                this.responseHandler.writeResponseForNotify(responseEntityWrapper);
            }
            catch (Exception e) {
                if (!exceptionLogger.isErrorEnabled()) break block3;
                exceptionLogger.error("send notify response error.", (Throwable)e);
            }
        }
    }

    public void onException(Exception e) {
        block3: {
            Result result = new Result();
            result.setException((Throwable)e);
            ServerResponseWrapper responseEntityWrapper = ServerResponseWrapper.parse(this.invocation, result, false);
            try {
                if (tracerLogger.isInfoEnabled()) {
                    tracerLogger.info("send notify response,rpcId:{}.", (Object)this.invocation.getRpcId());
                }
                this.responseHandler.writeResponseForNotify(responseEntityWrapper);
            }
            catch (Exception ex) {
                if (!exceptionLogger.isErrorEnabled()) break block3;
                exceptionLogger.error("send notify response error.", (Throwable)ex);
            }
        }
    }

    public ServerResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public void setResponseHandler(ServerResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }
}

