/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.invoker;

import com.meidusa.venus.backend.context.RequestContext;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.backend.services.EndpointInvocation;
import com.meidusa.venus.backend.services.Interceptor;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

public class VenusServerInvocationEndpoint
implements EndpointInvocation {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    protected Iterator<Interceptor> interceptors;
    private boolean executed;
    private Object result;
    private Endpoint endpoint;
    private RequestContext context;
    private EndpointInvocation.ResultType type = EndpointInvocation.ResultType.RESPONSE;

    public VenusServerInvocationEndpoint(RequestContext context, Endpoint endpoint) {
        this.endpoint = endpoint;
        this.context = context;
        if (CollectionUtils.isNotEmpty(endpoint.getInterceptorList())) {
            this.interceptors = endpoint.getInterceptorList().iterator();
        }
    }

    @Override
    public RequestContext getContext() {
        return this.context;
    }

    public EndpointInvocation.ResultType getType() {
        return this.type;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public Object invoke() {
        if (this.interceptors != null && this.interceptors.hasNext()) {
            Interceptor interceptor = this.interceptors.next();
            this.result = interceptor.intercept(this);
        } else {
            try {
                Object[] parameters = this.getContext().getEndPointer().getParameterValues(this.getContext().getParameters());
                Endpoint ep = this.getEndpoint();
                if (ep.isAsync()) {
                    this.type = EndpointInvocation.ResultType.NONE;
                }
                for (Object object : parameters) {
                    if (!(object instanceof InvocationListener)) continue;
                    this.type = EndpointInvocation.ResultType.NOTIFY;
                }
                this.result = ep.getMethod().invoke(ep.getService().getInstance(), parameters);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new RpcException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    throw new RpcException(e.getTargetException());
                }
                throw new RpcException((Throwable)e);
            }
        }
        return this.result;
    }

    @Override
    public boolean isExecuted() {
        return this.executed;
    }
}

