/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.handler;

import com.meidusa.toolkit.common.bean.util.Initialisable;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.MessageHandler;
import com.meidusa.toolkit.net.packet.AbstractPacketBuffer;
import com.meidusa.toolkit.net.util.InetAddressUtil;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Result;
import com.meidusa.venus.backend.ServerInvocation;
import com.meidusa.venus.backend.context.RequestContext;
import com.meidusa.venus.backend.invoker.VenusServerInvocationListener;
import com.meidusa.venus.backend.invoker.VenusServerInvokerProxy;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.backend.services.EndpointInvocation;
import com.meidusa.venus.backend.services.RequestInfo;
import com.meidusa.venus.backend.services.Service;
import com.meidusa.venus.backend.services.ServiceManager;
import com.meidusa.venus.backend.support.ServerRequestHandler;
import com.meidusa.venus.backend.support.ServerResponseHandler;
import com.meidusa.venus.backend.support.ServerResponseWrapper;
import com.meidusa.venus.exception.CodedException;
import com.meidusa.venus.exception.DefaultVenusException;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.exception.ServiceNotFoundException;
import com.meidusa.venus.exception.XmlVenusExceptionFactory;
import com.meidusa.venus.io.handler.Venus4FrontendMessageHandler;
import com.meidusa.venus.io.network.VenusFrontendConnection;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.ServiceAPIPacket;
import com.meidusa.venus.io.packet.ServicePacketBuffer;
import com.meidusa.venus.io.packet.VenusRouterPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceRequestPacket;
import com.meidusa.venus.io.serializer.Serializer;
import com.meidusa.venus.io.serializer.SerializerFactory;
import com.meidusa.venus.io.utils.RpcIdUtil;
import com.meidusa.venus.notify.InvocationListener;
import com.meidusa.venus.notify.ReferenceInvocationListener;
import com.meidusa.venus.support.VenusContext;
import com.meidusa.venus.support.VenusUtil;
import com.meidusa.venus.util.JSONUtil;
import com.meidusa.venus.util.NetUtil;
import com.meidusa.venus.util.ThreadLocalMap;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class VenusServerReceiveMessageHandler
extends Venus4FrontendMessageHandler
implements MessageHandler<VenusFrontendConnection, Tuple<Long, byte[]>>,
Initialisable {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private static Logger tracerLogger = VenusLoggerFactory.getTracerLogger();
    private ServiceManager serviceManager;
    private ServerResponseHandler responseHandler = new ServerResponseHandler();
    private VenusServerInvokerProxy venusServerInvokerProxy = new VenusServerInvokerProxy();

    public void init() throws InitialisationException {
    }

    public void handle(VenusFrontendConnection conn, Tuple<Long, byte[]> data) {
        ServerInvocation invocation = this.parseInvocation(conn, data);
        int type = invocation.getMessageType();
        switch (type) {
            case 0x1000001: {
                super.handle(conn, data);
                break;
            }
            case 0x1000002: {
                super.handle(conn, data);
                break;
            }
            case 0x5000001: {
                super.handle(conn, data);
                break;
            }
            case 0x2000001: {
                this.doHandle(invocation);
                break;
            }
            default: {
                super.handle(conn, data);
            }
        }
    }

    boolean isNeedPrintLog(Connection conn) {
        String targetIp;
        return conn != null && conn instanceof VenusFrontendConnection && (targetIp = this.getTargetAddress((VenusFrontendConnection)conn)).contains("10.47.16.8");
    }

    String getTargetAddress(VenusFrontendConnection frontendConnection) {
        StringBuilder builder = new StringBuilder();
        builder.append(frontendConnection.getHost());
        builder.append(":");
        builder.append(frontendConnection.getPort());
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doHandle(ServerInvocation invocation) {
        block24: {
            long bTime = System.currentTimeMillis();
            Result result = null;
            try {
                this.parseApiRequest(invocation);
                boolean isIgnoreLog = false;
                if (StringUtils.isNotEmpty((String)invocation.getApiName()) && invocation.getApiName().contains("ServiceRegistry")) {
                    isIgnoreLog = true;
                }
                String tpl = "[P] recv request,rpcId:{},api:{},sourceIp:{},routeIp:{},message size:{}.";
                Object[] arguments = new Object[]{invocation.getRpcId(), invocation.getApiName(), invocation.getSourceIp(), invocation.getRouteIp(), ((byte[])invocation.getData().getRight()).length};
                if (!isIgnoreLog) {
                    if (tracerLogger.isInfoEnabled()) {
                        tracerLogger.info(tpl, arguments);
                    }
                } else if (logger.isInfoEnabled()) {
                    logger.info(tpl, arguments);
                }
                this.parseEndpointAndRequest(invocation);
                this.parseParamsAndListener(invocation);
                result = this.getVenusServerInvokerProxy().invoke((Invocation)invocation, null);
            }
            catch (Throwable e) {
                result = this.buildResultFromException(e);
            }
            finally {
                try {
                    this.printTracerLogger(invocation, result, bTime);
                }
                catch (Exception isIgnoreLog) {}
            }
            try {
                ServerResponseWrapper responseWrapper = ServerResponseWrapper.parse(invocation, result, false);
                if (invocation.getResultType() == EndpointInvocation.ResultType.RESPONSE) {
                    this.responseHandler.writeResponseForResponse(responseWrapper);
                } else if (invocation.getResultType() == EndpointInvocation.ResultType.OK) {
                    this.responseHandler.writeResponseForOk(responseWrapper);
                } else if (invocation.getResultType() == EndpointInvocation.ResultType.NOTIFY && result.getErrorCode() != 0) {
                    this.responseHandler.writeResponseForNotify(responseWrapper);
                }
            }
            catch (Throwable t) {
                if (!exceptionLogger.isErrorEnabled()) break block24;
                exceptionLogger.error("send response error.", t);
            }
        }
    }

    ServerInvocation parseInvocation(VenusFrontendConnection conn, Tuple<Long, byte[]> data) {
        byte[] message = (byte[])data.right;
        int type = AbstractServicePacket.getType((byte[])message);
        byte serializeType = conn.getSerializeType();
        String sourceIp = conn.getHost();
        String routeIp = "";
        VenusRouterPacket routerPacket = null;
        if (0x8000001 == type) {
            routerPacket = new VenusRouterPacket();
            routerPacket.original = message;
            routerPacket.init(message);
            message = routerPacket.data;
            type = AbstractServicePacket.getType((byte[])routerPacket.data);
            serializeType = routerPacket.serializeType;
            routeIp = sourceIp;
            sourceIp = InetAddressUtil.intToAddress((int)routerPacket.srcIP);
        }
        ServerInvocation invocation = new ServerInvocation();
        invocation.setMessage(message);
        invocation.setMessageType(type);
        invocation.setRouterPacket(routerPacket);
        invocation.setSerializeType(serializeType);
        invocation.setSourceIp(sourceIp);
        invocation.setRouteIp(routeIp);
        invocation.setConn(conn);
        invocation.setData(data);
        invocation.setClientId(conn.getClientId());
        invocation.setHost(conn.getHost());
        invocation.setLocalHost(conn.getLocalHost());
        invocation.setRequestTime(new Date());
        String providerApp = VenusContext.getInstance().getApplication();
        String providerIp = NetUtil.getLocalIp();
        String consumerIp = conn.getHost();
        invocation.setProviderApp(providerApp);
        invocation.setProviderIp(providerIp);
        invocation.setConsumerIp(consumerIp);
        invocation.setResultType(EndpointInvocation.ResultType.RESPONSE);
        return invocation;
    }

    void parseApiRequest(ServerInvocation invocation) {
        ServiceAPIPacket apiPacket = new ServiceAPIPacket();
        ServicePacketBuffer packetBuffer = new ServicePacketBuffer(invocation.getMessage());
        apiPacket.init((AbstractPacketBuffer)packetBuffer);
        invocation.setApiPacket(apiPacket);
        invocation.setApiName(apiPacket.apiName);
        invocation.setPacketBuffer(packetBuffer);
        String rpcId = RpcIdUtil.getRpcId((AbstractServicePacket)apiPacket);
        invocation.setRpcId(rpcId);
    }

    void parseEndpointAndRequest(ServerInvocation invocation) {
        byte serializeType = invocation.getSerializeType();
        ServiceAPIPacket apiPacket = invocation.getApiPacket();
        ServicePacketBuffer packetBuffer = invocation.getPacketBuffer();
        Endpoint endpoint = this.getServiceManager().getEndpoint(apiPacket.apiName);
        invocation.setEndpointDef(endpoint);
        Service service = endpoint.getService();
        invocation.setServiceInterface(service.getType());
        invocation.setMethod(endpoint.getMethod());
        invocation.setResultType(this.getResultType(endpoint));
        Serializer serializer = SerializerFactory.getSerializer((short)serializeType);
        SerializeServiceRequestPacket serviceRequestPacket = new SerializeServiceRequestPacket(serializer, endpoint.getParameterTypeDict());
        packetBuffer.setPosition(0);
        serviceRequestPacket.init((AbstractPacketBuffer)packetBuffer);
        invocation.setServiceRequestPacket(serviceRequestPacket);
    }

    void parseParamsAndListener(ServerInvocation invocation) {
        Endpoint endpoint = invocation.getEndpointDef();
        VenusRouterPacket routerPacket = invocation.getRouterPacket();
        SerializeServiceRequestPacket serviceRequestPacket = invocation.getServiceRequestPacket();
        if (MapUtils.isNotEmpty((Map)serviceRequestPacket.parameterMap)) {
            Object[] args = serviceRequestPacket.parameterMap.values().toArray();
            invocation.setArgs(args);
            if (args != null && args.length > 0) {
                for (Object arg : args) {
                    if (!(arg instanceof ReferenceInvocationListener)) continue;
                    invocation.setInvocationListener((InvocationListener)((ReferenceInvocationListener)arg));
                }
            }
        }
        this.initParamsForInvocationListener(serviceRequestPacket, invocation.getConn(), routerPacket, invocation);
        RequestContext requestContext = this.getRequestContext(invocation);
        if (requestContext != null) {
            requestContext.setEndPointer(endpoint);
        }
        invocation.setRequestContext(requestContext);
        ThreadLocalMap.put((Object)"_REQUEST_CONTEXT_", (Object)requestContext);
        if (requestContext.getRootId() != null) {
            invocation.setAthenaId(requestContext.getRootId().getBytes());
        }
        if (requestContext.getParentId() != null) {
            invocation.setParentId(requestContext.getParentId().getBytes());
        }
        if (requestContext.getMessageId() != null) {
            invocation.setMessageId(requestContext.getMessageId().getBytes());
        }
    }

    void initParamsForInvocationListener(SerializeServiceRequestPacket request, VenusFrontendConnection conn, VenusRouterPacket routerPacket, ServerInvocation invocation) {
        for (Map.Entry entry : request.parameterMap.entrySet()) {
            if (!(entry.getValue() instanceof ReferenceInvocationListener)) continue;
            VenusServerInvocationListener invocationListener = new VenusServerInvocationListener(conn, (ReferenceInvocationListener)entry.getValue(), request, routerPacket, invocation);
            invocationListener.setResponseHandler(this.responseHandler);
            request.parameterMap.put(entry.getKey(), invocationListener);
        }
    }

    EndpointInvocation.ResultType getResultType(Endpoint endpoint) {
        EndpointInvocation.ResultType resultType = EndpointInvocation.ResultType.RESPONSE;
        if (endpoint.isVoid()) {
            resultType = EndpointInvocation.ResultType.OK;
            if (endpoint.isAsync()) {
                resultType = EndpointInvocation.ResultType.NONE;
            }
            for (Class<?> clazz : endpoint.getMethod().getParameterTypes()) {
                if (!InvocationListener.class.isAssignableFrom(clazz)) continue;
                resultType = EndpointInvocation.ResultType.NOTIFY;
                break;
            }
        }
        return resultType;
    }

    RequestContext getRequestContext(ServerInvocation invocation) {
        byte packetSerializeType = invocation.getPacketSerializeType();
        Endpoint endpoint = invocation.getEndpointDef();
        VenusRouterPacket routerPacket = invocation.getRouterPacket();
        SerializeServiceRequestPacket serviceRequestPacket = invocation.getServiceRequestPacket();
        ServerRequestHandler requestHandler = new ServerRequestHandler();
        RequestInfo requestInfo = requestHandler.getRequestInfo(packetSerializeType, routerPacket, invocation);
        RequestContext requestContext = requestHandler.createContext(requestInfo, endpoint, serviceRequestPacket);
        return requestContext;
    }

    Result buildResultFromException(Throwable e) {
        Result result = new Result();
        Throwable ex = this.processRpcException(e);
        if (ex instanceof CodedException) {
            CodedException cex = (CodedException)ex;
            result.setErrorCode(cex.getErrorCode());
            result.setErrorMessage(cex.getMessage());
            result.setException(ex);
        } else {
            int errorCode = XmlVenusExceptionFactory.getInstance().getErrorCode(ex.getClass());
            if (errorCode != 0) {
                result.setErrorCode(errorCode);
                result.setErrorMessage(ex.getMessage());
                result.setException(ex);
            } else {
                DefaultVenusException dex = new DefaultVenusException(18005000, ex.getMessage(), ex);
                result.setErrorCode(18005000);
                result.setErrorMessage(dex.getMessage());
                result.setException((Throwable)dex);
            }
        }
        return result;
    }

    Throwable processRpcException(Throwable e) {
        if (e instanceof RpcException) {
            RpcException re = (RpcException)e;
            if (re.getCause() != null) {
                return re.getCause();
            }
            DefaultVenusException de = new DefaultVenusException(re.getErrorCode(), re.getMessage());
            return de;
        }
        return e;
    }

    void printTracerLogger(ServerInvocation invocation, Result result, long bTime) {
        String tpl;
        boolean hasException = false;
        boolean isIgnoreException = false;
        long usedTime = System.currentTimeMillis() - bTime;
        String rpcId = invocation.getRpcId();
        String apiName = invocation.getApiName();
        String methodPath = invocation.getMethodPath();
        String param = "{}";
        if (invocation.isEnablePrintParam() && !VenusUtil.isAthenaInterface((Invocation)invocation) && invocation.getArgs() != null) {
            param = JSONUtil.toJSONString((Object)invocation.getArgs());
        }
        String ret = "{}";
        if (invocation.isEnablePrintResult() && !VenusUtil.isAthenaInterface((Invocation)invocation) && result.getErrorCode() == 0 && result.getException() == null && result.getResult() != null) {
            ret = JSONUtil.toJSONString((Object)result.getResult());
        }
        Object error = "{}";
        if (invocation.isEnablePrintResult() && !VenusUtil.isAthenaInterface((Invocation)invocation)) {
            if (result.getException() != null) {
                ServiceNotFoundException serviceNotFoundException;
                String errorMsg;
                hasException = true;
                error = result.getException();
                if (error != null && error instanceof ServiceNotFoundException && StringUtils.isNotEmpty((String)(errorMsg = (serviceNotFoundException = (ServiceNotFoundException)error).getMessage())) && errorMsg.contains("ServiceRegistry")) {
                    isIgnoreException = true;
                    error = "invalid request,venus not provide serviceRegistry serivce from V4.";
                }
            } else if (result.getErrorCode() != 0) {
                hasException = true;
                error = String.format("%s-%s", result.getErrorCode(), result.getErrorMessage());
            }
        }
        String status = "";
        status = hasException ? "failed" : (usedTime > 1000L ? ">1000ms" : (usedTime > 500L ? ">500ms" : (usedTime > 200L ? ">200ms" : "<200ms")));
        if (hasException) {
            tpl = "[P] [{},{}],provider handle,rpcId:{},api:{},method:{},param:{},error:{}.";
            Object[] arguments = new Object[]{status, usedTime + "ms", rpcId, apiName, methodPath, param, error};
            if (!isIgnoreException) {
                if (tracerLogger.isErrorEnabled()) {
                    tracerLogger.error(tpl, arguments);
                }
                if (exceptionLogger.isErrorEnabled()) {
                    exceptionLogger.error(tpl, arguments);
                }
            } else if (logger.isWarnEnabled()) {
                logger.warn(tpl, arguments);
            }
        } else {
            tpl = "[P] [{},{}],provider handle,rpcId:{},api:{},method:{},param:{},result:{}.";
            Object[] arguments = new Object[]{status, usedTime + "ms", rpcId, apiName, methodPath, param, ret};
            if (usedTime > 200L) {
                if (tracerLogger.isWarnEnabled()) {
                    tracerLogger.warn(tpl, arguments);
                }
            } else if (tracerLogger.isInfoEnabled()) {
                tracerLogger.info(tpl, arguments);
            }
        }
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    VenusServerInvokerProxy getVenusServerInvokerProxy() {
        return this.venusServerInvokerProxy;
    }
}

