/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.handler;

import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.ConnectionObserver;
import com.meidusa.toolkit.net.FrontendConnection;
import com.meidusa.venus.util.VenusLoggerFactory;
import org.slf4j.Logger;

public class VenusServerConnectionObserver
implements ConnectionObserver {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private static final String ONE_IP = "10.47.16.2";

    public void connectionEstablished(Connection conn) {
        if (logger.isDebugEnabled()) {
            if (conn != null && conn instanceof FrontendConnection) {
                logger.info("connection established,target:[{}].", (Object)this.getTargetAddress((FrontendConnection)conn));
            } else {
                logger.info("connection established,conn:{}.", (Object)conn);
            }
        }
    }

    public void connectionFailed(Connection conn, Exception fault) {
        if (exceptionLogger.isErrorEnabled()) {
            if (conn != null && conn instanceof FrontendConnection) {
                exceptionLogger.error("connection failed,target:[{}],fault:{}.", (Object)this.getTargetAddress((FrontendConnection)conn), (Object)fault);
            } else {
                exceptionLogger.error("connection failed,conn:{},fault:{}.", (Object)conn, (Object)fault);
            }
        }
    }

    public void connectionClosed(Connection conn) {
        if (logger.isDebugEnabled()) {
            if (conn != null && conn instanceof FrontendConnection) {
                logger.warn("connection closed,target:[{}].", (Object)this.getTargetAddress((FrontendConnection)conn));
            } else {
                logger.warn("connection closed,conn:{}.", (Object)conn);
            }
        }
    }

    boolean isNeedPrintLog(Connection conn) {
        String targetIp;
        return conn != null && conn instanceof FrontendConnection && (targetIp = this.getTargetAddress((FrontendConnection)conn)).contains(ONE_IP);
    }

    String getTargetAddress(FrontendConnection frontendConnection) {
        StringBuilder builder = new StringBuilder();
        builder.append(frontendConnection.getHost());
        builder.append(":");
        builder.append(frontendConnection.getPort());
        return builder.toString();
    }
}

