/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.filter.valid;

import com.meidusa.toolkit.common.util.Tuple;
import com.meidusa.venus.Filter;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Result;
import com.meidusa.venus.URL;
import com.meidusa.venus.backend.ServerInvocation;
import com.meidusa.venus.backend.services.Endpoint;
import com.meidusa.venus.backend.services.Service;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.io.packet.AbstractServicePacket;
import com.meidusa.venus.io.packet.AbstractServiceRequestPacket;
import com.meidusa.venus.io.packet.ErrorPacket;
import com.meidusa.venus.io.packet.VenusRouterPacket;
import com.meidusa.venus.io.packet.serialize.SerializeServiceRequestPacket;
import com.meidusa.venus.util.Range;

public class ServerValidFilter
implements Filter {
    private static final String TIMEOUT = "waiting-timeout for execution,api=%s,ip=%s,time=%d (ms)";

    public void init() throws RpcException {
    }

    public Result beforeInvoke(Invocation invocation, URL url) throws RpcException {
        ServerInvocation rpcInvocation = (ServerInvocation)invocation;
        this.valid(rpcInvocation);
        return null;
    }

    public Result throwInvoke(Invocation invocation, URL url, Throwable e) throws RpcException {
        return null;
    }

    public Result afterInvoke(Invocation invocation, URL url) throws RpcException {
        return null;
    }

    public void destroy() throws RpcException {
    }

    void valid(ServerInvocation invocation) {
        Tuple<Long, byte[]> data = invocation.getData();
        byte[] message = invocation.getMessage();
        byte packetSerializeType = invocation.getPacketSerializeType();
        long waitTime = invocation.getWaitTime();
        VenusRouterPacket routerPacket = invocation.getRouterPacket();
        byte serializeType = invocation.getSerializeType();
        SerializeServiceRequestPacket request = invocation.getServiceRequestPacket();
        String apiName = request.apiName;
        Endpoint endpoint = invocation.getEndpointDef();
        this.checkVersion(endpoint, (AbstractServiceRequestPacket)request);
        this.checkActive(endpoint, (AbstractServiceRequestPacket)request);
        this.checkTimeout(endpoint, (AbstractServiceRequestPacket)request, waitTime, invocation);
    }

    void checkTimeout(Endpoint endpoint, AbstractServiceRequestPacket request, long waitTime, ServerInvocation invocation) {
        if (waitTime > (long)endpoint.getTimeWait()) {
            ErrorPacket error = new ErrorPacket();
            AbstractServicePacket.copyHead((AbstractServicePacket)request, (AbstractServicePacket)error);
            error.errorCode = 18005001;
            error.message = String.format(TIMEOUT, request.apiName, invocation.getLocalHost(), waitTime);
            throw new ErrorPacketWrapperException(error);
        }
    }

    void checkActive(Endpoint endpoint, AbstractServiceRequestPacket request) {
        Service service = endpoint.getService();
        if (!service.isActive() || !endpoint.isActive()) {
            ErrorPacket error = new ErrorPacket();
            AbstractServicePacket.copyHead((AbstractServicePacket)request, (AbstractServicePacket)error);
            error.errorCode = 18005006;
            StringBuilder buffer = new StringBuilder();
            buffer.append("Service=").append(endpoint.getService().getName());
            if (!service.isActive()) {
                buffer.append(" is not active");
            }
            if (!endpoint.isActive()) {
                buffer.append(", endpoint=").append(endpoint.getName()).append(" is not active");
            }
            error.message = buffer.toString();
            throw new ErrorPacketWrapperException(error);
        }
    }

    void checkVersion(Endpoint endpoint, AbstractServiceRequestPacket request) {
        Service service = endpoint.getService();
        Range range = service.getSupportVersionRange();
        if (range == null || range.contains(request.serviceVersion)) {
            return;
        }
        ErrorPacket error = new ErrorPacket();
        AbstractServicePacket.copyHead((AbstractServicePacket)request, (AbstractServicePacket)error);
        error.errorCode = 18005007;
        error.message = "Service=" + endpoint.getService().getName() + ",version=" + request.serviceVersion + " not allow";
        throw new ErrorPacketWrapperException(error);
    }

    class ErrorPacketWrapperException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private ErrorPacket errorPacket;

        public ErrorPacketWrapperException() {
        }

        public ErrorPacketWrapperException(String msg) {
            super(msg);
        }

        public ErrorPacketWrapperException(Throwable throwable) {
            super(throwable);
        }

        public ErrorPacketWrapperException(String msg, Throwable throwable) {
            super(msg, throwable);
        }

        public ErrorPacketWrapperException(ErrorPacket errorPacket) {
            super("error packet.");
            this.errorPacket = errorPacket;
        }

        public ErrorPacket getErrorPacket() {
            return this.errorPacket;
        }

        public void setErrorPacket(ErrorPacket errorPacket) {
            this.errorPacket = errorPacket;
        }
    }
}

