/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.filter.mock;

import com.meidusa.venus.Filter;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Result;
import com.meidusa.venus.URL;
import com.meidusa.venus.backend.ServerInvocation;
import com.meidusa.venus.client.filter.mock.ClientReturnMockFilter;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.util.VenusLoggerFactory;
import org.slf4j.Logger;

public class ServerReturnMockFilter
extends ClientReturnMockFilter
implements Filter {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    static final String MOCK_TYPE_RETURN = "MOCK_TYPE_RETURN ";
    static final String MOCK_TYPE_THROW = "MOCK_TYPE_THROW";
    static final String MOCK_TYPE_CALLBACK = "MOCK_TYPE_CALLBACK";

    public void init() throws RpcException {
    }

    public Result beforeInvoke(Invocation invocation, URL url) throws RpcException {
        try {
            ServerInvocation clientInvocation = (ServerInvocation)invocation;
            if (!this.isEnableReturnMock(clientInvocation, url)) {
                return null;
            }
            Object retru = this.getMockReturn(clientInvocation, url);
            return new Result(retru);
        }
        catch (RpcException e) {
            throw e;
        }
        catch (Throwable e) {
            if (exceptionLogger.isErrorEnabled()) {
                exceptionLogger.error("ServerReturnMockFilter.beforeInvoke error.", e);
            }
            return null;
        }
    }

    public Result throwInvoke(Invocation invocation, URL url, Throwable e) throws RpcException {
        return null;
    }

    public Result afterInvoke(Invocation invocation, URL url) throws RpcException {
        return null;
    }

    Object getMockReturn(ServerInvocation invocation, URL url) {
        return "ok";
    }

    boolean isEnableReturnMock(ServerInvocation invocation, URL url) {
        return false;
    }

    public void destroy() throws RpcException {
    }
}

