/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.filter.mock;

import com.meidusa.venus.Filter;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Result;
import com.meidusa.venus.URL;
import com.meidusa.venus.backend.ServerInvocation;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;

public class ServerCallbackMockFilter
implements Filter {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    static final String MOCK_TYPE_RETURN = "MOCK_TYPE_RETURN ";
    static final String MOCK_TYPE_THROW = "MOCK_TYPE_THROW";
    static final String MOCK_TYPE_CALLBACK = "MOCK_TYPE_CALLBACK";

    public void init() throws RpcException {
    }

    public Result beforeInvoke(Invocation invocation, URL url) throws RpcException {
        try {
            ServerInvocation clientInvocation = (ServerInvocation)invocation;
            if (!this.isEnableCallbackMock(clientInvocation, url)) {
                return null;
            }
            Method callbackMethod = null;
            Object instance = null;
            Object[] args = null;
            if (callbackMethod != null) {
                Object retur = callbackMethod.invoke(instance, args);
                return new Result(retur);
            }
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RpcException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new RpcException((Throwable)e);
        }
        catch (Throwable e) {
            if (exceptionLogger.isErrorEnabled()) {
                exceptionLogger.error("ServerCallbackMockFilter.beforeInvoke error.", e);
            }
            return null;
        }
    }

    boolean isEnableCallbackMock(ServerInvocation invocation, URL url) {
        return false;
    }

    public Result throwInvoke(Invocation invocation, URL url, Throwable e) throws RpcException {
        return null;
    }

    public Result afterInvoke(Invocation invocation, URL url) throws RpcException {
        return null;
    }

    public void destroy() throws RpcException {
    }
}

