/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend.filter.limit;

import com.meidusa.venus.Filter;
import com.meidusa.venus.Invocation;
import com.meidusa.venus.Result;
import com.meidusa.venus.URL;
import com.meidusa.venus.backend.ServerInvocation;
import com.meidusa.venus.exception.RpcException;
import com.meidusa.venus.support.VenusUtil;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class ServerActivesLimitFilter
implements Filter {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private static Map<String, AtomicInteger> methodActivesMapping = new ConcurrentHashMap<String, AtomicInteger>();
    private static final String LIMIT_TYPE_ACTIVE = "active_limit";
    private static final String LIMIT_TYPE_TPS = "tps_limit";
    private static final int DEFAULT_ACTIVES_LIMIT = 5;

    public void init() throws RpcException {
    }

    public Result beforeInvoke(Invocation invocation, URL url) throws RpcException {
        try {
            boolean isExceedActiveLimit;
            ServerInvocation serverInvocation = (ServerInvocation)invocation;
            if (!this.isEnableActiveLimit(serverInvocation, url)) {
                return null;
            }
            String methodPath = VenusUtil.getMethodPath((Invocation)serverInvocation);
            AtomicInteger activeLimit = methodActivesMapping.get(methodPath);
            if (activeLimit == null) {
                activeLimit = new AtomicInteger(0);
                methodActivesMapping.put(methodPath, activeLimit);
            }
            if (isExceedActiveLimit = this.isExceedActiveLimit(methodPath, activeLimit)) {
                throw new RpcException("exceed actives limit.");
            }
            activeLimit.incrementAndGet();
            methodActivesMapping.put(methodPath, activeLimit);
            return null;
        }
        catch (RpcException e) {
            throw e;
        }
        catch (Throwable e) {
            if (exceptionLogger.isErrorEnabled()) {
                exceptionLogger.error("ServerActivesLimitFilter.beforeInvoke error.", e);
            }
            return null;
        }
    }

    public Result throwInvoke(Invocation invocation, URL url, Throwable e) throws RpcException {
        return null;
    }

    public Result afterInvoke(Invocation invocation, URL url) throws RpcException {
        ServerInvocation serverInvocation = (ServerInvocation)invocation;
        if (!this.isEnableActiveLimit(serverInvocation, url)) {
            return null;
        }
        String methodPath = VenusUtil.getMethodPath((Invocation)serverInvocation);
        AtomicInteger activeLimit = methodActivesMapping.get(methodPath);
        if (activeLimit != null) {
            activeLimit.decrementAndGet();
            methodActivesMapping.put(methodPath, activeLimit);
            logger.info("after invoke methodActivesMapping:{}.", methodActivesMapping);
        }
        return null;
    }

    boolean isEnableActiveLimit(ServerInvocation invocation, URL url) {
        return false;
    }

    boolean isExceedActiveLimit(String methodPath, AtomicInteger activeLimit) {
        int actives = activeLimit.get();
        return actives > 5;
    }

    public void destroy() throws RpcException {
    }
}

