/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.backend;

import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.net.ConnectionAcceptor;
import com.meidusa.toolkit.net.ConnectionManager;
import com.meidusa.toolkit.net.ConnectionObserver;
import com.meidusa.toolkit.net.MessageHandler;
import com.meidusa.toolkit.net.authenticate.server.AuthenticateProvider;
import com.meidusa.toolkit.net.factory.FrontendConnectionFactory;
import com.meidusa.venus.Protocol;
import com.meidusa.venus.VenusApplication;
import com.meidusa.venus.backend.authenticate.SimpleAuthenticateProvider;
import com.meidusa.venus.backend.handler.VenusServerConnectionObserver;
import com.meidusa.venus.backend.handler.VenusServerReceiveMessageHandler;
import com.meidusa.venus.backend.services.ServiceManager;
import com.meidusa.venus.exception.VenusConfigException;
import com.meidusa.venus.io.network.Venus4FrontendConnectionFactory;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.io.IOException;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;

public class VenusProtocol
implements Protocol,
InitializingBean {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private static boolean isRunning = false;
    private ConnectionAcceptor connectionAcceptor;
    private MessageHandler messageHandler;
    private ServiceManager serviceManager;
    private AuthenticateProvider authenticateProvider;
    private int port;
    private int coreThreads = 100;

    public VenusProtocol() {
        VenusApplication.addProtocol((Protocol)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.valid();
    }

    void valid() {
        if (this.port == 0) {
            throw new VenusConfigException("port property not config.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        Class<VenusProtocol> clazz = VenusProtocol.class;
        synchronized (VenusProtocol.class) {
            if (!isRunning) {
                if (this.connectionAcceptor == null) {
                    this.connectionAcceptor = this.createConnectionAcceptor();
                    this.connectionAcceptor.start();
                }
                isRunning = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    ConnectionAcceptor createConnectionAcceptor() throws InitialisationException {
        VenusConnectionAcceptor connectionAcceptor = new VenusConnectionAcceptor();
        connectionAcceptor.setName("venus Acceptor-0");
        connectionAcceptor.setPort(this.port);
        int cpuCores = Runtime.getRuntime().availableProcessors();
        int perGroupCoreThread = this.coreThreads / cpuCores;
        if (perGroupCoreThread < cpuCores) {
            perGroupCoreThread = cpuCores;
        }
        connectionAcceptor.setExecutorSize(perGroupCoreThread);
        connectionAcceptor.setConnectionFactory(this.createConnectionFactory());
        return connectionAcceptor;
    }

    FrontendConnectionFactory createConnectionFactory() throws InitialisationException {
        MessageHandler messageHandler;
        Venus4FrontendConnectionFactory connectionFactory = new Venus4FrontendConnectionFactory();
        this.messageHandler = messageHandler = this.createMessageHandler();
        connectionFactory.setMessageHandler(messageHandler);
        connectionFactory.setAuthenticateProvider(this.getAuthenticateProvider());
        return connectionFactory;
    }

    MessageHandler createMessageHandler() throws InitialisationException {
        VenusServerReceiveMessageHandler messageHandler = new VenusServerReceiveMessageHandler();
        messageHandler.setServiceManager(this.serviceManager);
        return messageHandler;
    }

    public void destroy() throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info("detroy protocol:{}.", (Object)this);
        }
        if (this.connectionAcceptor != null) {
            this.connectionAcceptor.shutdown();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public AuthenticateProvider getAuthenticateProvider() {
        if (this.authenticateProvider == null) {
            SimpleAuthenticateProvider simpleAuthenticateProvider = new SimpleAuthenticateProvider();
            simpleAuthenticateProvider.setUseDummy(true);
            return simpleAuthenticateProvider;
        }
        return this.authenticateProvider;
    }

    public void setAuthenticateProvider(AuthenticateProvider authenticateProvider) {
        this.authenticateProvider = authenticateProvider;
    }

    public void setSrvMgr(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public int getCoreThreads() {
        return this.coreThreads;
    }

    public void setCoreThreads(int coreThreads) {
        this.coreThreads = coreThreads;
    }

    class VenusConnectionAcceptor
    extends ConnectionAcceptor {
        VenusConnectionAcceptor() {
        }

        public void initProcessors() throws IOException {
            if (this.processors == null) {
                this.processors = new ConnectionManager[Runtime.getRuntime().availableProcessors()];
                for (int i = 0; i < this.processors.length; ++i) {
                    this.processors[i] = new ConnectionManager(this.getName() + "-Manager-" + i, this.getExecutorSize());
                    this.processors[i].addConnectionObserver((ConnectionObserver)new VenusServerConnectionObserver());
                    this.processors[i].start();
                }
            }
        }
    }
}

