/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.validate.util.location;

import com.meidusa.venus.validate.util.PropertiesReader;
import com.meidusa.venus.validate.util.location.Locatable;
import com.meidusa.venus.validate.util.location.Location;
import com.meidusa.venus.validate.util.location.LocationImpl;
import com.meidusa.venus.validate.util.location.LocationUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class LocatableProperties
extends Properties
implements Locatable {
    private static final long serialVersionUID = 1L;
    Location location;
    Map<String, Location> propLocations;

    public LocatableProperties() {
        this((Location)null);
    }

    public LocatableProperties(Location loc) {
        this.location = loc;
        this.propLocations = new HashMap<String, Location>();
    }

    @Override
    public void load(InputStream in) throws IOException {
        InputStreamReader reader = new InputStreamReader(in);
        PropertiesReader pr = new PropertiesReader(reader);
        while (pr.nextProperty()) {
            String name = pr.getPropertyName();
            String val = pr.getPropertyValue();
            int line = pr.getLineNumber();
            String desc = this.convertCommentsToString(pr.getCommentLines());
            LocationImpl loc = new LocationImpl(desc, this.location.getURI(), line, 0);
            this.setProperty(name, val, loc);
        }
    }

    String convertCommentsToString(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        if (lines != null && lines.size() > 0) {
            for (String line : lines) {
                sb.append(line).append('\n');
            }
        }
        return sb.toString();
    }

    public Object setProperty(String key, String value, Object locationObj) {
        Object obj = super.setProperty(key, value);
        if (this.location != null) {
            Location loc = LocationUtils.getLocation(locationObj);
            this.propLocations.put(key, loc);
        }
        return obj;
    }

    public Location getPropertyLocation(String key) {
        return this.propLocations.get(key);
    }

    @Override
    public Location getLocation() {
        return this.location;
    }
}

